<script>
var workInfo;
$(function(){
	var protocolType = window.sessionStorage.getItem("protocolType");
	var showBatteryLine    = false;
	var haveInput          = false;
	var haveOutput         = false;
	var shutdownActive     = false;
	var oldShowbatteryLine = false;
	var oldHaveInput       = false;
	var oldHaveOutput      = false;
	var showSolar          = false;
	var oldShowSolar       = false;
	
	var isSolar			   = false;
	

	var customized;

	//Work Mode
	var WORK_MODE_POWER_ON_MODE = "Power on mode";
	var WORK_MODE_STANDBY_MODE = "Standby mode";
	var WORK_MODE_BYPASS_MODE = "Bypass mode";
	var WORK_MODE_LINE_MODE = "Line mode";
	var WORK_MODE_BATTERY_MODE = "Battery mode";
	var WORK_MODE_BATTERY_TEST_MODE = "Battery test mode";
	var WORK_MODE_FAULT_MODE = "Fault mode";
	var WORK_MODE_ECO_MODE = "ECO mode";
	var WORK_MODE_CONVERTER_MODE = "Converter mode";
	var WORK_MODE_SHUTDOWN_MODE = "Shutdown mode";
	var WORK_MODE_AVR_MODE = "AVR mode";

	//protocol type
	var PMV = "PMV";
	var P98 = "P98";
	var P00 = "P00";
	var P01 = "P01";
	var P02 = "P02";
	var P03 = "P03";
	var P04 = "P04";
	var P08 = "P08";
	var P09 = "P09";
	var P13 = "P13";
	var P14 = "P14";
	var P31 = "P31";
	var P33 = "P33";
	var P10 = "P10";
	var P35 = "P35";
	var P45 = "P45";
	var P36 = "P36";
	var P40 = "P40";
	var P71 = "P71";
	var TAURUS_MODBUS = "MODBUS";
	var TAURUS_SEC = "SEC";

	pollpowerflow();
	function pollpowerflow()
	{
		
		reqMonitorData();
		clearInterval(powerflow_interval_id);
		var dataAnalysisInterval = "<s:property value="globalConfig.dataAnalysisInterval"/>";
		powerflow_interval_id = setInterval(function(){
			reqMonitorData();
		},dataAnalysisInterval*1000);
	}

	function reqMonitorData()
	{
		var portName = window.sessionStorage.getItem("portName");
		$.ajax({
			type:"post",
			url:"<%=request.getContextPath()%>/workstatus/reqMonitorData?"+Math.random(),
			data:{"portName":portName},
			success:function(data){
				
				
				
				$(".disconnected").hide();
				 window.sessionStorage.setItem("monitorData",data);
				 if(data=="nologin"){
					 
					 
						$( "#login_dlg" ).dialog( "open" );
						return;
					}
				var monitorData = jQuery.parseJSON(data);
				var protocolType = window.sessionStorage.getItem("protocolType");
				if(monitorData.protocolType != protocolType){
					initMonitor();
				}else{
					//Tree
					var refreshTree = window.sessionStorage.getItem("refreshTree");
					var refreshSearchUPSTree = window.sessionStorage.getItem("refreshSearchUPSTree");
					if(monitorData.refreshTree != refreshTree || monitorData.refreshSearchUPSTree != refreshSearchUPSTree){
						window.sessionStorage.setItem("refreshTree",monitorData.refreshTree);
						window.sessionStorage.setItem("refreshSearchUPSTree",monitorData.refreshSearchUPSTree);
						initDeviceTree();
					}
					initpowerflow(monitorData);
				}
				monitorData = null;
			},
			error: function(xmlhttpreq, status, error){
				if(status == "error"){
					$(".disconnected").show();
				}
			},complete:function(XHR,TS){
				XHR = null;
			}         
	    });
	}
	
	function refleshInput(){
		//$(".input_info").children().next().children().remove();
		var data = window.sessionStorage.getItem("monitorData");
		if(data==null){
			return
		}
		var monitorData = jQuery.parseJSON(data);
		protocolType = monitorData.protocolType;
		IoPhase=monitorData.workInfo.ioPhase;
		if(protocolType=="P38"&&$(".input_info").children().next().children().length>2&&IoPhase=="1/1"){
			
			$(".input_info").children().next().children().first().next().remove();
			$(".input_info").children().next().children().first().next().remove();
		}

	
	}
	refleshInput();
	var t1 = window.sessionStorage.getItem("dataAnalysisInterval");
	refreInput = setInterval(refleshInput,5000); 
	
	function initpowerflow(monitorData)
	{
		var currentWork = monitorData.workInfo;
		customized      = monitorData.customized;
		shutdownActive = currentWork.shutdownActive;

		if(protocolType == TAURUS_MODBUS)
		{	
			$('#_fonts').css({"font-size":"13px"});
			$('.ups_info').css({"position": "absolute","top":"-60px","left": "420px"});
			$('.ups_info div:eq(0)').css({"width":"350px"});
			$('.ups_info div:eq(1)').css({"width":"350px"});
			var cap = monitorData.capability;
			if(cap.capable25b8 || cap.capable26b1 || currentWork.positiveBatteryVoltage < 100){ // ���������������������������������������������100������������������������������������������   modify by fujia on 2013-01-29   
				showBatteryLine = false;
			}else{
				showBatteryLine = true;
			}
			if(currentWork.inputVoltage > 20 || currentWork.inputVoltageS > 20 || currentWork.inputVoltageT > 20)
			{
				haveInput = true;	
			}
			else
			{
				haveInput = false;
			}
			if(currentWork.outputVoltage > 20 || currentWork.outputVoltageS > 20 || currentWork.outputVoltageT > 20)
			{
				haveOutput = true;
			}
			else
			{
				haveOutput = false;
			}
			showLineModbus(currentWork);
			workInfo=currentWork;
		}
		else if(protocolType == TAURUS_SEC)
		{
			if(currentWork.batteryRemainTime > 0){
				showBatteryLine = true;
			}else{
				showBatteryLine = false;
			}
			
			if(currentWork.inputVoltage > 20 || currentWork.inputVoltageS > 20 || currentWork.inputVoltageT > 20){
				haveInput = true;	
			}else{
				haveInput = false;
			}
			if(currentWork.outputVoltage > 20 || currentWork.outputVoltageS > 20 || currentWork.outputVoltageT > 20){
				haveOutput = true;
			}else{
				haveOutput = false;
			}
			showLineModbus(currentWork);
			workInfo=currentWork;
		}
		else
		{	
			if((protocolType=="P71" && currentWork.solar==true)||protocolType=="P73"){
				isSolar = true;
				console.log("currentWork.solarON"+currentWork.solarON)
				if(currentWork.solarON==true){
					showSolar = true;
				}
				if(currentWork.solarON==false){
					showSolar = false;
					$(".solarinput").hide();
					
				}
				$(".statusbg2").css("display","block");
				$(".statusbg").css("display","none");
				$(".battery_info").css("top","429px");
				$(".battery_info").css("left","150px");
				$(".solar_info").css("top","359px");
				$(".solar_info").css("left","-230px");
				$(".input_info").css("top","-30px");
				$(".input_info").css("left","-218px");
				$(".solar_info").css("display","block");
			}else{
				$(".statusbg").css("display","block");
				$(".statusbg2").css("display","none");
				$(".solar_info").css("display","none");
				isSolar = false;
			}
			
			//if(protocolType == "PMV" && currentWork.upsType=="I"){
			if(currentWork.upsType=="PMVJ"){
				$("#cpuSpeed").val(currentWork.cpuInfo.speed);
				$("#cpuTemp").val(currentWork.cpuInfo.temp);
				$("#cpuLoad").val(currentWork.cpuInfo.load);
			}
			
			
			if(currentWork.warnings!=null && (protocolType != "P71" && currentWork.warnings.indexOf("a13:[warning.a13]") != -1 || currentWork.warnings.indexOf("a0:[warning.a0]") != -1) ||
					currentWork.faultKind == "45" || (protocolType == "P31" && currentWork.faultKind == "56")||(protocolType == "P40" && currentWork.warnings.indexOf("a3:[warning.a3]") != -1)
					||(protocolType == "P71" && currentWork.warnings.indexOf("a7:[warning.a7]") != -1))
			{
				showBatteryLine = false;
			}
			else
			{
				showBatteryLine = true;
			}
		
			if(currentWork.inputVoltage > 20 || currentWork.inputVoltageS > 20 || currentWork.inputVoltageT > 20)
			{	
				haveInput = true;	
			} 
			else 
			{
				haveInput = false;
			}
			
			if(currentWork.outputVoltage > 20 || currentWork.outputVoltageS > 20 || currentWork.outputVoltageT > 20)
			{
				haveOutput = true;
			}
			else
			{
				haveOutput = false;
			}
			
			showLineOther(currentWork);
			workInfo=currentWork;
		}
		
		var input = monitorData.statuspowerflow.input;
		var output = monitorData.statuspowerflow.output;
		var battery = monitorData.statuspowerflow.battery;
		var upsInfo = monitorData.statuspowerflow.upsInfo;
		var bypass = monitorData.statuspowerflow.bypassInfoLines;
		var solar = monitorData.statuspowerflow.solarInfoLines;
		showStatusVal(input,output,battery,upsInfo,bypass,solar);
	}

	function showStatusVal(input,output,battery,upsInfo,bypass,solar)
	{
		//input
		$.each(input,function(i,item){
			var elementId = "powerflow_"+item.caption;
			var element = document.getElementById(elementId);
			var replace =item.textvalue.substring(1,item.textvalue.length-1);		
			var classmtd = new Array();
	        classmtd = replace.split(".");
	        var method = classmtd[1];
	        var a =eval("workInfo."+method);
	       
	       	if(!isNaN(a) && a!="" && a!=null){
	       		a =Number(a);
	       	}
	       	$(element).val(a);
		});
		
		//output
		$.each(output,function(i,item){
			var elementId =  "powerflow_"+item.caption;
			var element = document.getElementById(elementId);
			var replace =item.textvalue.substring(1,item.textvalue.length-1);		
			var classmtd = new Array();
	        classmtd = replace.split(".");
	        var method = classmtd[1];
	          var a =eval("workInfo."+method);
	         	if(!isNaN(a) && a!="" && a!=null){
	         		a =Number(a);
	         	}
	         	$(element).val(a);
		});
		
		//battery
		$.each(battery,function(i,item){
			var elementId =  "powerflow_"+item.caption;
			var element = document.getElementById(elementId);
			var replace =item.textvalue.substring(1,item.textvalue.length-1);		
			var classmtd = new Array();
	        classmtd = replace.split(".");
	        var method = classmtd[1];
	        var a =eval("workInfo."+method);
	       	if(!isNaN(a) && a!="" && a!=null){
	       		a =Number(a);
	       	}
	       	$(element).val(a);
		});
		
		//upsInfo
		$.each(upsInfo,function(i,item){
			var elementId =  "powerflow_"+item.caption;
			var element = document.getElementById(elementId);
			
			var replace =item.textvalue.substring(1,item.textvalue.length-1);		
			var classmtd = new Array();
	        classmtd = replace.split(".");
	        var method = classmtd[1];
	        var a =eval("workInfo."+method);
	       	if(!isNaN(a) && a!="" && a!=null){
	       		a =Number(a);
	       	}
	       	$(element).val(a);
		});
		//bypass
	    if(bypass!=null){
			$.each(bypass,function(i,item){
				var elementId =  "powerflow_"+item.caption;
				var element = document.getElementById(elementId);
				var replace =item.textvalue.substring(1,item.textvalue.length-1);		
				var classmtd = new Array();
		        classmtd = replace.split(".");
		        var method = classmtd[1];
		        var a =eval("workInfo."+method);
		       	if(!isNaN(a) && a!="" && a!=null){
		       		a =Number(a);
		       	}
		       	$(element).val(a);
			});
	    }
		
		//solar
	    if(solar!=null){
			$.each(solar,function(i,item){
				var elementId =  "powerflow_"+item.caption;
				var element = document.getElementById(elementId);
				var replace =item.textvalue.substring(1,item.textvalue.length-1);		
				var classmtd = new Array();
		        classmtd = replace.split(".");
		        var method = classmtd[1];
		        var a =eval("workInfo."+method);
		       	if(!isNaN(a) && a!="" && a!=null){
		       		a =Number(a);
		       	}
		       	$(element).val(a);
			});
	    }
	    $(".common input[type='text']").attr("readonly","readonly");
	    $("#internetIp input").attr("readonly",false);
	}

	function showLineModbus(modbus)
	{
		if(modbus.workMode)
		{
			if(!workInfo || workInfo.workMode!=modbus.workMode 
					|| oldShowbatteryLine != showBatteryLine
					|| oldHaveInput != haveInput
					|| oldHaveOutput != haveOutput)
			{
				oldShowbatteryLine = showBatteryLine;
				oldHaveInput = haveInput;
				oldHaveOutput = haveOutput;
			
				switch(modbus.workMode)
				{	
					case WORK_MODE_LINE_MODE:
						showTaurusLineMode();
						break;
					case WORK_MODE_BATTERY_MODE:
						showBatteryMode();
						break;
					case WORK_MODE_BATTERY_TEST_MODE:
						showBatteryTestMode();
						break;
					case WORK_MODE_STANDBY_MODE:
						
						showStandByMode();
						break;
					case WORK_MODE_BYPASS_MODE:
						showTaurusBypassMode();
						break;
					case WORK_MODE_FAULT_MODE:
						showFaultMode();
						break;
				}
			}
		}
		else
		{
			clear();
		}
	}

	function showLineOther(currentWork)
	{
		if(!currentWork || !currentWork.workMode)
		{
			return;
		}
		
		if(!workInfo ||workInfo.workMode!=currentWork.workMode||workInfo.bypassActive!=currentWork.bypassActive
				  || oldShowbatteryLine != showBatteryLine
				  || oldHaveInput != haveInput
				  || oldHaveOutput != haveOutput || oldShowSolar != showSolar||oldShowSolar!=showSolar)
		{
			oldShowbatteryLine = showBatteryLine;
		  	oldHaveInput = haveInput;
			oldHaveOutput = haveOutput;
			oldShowSolar =showSolar;
			if(currentWork.morphological=="standby"||currentWork.morphological=="line-interactive")
			{	
				switch(currentWork.workMode)
				{
					case WORK_MODE_AVR_MODE:
						showBypassActiveMode();
						break;
					case WORK_MODE_LINE_MODE:
						if(protocolType == PMV || protocolType == P00 || protocolType == P31 || protocolType == P98)
						{
							showBypassActiveMode();
						}
						else
						{	
							showLineMode();
						}
						break;
					case WORK_MODE_BYPASS_MODE:
						if(currentWork.inputVoltage>=25||protocolType=="P73"){
							if(currentWork.bypassActive){
								showBypassActiveMode();
							}else{
								showBypassInactiveMode();
							}
						}else{
							clear();
						}
						break;
					case WORK_MODE_BATTERY_MODE:
						showBatteryMode();
						break;
					case WORK_MODE_BATTERY_TEST_MODE:
						showBatteryTestMode();
						break;
					case WORK_MODE_STANDBY_MODE:
						console.log("wsm")
						if(currentWork.inputVoltage>=25||protocolType=="P73"){
							if(customized=="Emerson")
							{
								showBypassActiveMode();
							}
							else
							{	
								showStandByMode();
							}
							
						}else{
							clear();
						}
						break;
					case WORK_MODE_FAULT_MODE:
						if(currentWork.outputVoltage>=25){
							if(currentWork.bypassActive){
								showBypassActiveFaultMode();
							}else{
								showBypassInactiveFaultMode();
							}
						}else{
							showBypassInactiveFaultMode();
						}
						break;
				}
			}
			else if(currentWork.morphological=="on-line")
			{	
				switch(currentWork.workMode)
				{
					case WORK_MODE_AVR_MODE:
						showBypassActiveMode();
						break;
					case WORK_MODE_LINE_MODE:
						if(protocolType=="P71" && isSolar){
							showLineOnSolar(currentWork);
							
						}else{
							if(protocolType == PMV || protocolType == P00 || protocolType == P31)
							{
								if(currentWork.inputVoltage>=25||protocolType=="P73")
								{
									if(currentWork.bypassActive)
									{
										showBypassActiveMode();
									}
									else
									{
										showBypassInactiveMode();
									}
								}
								else
								{
									clear();
								}
							}
							else
							{	
								showLineMode();
							}
						}
						break;
					case WORK_MODE_BATTERY_MODE:
						showBatteryMode();
						break;
					case WORK_MODE_BATTERY_TEST_MODE:
						showBatteryTestMode();
						break;
					case WORK_MODE_STANDBY_MODE:
						if(protocolType=="P71" && isSolar){
							showOnSolar(currentWork,"SP");
						}else{
							if(currentWork.inputVoltage>=25||protocolType=="P73")
							{
								if(customized=="Emerson")
								{
									showBypassActiveMode();
								}
								else
								{	
									showStandByMode();
								}
							}else{
								clear();
							}
						}

						break;
					case WORK_MODE_POWER_ON_MODE:
						if(protocolType=="P71" && isSolar){
							showOnSolar(currentWork,"SP");
						}else{
							if(currentWork.inputVoltage>=25||protocolType=="P73")
							{
								if(customized=="Emerson")
								{
									showBypassActiveMode();
								}
								else
								{	
									showStandByMode();
								}
							}else{
								clear();
							}
						}

						break;
					case WORK_MODE_BYPASS_MODE:
						if(protocolType=="P71" && isSolar){
							showOnSolar(currentWork,"YFE");
						}else{
							if(currentWork.inputVoltage>=25||currentWork.bypassVoltage>25||protocolType=="P73"){
								if(protocolType=="P71"){
									showBypassOnSolar();
								}else{
									if(currentWork.bypassActive)
									{
										showBypassActiveMode();
									}
									else
									{
										showBypassInactiveMode();
									}
									
								}

							}
							else
							{
								clear();
							}
						}
						
						break;
					case WORK_MODE_FAULT_MODE:
						if(protocolType=="P71" && isSolar){
							showOnSolar(currentWork,"YFE");
						}else if(protocolType=="P71"){
							if(currentWork.outputON){
								showBypassActiveFaultMode();
							}else{
								showBypassInactiveFaultMode();
							}
						}else{
							if(currentWork.outputVoltage>=25)
							{
								if(currentWork.bypassActive)
								{
									showBypassActiveFaultMode();
								}
								else
								{
									showBypassInactiveFaultMode();
								}
							}
							else
							{
								showBypassInactiveFaultMode();
							}
						}
						break;
					case WORK_MODE_CONVERTER_MODE:
						showLineMode();
						break;
					case WORK_MODE_ECO_MODE:
						
						if(protocolType=="P71" && isSolar){
							showOnSolar(currentWork,"YFE");
						}else{
							showBypassActiveFaultMode();
						}
						break;
				}
			}
			else
			{
				clear();
			}
		}
		
	}

	function showBypassOnSolar(){
		clear();
		$(".upVline").show();
		$(".bypass").show();
		$(".bypassdownVline").show();
		$(".input").show();
		$(".outputbypass").show();
		if(showBatteryLine)
		{
			if(showSolar){
				$(".downVline2").show();
				
				$(".solarInput").show();
			}else{
				$(".downVline").show();
			}
		}
	}
	
	function showBypassActiveMode()
	{
		clear();
		$(".input").show();
		$(".upVline").show();
		$(".bypass").show();
		$(".bypassdownVline").show();
		$(".outputbypass").show();
		if(showBatteryLine && isSolar)
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
		}else if(showBatteryLine && protocolType != TAURUS_MODBUS)
		{
			$(".downVline").show();
			}
	}

	function showLineMode()
	{	
		clear();
		$(".input").show();
		$(".output").show();
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
		}else if(showBatteryLine)
		{
			$(".downVline").show();
		}
	}

	function showBypassInactiveMode()
	{
		clear();
		$(".input").show();
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
			
		}else if(showBatteryLine){
			$(".downVline").show();
		}
	}

	function showBatteryMode()
	{
		clear();
		if(haveOutput)
		{
			$(".output").show();
		}
		
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{	
			$(".batupVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
			
		}else if(showBatteryLine){
			$(".batupVline").show();
		}
	}

	function showBatteryTestMode()
	{
		clear();
		
		if(haveInput)
		{
			$(".inputbypass").show();
		}
		if(haveOutput)
		{
			$(".output").show();
		}
		
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
			
		}else if(showBatteryLine){
			$(".downVline").show();
		}
		
	}
// S/P/Y/F/E
	function showOnSolar(currentWork,mode){
		clear();
		if(mode=="YFE"){
			if(currentWork.outputON){
				$(".upVline").show();
				$(".bypass").show();
				$(".bypassdownVline").show();
				$(".outputbypass").show();
			}
		}
		if(haveInput){
			$(".input").show();
		}
		if(currentWork.solarON&&currentWork.chargeON){
			
			$(".downVline2").show();
			$(".solarInput").show();
		}else if(currentWork.solarON){
			$(".solarInput").show();
			$(".solarDown").show();
		}else{
			if(showBatteryLine){
				$(".downVline2").show();
			}
		}
	}
	
//  l	
	function showLineOnSolar(currentWork){
		clear();
		$(".input").show();
		if(showBatteryLine){
			$(".downVline2").show();
		}
		if(currentWork.solarON){
			$(".solarInput").show();
			$(".downVline2").hide();
			$(".downUP_pv").show();
		}else{
			$(".downVline2").show();
		}
		if(currentWork.outputON){
			$(".output").show();
		}
	}
	

//  B	
	function showBatteryOnSolar(currentWork){
		clear();
		$(".batupVline2").show();
		$(".output").show();
		if(!currentWork.solarON){
			$(".batupVline2").show();
		}else{
			$(".solarInput").show();
			if(currentWork.dischargeCurr>0){
				$(".downVline2").hide();
				$(".batupVline2").show();
			}
		}
	}

	function showStandByMode()
	{	console.log("showSolar"+showSolar)
		clear();
		if(protocolType == TAURUS_MODBUS || protocolType == TAURUS_SEC)
		{
			if(haveInput)
			{
				$(".inputbypass").show();
			}
		}
		else if(protocolType=="P73"){
			if(haveInput)
			{
				$(".input").show();
			}
		}
		else
		{
			$(".input").show();
		}
		if(protocolType == P31){
			if(showBatteryLine && shutdownActive)
			{
				$(".downVline").show();
			}
		}
		else
		{
			if(showBatteryLine && (isSolar||protocolType=="P73"))
			{
				$(".downVline2").show();
				if(showSolar){
					$(".solarInput").show();
				}
				
			}else if(showBatteryLine){
				$(".downVline").show();
			}
		}
	}

	function showBypassActiveFaultMode()
	{
		clear();
		$(".upVline").show();
		$(".bypass").show();
		$(".bypassdownVline").show();
		$(".input").show();
		$(".outputbypass").show();
		
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
			
		}else if(showBatteryLine && protocolType != P31){
			$(".downVline").show();
		}
		
	}

	function showBypassInactiveFaultMode()
	{
		clear();
		if(haveInput)
		{
			$(".input").show();
		}
		
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
			
		}else if(showBatteryLine && protocolType != P31){
			$(".downVline").show();
		}
	}

	function showTaurusLineMode()
	{
		clear();
		if(haveInput)
		{
			$(".input").show();
		}
		if(haveOutput)
		{
			$(".output").show();
		}
		if(showBatteryLine)
		{
			$(".downVline").show();
		}
	}

	function showTaurusBypassMode()
	{
		clear();
		if(haveInput)
		{
			$(".inputbypass").show();
			$(".upVline").show();
			$(".bypass").show();
			$(".bypassdownVline").show();
		}
		if(haveOutput)
		{
			$(".outputbypass").show();
		}
	}

	function showFaultMode()
	{
		clear();
		if(protocolType != TAURUS_MODBUS){
			if(haveInput)
			{
				$(".input").show();
			}
		}
		
		if(showBatteryLine && (isSolar||protocolType=="P73"))
		{
			$(".downVline2").show();
			if(showSolar){
				$(".solarInput").show();
			}
		}else if(showBatteryLine && protocolType != P31){
			$(".downVline").show();
		}
	}

	function clear()
	{
		$(".inputbypass").hide();
		$(".input").hide();
		$(".upVline").hide();
		$(".batupVline").hide();
		$(".bypass").hide();
		$(".bypassdownVline").hide();
		$(".outputbypass").hide();
		$(".output").hide();
		$(".downVline").hide();
		$(".downVline2").hide();
		$(".batupVline2").hide();
		$(".solarInput").hide();
		$(".downUP_pv").hide();
		$(".solarDown").hide();
		
	}
});

 $(function(){
	if($('.bypass_info div:eq(1)').height()==0){
		$('.bypass_info').hide();
	}else{
		$('.bypass_info').show();
		$('#_fonts').css('font-size','13px');
	}
}) 

</script>