<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<div id="password_dlg" title="<s:text name="label.passwordSet"></s:text>">
			<table style="margin: 0 auto;">
				<tr>
					<td align="right"><s:text name="label.username"></s:text></td>
					<td>
						<input type="text" name="username" value="<s:text name="label.localManager"></s:text>" style="text-align: center;" readonly/>
					</td>
				</tr>
				<tr>
					<td align="center" colspan="2"></td>
				</tr>
				<tr>
					<td align="right"><s:text name="label.setNewPassword"></s:text></td>
					<td>
						<input type="password" id="newPassword" name="newPassword" />
					</td>
				</tr>
				<tr>
					<td align="center" colspan="2">
						<span id="newPasswordMsg" style="color: red;"></span>
					</td>
				</tr>
				<tr>
					<td align="right"><s:text name="label.repeatPassword"></s:text></td>
					<td>
						<input type="password" id="repPassword" name="repPassword" />
					</td>
				</tr>
				<tr>
					<td align="center" colspan="2">
						<span id="passwordMsg" style="color: red;"></span>
					</td>
				</tr>
			</table>
		</div>
<script>

$("#btnchgpassword").click(function(){
	$( "#password_dlg" ).dialog( "open" );
});

$( "#password_dlg" ).dialog({
	autoOpen: false,
	modal:true,
	width: 400,
	buttons: [
		{
			text: "<s:text name="label.apply"></s:text>",
			click: function() {
				passwordValidate();
			}
		},
		{
			text: "<s:text name="label.reset"></s:text>",
			click: function() {
				passwordClear();
			}
		},
		{
			text: "<s:text name="label.cancel"></s:text>",
			click: function() {
				$( this ).dialog( "close" );
				passwordClear();
			}
		}
	]
});

function passwordValidate()
{
	var newPassword = $("#newPassword").val().trim();
	var repPassword = $("#repPassword").val().trim();
	
	$("#newPasswordMsg").text("");
	$("#passwordMsg").text("");
	var validate = true;
	
	if(newPassword == "")
	{
		$("#newPasswordMsg").text("<s:text name="alert.inputNewPsw"></s:text>");
		validate = false;
	}
	else if(newPassword.length < 6)
	{
		$("#newPasswordMsg").text("<s:text name="alert.pswLess6"></s:text>");
		validate = false;
	}
	if(repPassword == "")
	{
		$("#passwordMsg").text("<s:text name="alert.inputRptPsw"></s:text>");
		validate = false;
	}
	else if(repPassword.length < 6)
	{
		$("#passwordMsg").text("<s:text name="alert.pswLess6"></s:text>");
		validate = false;
	}
	
	if(!validate)
	{
		return;
	}
	
	if(newPassword != repPassword)
	{
		$("#passwordMsg").text("<s:text name="alert.notSame"></s:text>");
		validate = false;
	}
	if(!validate)
	{
		return;
	}
	updatePassword(newPassword);
}

function updatePassword(password)
{
	var url = "<%=request.getContextPath()%>/login/updatePassword?"+Math.random();
	$.ajax({
		type:"post",
		url:url,
		data:{"password":password},
		success:function(data){
			if(data == "true")
			{
				$( "#password_dlg" ).dialog( "close" );
				passwordClear();
				tag("","<s:text name="text.modPswSuc"></s:text>");
			}
			else
			{
				tag("","<s:text name="alert.setFalse"></s:text>");
			}
		},
		error: function(e){
		}         
    });

	logout();
	var data= window.sessionStorage.getItem("monitorData");
	var monitorData = jQuery.parseJSON(data);
	if(monitorData.customer=="WattBox"){
		 window.sessionStorage.setItem("monitorData","nologin");
		initMonitor();
	}
	
}

function passwordClear()
{
	$("#newPassword").val("");
	$("#repPassword").val("");
	$("#newPasswordMsg").text("");
	$("#passwordMsg").text("");
}

</script>