<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<%@ include file="/../css/tab.jsp"%>
<%@ include file="/../script/tab.jsp"%>
<div class="tab">
	<ul class="tabs">
		<li onclick="initEventRecord();"><a href="#"><s:text name="text.eventRecord"></s:text></a></li>
		<li onclick="initEventStats();"><a href="#"><s:text name="text.eventStat"></s:text></a></li>
		<li onclick="initHistoryData();"><a href="#"><s:text name="text.hisData"></s:text></a></li>
		<li onclick="initHistoryChart();"><a href="#"><s:text name="text.hisGraph"></s:text></a></li>
	</ul>
	<div class="tab_content">
		
		<div class="tabs_item" id="EventRecord" style="padding: 0;">
		</div>

		<div class="tabs_item" id="EventStats" style="padding: 0;">
		</div>

		<div class="tabs_item" id="HistoryData" style="padding: 0;">
		</div>
		
		<div class="tabs_item" id="HistoryChart" style="padding: 0;">
		</div>
	</div>
</div>
<script>
initialize();

function initialize()
{
	initEventRecord();
	//initEventStats();
	//initHistoryData();
	//initHistoryChart();
}

function getProdids(port, type)
{
	var url = "<%=request.getContextPath()%>/history/getProdids?"+Math.random();
	$.post(url,{"port":port, "type":type},function(data){
		data = jQuery.parseJSON(data);
		if(type=="EventRecord"){
			$("#prodids_EventRecord").empty();
			$.each(data,function(key,value){
				$("#prodids_EventRecord").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="EventStats"){
			$("#prodids_EventStats").empty();
			$.each(data,function(key,value){
				$("#prodids_EventStats").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="HistoryData"){
			$("#prodids_HistoryData").empty();
			$.each(data,function(key,value){
				$("#prodids_HistoryData").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="HistoryChart"){
			$("#prodids_HistoryChart").empty();
			$.each(data,function(key,value){
				$("#prodids_HistoryChart").append("<option value='"+value+"'>"+value+"</option>");
			});
		}
		onProdidChange(type);
	});
}


function onProdidChange(type)
{
	if(type == "EventRecord"){
		var port = $("#ports_EventRecord").val();
		var prodid = $("#prodids_EventRecord").val();
		if((prodid == "P33")||(prodid=="P39")){
			$("#snstd_EventRecord").show();
			getSNs(port, prodid, type);
		}else{
			$("#snstd_EventRecord").hide();
		}
	}else if(type == "EventStats"){
		var port = $("#ports_EventStats").val();
		var prodid = $("#prodids_EventStats").val();
		if((prodid == "P33")||(prodid=="P39")){
			$("#snstd_EventStats").show();
			getSNs(port, prodid, type);
		}else{
			$("#snstd_EventStats").hide();
		}
	}else if(type == "HistoryData"){
		var port = $("#ports_HistoryData").val();
		var prodid = $("#prodids_HistoryData").val();
		if((prodid == "P33")||(prodid=="P39")){
			$("#snstd_HistoryData").show();
			getSNs(port, prodid, type);
		}else{
			$("#snstd_HistoryData").hide();
		}
	}else if(type == "HistoryChart"){
		var port = $("#ports_HistoryChart").val();
		var prodid = $("#prodids_HistoryChart").val();
		if((prodid == "P33")||(prodid=="P39")){
			$("#snstd_HistoryChart").show();
			getSNs(port, prodid, type);
		}else{
			$("#snstd_HistoryChart").hide();
		}
	}
}

function getSNs(port, prodid, type)
{
	var url = "<%=request.getContextPath()%>/history/getSNs?"+Math.random();
	$.post(url,{"port":port, "prodid":prodid, "type":type},function(data){
		data = jQuery.parseJSON(data);
		if(type=="EventRecord"){
			$("#sns_EventRecord").empty();
			$.each(data,function(key,value){
				$("#sns_EventRecord").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="EventStats"){
			$("#sns_EventStats").empty();
			$.each(data,function(key,value){
				$("#sns_EventStats").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="HistoryData"){
			$("#sns_HistoryData").empty();
			$.each(data,function(key,value){
				$("#sns_HistoryData").append("<option value='"+value+"'>"+value+"</option>");
			});
		}else if(type=="HistoryChart"){
			$("#sns_HistoryChart").empty();
			$.each(data,function(key,value){
				$("#sns_HistoryChart").append("<option value='"+value+"'>"+value+"</option>");
			});
		}
	});
}

function initEventRecord()
{
	var url = "<%=request.getContextPath()%>/history/initEventRecord?"+Math.random();
	$("#EventRecord").load(url);
}

function initEventStats()
{
	var url = "<%=request.getContextPath()%>/history/initEventStats?"+Math.random();
	$("#EventStats").load(url);
}

function initHistoryData()
{
	var url = "<%=request.getContextPath()%>/history/initHistoryData?"+Math.random();
	$("#HistoryData").load(url);
}

function initHistoryChart()
{
	var url = "<%=request.getContextPath()%>/history/initHistoryChart?"+Math.random();
	$("#HistoryChart").load(url);
}
function onPortChange(type)
{
   if(type == "EventRecord"){
      var port = $("#ports_EventRecord").val();
      getProdids(port,type);
   }else if(type == "EventStats"){
      var port = $("#ports_EventStats").val();
      getProdids(port,type);
   }else if(type == "HistoryData"){
      var port = $("#ports_HistoryData").val();
      getProdids(port,type);
   }else if(type == "HistoryChart"){
      var port = $("#ports_HistoryChart").val();
      getProdids(port,type);
   }
  
}
 
</script>