<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<table id="HistoryDataTable" class="display cell-border" style="table-layout:fixed;width: 100%;">
	<thead>
		<tr>
			<th><s:text name="label.rowNum"></s:text></th>
			<s:iterator value="dataHeads" var="head">
				<th>
					<s:text name="%{#head.headertext.replace(']',' ').replace('[',' ').replace(':',' ').trim()}"></s:text>
				</th>
			</s:iterator>
			<th style="display: none;"></th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<th><s:text name="label.rowNum"></s:text></th>
			<s:iterator value="dataHeads" var="head">
				<th>
					<s:text name="%{#head.headertext.replace(']',' ').replace('[',' ').replace(':',' ').trim()}"></s:text>
				</th>
			</s:iterator>
			<th style="display: none;"></th>
		</tr>
	</tfoot>
	<tbody>
		<s:iterator value="dataFields" var="fields" status="status">
			<tr>
				<td>
					<s:property value="#status.index+1"/>
				</td>
				<s:iterator value="#fields.columns" var="field">
					<td>
						<s:property value="#field.datafield"/>
					</td>
				</s:iterator>
				<td  style="display: none;">
					<s:property value="#fields.colid"/>
				</td>
			</tr>
		</s:iterator>
	</tbody>
</table>
<script>

var HistoryDataTable = $("#HistoryDataTable").DataTable({
	 jQueryUI :      true,
	 searching:      true,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 ordering:       true,
	 scrollY:        "450px",
	 scrollX:        '100%',
	 Paginate:        true,
	 autoWidth:       false,
	 aoColumnDefs : [  
	                 {  
	                     "aTargets" :["_all"],  
	                     "sWidth": "120px",
	                 }],
	 language:       {"emptyTable":"<s:text name=" "></s:text>","search":"<s:text name="message.search"></s:text>"}
});
$('#HistoryDataTable tbody').on( 'mouseover', 'tr', function () {
    $(this).css("cursor","pointer");
} );

$('#HistoryDataTable tbody').on( 'click', 'tr', function () {
     $('#HistoryDataTable tbody tr.selected').removeClass('selected');
     $(this).addClass('selected');
} );
</script>