<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<div class="page" style="font-size: smaller;">
	<table style="margin: 0 auto;">
		<tr>
			<td>
				UPS
			</td>
			<td>
				<select id="ports_EventStats" class="dropdown" onchange="onPortChange('EventStats')">
					<s:iterator value="ports" var="port">
						<option value="<s:property value="#port"/>">
							<s:if test="#port.indexOf('USB') != -1">
								USB id=(<s:property value="#port.substring(3)"/>)
							</s:if>
							<s:else>
								<s:property value="#port"/>
							</s:else>
						</option>
					</s:iterator>
				</select>
			</td>
			<td>
				<select id="prodids_EventStats" class="dropdown" onchange="onProdidChange('EventStats');">
				
				</select>
			</td>
			<td id="snstd_EventStats" style="display: none;">
				<select id="sns_EventStats" class="dropdown" style="max-width:160px">
				
				</select>
			</td>
			<td>
				<div style="margin: 2px;">
					<s:text name="label.timePeriod"></s:text>A
					<input id="startDateA_EventStats" type="text" readonly class="text" style="width: 143px;"/> --
					<input id="endDateA_EventStats" type="text" readonly class="text" style="width: 143px;"/>
				</div>
				<div style="margin: 2px;">
					<s:text name="label.timePeriod"></s:text>B
					<input id="startDateB_EventStats" type="text" readonly class="text" style="width: 143px;"/> --
					<input id="endDateB_EventStats" type="text" readonly class="text" style="width: 143px;"/>
				</div>
			</td>
			<td>
				<button class="btn white" onclick="qryEventStats();"><s:text name="text.view"></s:text></button>
			</td>
		</tr>
	</table>
</div>
<div id="EventStatsList" style="font-size: 0.9em;">
	<table id="EventStatsTable" class="display cell-border" style="table-layout:fixed;width:100%">
	<thead>
		<tr>
			<th class="eventwidth1" >
				<s:text name="text.mv.esCol1"></s:text>
			</th>
			<th class="eventwidth2">
				<s:text name="lable.level"></s:text>
			</th>
			<th class="eventwidth" >
				<s:text name="label.timePeriod"></s:text>A
			</th>
			<th  class="eventwidth">
				<s:text name="label.timePeriod"></s:text>B
			</th>
			<th class="eventwidth" >
				<s:text name="label.change"></s:text>
			</th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<th class="eventwidth1">
				<s:text name="text.mv.esCol1"></s:text>
			</th>
			<th class="eventwidth2">
				<s:text name="lable.level"></s:text>
			</th>
			<th class="eventwidth" >
				<s:text name="label.timePeriod"></s:text>A
			</th>
			<th class="eventwidth" >
				<s:text name="label.timePeriod"></s:text>B
			</th>
			<th class="eventwidth" >
				<s:text name="label.change"></s:text>
			</th>
		</tr>
	</tfoot>
	<tbody id="eventsList">
		
	</tbody>
</table>

</div>

<script>
var startDateA=new Date().getFullYear()+"-"+(new Date().getMonth()+1)+"-"+new Date().getDate(); 
var startDateB=startDateA;
var endDateA =startDateA;
var endDateB=startDateA;
var dateformat = window.sessionStorage.getItem("dateFormat");
initEventStatsPage();
//qryEventStats();

$("#EventStatsTable").DataTable({
	 jQueryUI :      true,
	 searching:      true,
    scrollCollapse: true,
    paging:         false,
    info:           false,
	 ordering:       false,
	 scrollY:        "400px",
	 AutoWidth:      false,
	 language:       {"emptyTable":"<s:text name=""></s:text>","search":"<s:text name="message.search"></s:text>"}
});
$('#EventStatsTable tbody').on( 'mouseover', 'tr', function () {
  $(this).css("cursor","pointer");
} );

$('#EventStatsTable tbody').on( 'click', 'tr', function () {
   $('#EventStatsTable tbody tr.selected').removeClass('selected');
   $(this).addClass('selected');
} );
laydate.render({
	  elem: '#startDateA_EventStats',
	  format: dateformat,
	  position: 'fixed',
	  btns: ['confirm'],
	  value:new Date(),
	  lang: 'en',
	  done: function(value, date, endDate){
		  startDateA=date.year+"-"+date.month+"-"+date.date;
	  }
});  
laydate.render({
	  elem: '#endDateA_EventStats',
	  format: dateformat,
	  position: 'fixed',
	  btns: ['confirm'],
	  value:new Date(),
	  lang: 'en',
	  done: function(value, date, endDate){
		  endDateA=date.year+"-"+date.month+"-"+date.date;
	  }
});
laydate.render({
	  elem: '#startDateB_EventStats',
	  format: dateformat,
	  position: 'fixed',
	  btns: ['confirm'],
	  value:new Date(),
	  lang: 'en',
	  done: function(value, date, endDate){
		  startDateB=date.year+"-"+date.month+"-"+date.date;
	  }
});  
laydate.render({
	  elem: '#endDateB_EventStats',
	  format: dateformat,
	  position: 'fixed',
	  btns: ['confirm'],
	  value:new Date(),
	  lang: 'en',
	  done: function(value, date, endDate){
		  endDateB=date.year+"-"+date.month+"-"+date.date;
	  }
});
function initEventStatsPage()
{
	var port = $("#ports_EventStats").val();
	getProdids(port, "EventStats");
	var dateV = dateFormat("yyyy-MM-dd");
	$("#startDateA_EventStats").val(dateV);
	$("#endDateA_EventStats").val(dateV);
	$("#startDateB_EventStats").val(dateV);
	$("#endDateB_EventStats").val(dateV);
}
function qryEventStats()
{
	/* var startDateA = $("#startDateA_EventStats").val();
	var endDateA = $("#endDateA_EventStats").val();
	var startDateB = $("#startDateB_EventStats").val();
	var endDateB = $("#endDateB_EventStats").val(); */
	var comPort = $("#ports_EventStats").val();
	var prodid = $("#prodids_EventStats").val();
	var sn = $("#sns_EventStats").val();
	if(startDateA==""||endDateA==""||endDateB==""||startDateB==""){
		tag('<s:text name="label.historyInfoView"></s:text>','<s:text name="label.EmptyTable"></s:text>')
		return;
	}else{
		var url = "<%=request.getContextPath()%>/history/qryEventStats?"+Math.random();
		var conditions={"startDateA":startDateA, "endDateA":endDateA, "startDateB":startDateB, "endDateB":endDateB, "comPort":comPort, "prodid":prodid, "sn":sn};
		initStatis(conditions,url)
		//$("#EventStatsList").load(url,{"startDateA":startDateA, "endDateA":endDateA, "startDateB":startDateB, "endDateB":endDateB, "comPort":comPort, "prodid":prodid, "sn":sn});
		};
}

function initStatis(conditions,url){
	//var deviceID = $("#portName3  option:selected").val();
	//var url = "<%=request.getContextPath()%>/history/queryHistoryStatis?&"+Math.random();
	
	var language =window.sessionStorage.getItem("language");
	
	$.ajax({	
		type:"post",
		url:url,
		data:conditions,
		success:function(data){
			var jsons = JSON.parse(data);
			var result = "";
			for(var type in jsons){
				var evt= jsons[type];
				if(evt.length<1){
					continue;
				}
				var evttype = evt[1].enType;
				if(language=="en_US"){
					evttype= evt[1].enType;
				}else if(language=="fr_FR"){
					evttype= evt[1].frType;
				}else if(language=="de_DE"){
					evttype= evt[1].deType;
				}else if(language=="it_IT"){
					evttype= evt[1].itType;
				}else if(language=="pl_PL"){
					evttype= evt[1].plType;
				}else if(language=="pt_PT"){
					evttype= evt[1].ptType;
				}else if(language=="ru_RU"){
					evttype= evt[1].rusType;
				}else if(language=="es_ES"){
					evttype= evt[1].spType;
				}else if(language=="uk_UA"){
					evttype= evt[1].ukrType;
				}else if(language=="tr_TR"){
					evttype= evt[1].turType;
				}else if(language=="cs_CS"){
					evttype= evt[1].csType;
				}else if(language=="zh_CN"){
					evttype= evt[1].type;
				}else if(language=="zh_TW"){
					evttype= evt[1].twType;
				}else if(language=="ja_JP"){
					evttype= evt[1].jpType;
					console.log("meijianlaim"+evttype)
				}
				var parendID = type.substr(6);
				console.log("language:"+language=="ja_JP")
				console.log("evttype"+evttype)
				var evttype_re = evttype.replace(/ /g,"");
				var html="<tr id='"+parendID+"' menutarge='"+evttype_re+"' expend=true  onclick='expendEvts(this);' style='background-color: #d0dfe0;'>"
							+"<td  colspan='5' align='left'><font style='font-weight: bold;'>"+evttype+"</font></td>"
						+"</tr>";
				for(var i=0;i<evt.length;i++){
					var cls=evttype_re;
					var evtname= evt[i].name;
					
					if(language=="en_US"){
						evtname = evt[i].enName;
					}else if(language=="fr_FR"){
						evtname = evt[i].frName;
					}else if(language=="de_DE"){
						evtname = evt[i].deName;
					}else if(language=="it_IT"){
						evtname = evt[i].itName;
					}else if(language=="pl_PL"){
						evtname = evt[i].plName;
					}else if(language=="pt_PT"){
						evtname = evt[i].ptName;
					}else if(language=="ru_RU"){
						evtname = evt[i].rusName;
					}else if(language=="es_ES"){
						evtname = evt[i].spName;
					}else if(language=="uk_UA"){
						evtname = evt[i].ukrName;
					}else if(language=="tr_TR"){
						evtname = evt[i].turName;
					}else if(language=="cs_CS"){
						evtname = evt[i].csName;
					}else if(language=="zh_CN"){
						evtname = evt[i].name;
					}else if(language=="zh_TW"){
						evtname = evt[i].twName;
					} else if(language=="ja_JP"){
						evtname = evt[i].jpName;
					}
					
					var level = "<%=request.getContextPath()%>/images/level"+evt[i].level+".png";
					html+="<tr class="+cls+">"
							+"<td >"
								+"<div class='th-inner '>"+evtname+"</div>"
							+"</td>"
							+"<td >"
								+"<div class='th-inner '><img src="+level+"></div>"
								
							+"</td>"
							+"<td>"
								+"<div class='th-inner '>"+evt[i].periodA+"</div>"
							+"</td>"
							+"<td>"
								+"<div class='th-inner '>"+evt[i].periodB+"</div>"
							+"<td>"
								+"<div class='th-inner '>"+evt[i].changePercent+"</div>"
							+"</td>"
						+"</tr>";
				}
				result+=html;
			}
			$("#eventsList").html(result);
		}
	});
}

function expendEvts(obj){
	var menutarge = $(obj).attr("menutarge");
	console.log("menutarge:"+menutarge)
	if($("."+menutarge).css("display") == "none"){
		$("."+menutarge).css("display","table-row");
	}else{
		$("."+menutarge).css("display","none");
	}
	
}

</script>