<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<table id="EventRecordTable" class="display cell-border">
	<thead>
		<tr>
			<th style="display: none;">&nbsp;</th>
			<th>
				<s:text name="label.rowNum"></s:text>
			</th>
			<th>
				<s:text name="lable.level"></s:text>
			</th>
			<th>
				<s:text name="text.occurTime"></s:text>
			</th>
			<th>
				<s:text name="lable.eventName"></s:text>
			</th>
			<th>
				<s:text name="lable.eventType"></s:text>
			</th>
		</tr>
	</thead>
	<tfoot>
		<tr>
			<th style="display: none;">&nbsp;</th>
			<th>
				<s:text name="label.rowNum"></s:text>
			</th>
			<th>
				<s:text name="lable.level"></s:text>
			</th>
			<th>
				<s:text name="text.occurTime"></s:text>
			</th>
			<th>
				<s:text name="lable.eventName"></s:text>
			</th>
			<th>
				<s:text name="lable.eventType"></s:text>
			</th>
		</tr>
	</tfoot>
	<s:iterator value="eventInfos" var="item" status="status">
		<tr>
			<td style="display: none;"><s:property value="#item.recordId"/></td>
			<td width="10%" align="center">
				<s:property value="#status.index+1"/>
			</td>
			<td width="10%" align="center">
				<img src="<%=request.getContextPath()%>/images/level<s:property value="#item.level"/>.png">
			</td>
			<td width="20%" align="center">
				<s:if test="globalConfig.dateFormat == 'yyyy-MM-dd'">
					<s:date name="#item.occurTime" format="yyyy-MM-dd HH:mm:ss"/>
				</s:if>
				<s:elseif test="globalConfig.dateFormat == 'yyyy/MM/dd'">
					<s:date name="#item.occurTime" format="yyyy/MM/dd HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'yyyy:MM:dd'">
					<s:date name="#item.occurTime" format="yyyy:MM:dd HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM-dd-yyyy'">
					<s:date name="#item.occurTime" format="MM-dd-yyyy HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM/dd/yyyy'">
					<s:date name="#item.occurTime" format="MM/dd/yyyy HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM:dd:yyyy'">
					<s:date name="#item.occurTime" format="MM:dd:yyyy HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd-MM-yyyy'">
					<s:date name="#item.occurTime" format="dd-MM-yyyy HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd/MM/yyyy'">
					<s:date name="#item.occurTime" format="dd/MM/yyyy HH:mm:ss"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd:MM:yyyy'">
					<s:date name="#item.occurTime" format="dd:MM:yyyy HH:mm:ss"/>
				</s:elseif>
			</td>
			<td align="center">
				<s:if test="globalConfig.language == 'zh_CN'">
					<s:property value="#item.name"/>
				</s:if>
				<s:elseif test="globalConfig.language == 'zh_TW'">
					<s:property value="#item.twName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'de_DE'">
					<s:property value="#item.deName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'fr_FR'">
					<s:property value="#item.frName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'it_IT'">
					<s:property value="#item.itName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'pl_PL'">
					<s:property value="#item.plName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'pt_PT'">
					<s:property value="#item.ptName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'ru_RU'">
					<s:property value="#item.rusName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'es_ES'">
					<s:property value="#item.spName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'uk_UA'">
					<s:property value="#item.ukrName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'tr_TR'">
					<s:property value="#item.turName"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'cs_CS'">
					<s:property value="#item.csName"/>
					
				</s:elseif>
				<s:elseif test="globalConfig.language == 'ja_JP'">
					<s:property value="#item.JPName"/>
					
				</s:elseif>
				<s:else>
					<s:property value="#item.enName"/>
				</s:else>
			</td>
			<td align="center">
				<s:if test="globalConfig.language == 'zh_CN'">
					<s:property value="#item.type"/>
				</s:if>
				<s:elseif test="globalConfig.language == 'zh_TW'">
					<s:property value="#item.twType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'de_DE'">
					<s:property value="#item.deType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'fr_FR'">
					<s:property value="#item.frType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'it_IT'">
					<s:property value="#item.itType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'pl_PL'">
					<s:property value="#item.plType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'pt_PT'">
					<s:property value="#item.ptType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'ru_RU'">
					<s:property value="#item.rusType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'es_ES'">
					<s:property value="#item.spType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'uk_UA'">
					<s:property value="#item.ukrType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'tr_TR'">
					<s:property value="#item.turType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'cs_CS'">
					<s:property value="#item.csType"/>
				</s:elseif>
				<s:elseif test="globalConfig.language == 'ja_JP'">
					<s:property value="#item.jpType"/>
				</s:elseif>
				<s:else>
					<s:property value="#item.enType"/>
				</s:else>
			</td>
		</tr>
	</s:iterator>
</table>
<script>
var EventRecordTable = $("#EventRecordTable").DataTable({
	 jQueryUI :      true,
	 searching:      true,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 ordering:       true,
	 scrollY:        "450px",
	 language:       {"emptyTable":"<s:text name=" "></s:text>","search":"<s:text name="message.search"></s:text>"}
});
$('#EventRecordTable tbody').on( 'mouseover', 'tr', function () {
    $(this).css("cursor","pointer");
} );

$('#EventRecordTable tbody').on( 'click', 'tr', function () {
     $('#EventRecordTable tbody tr.selected').removeClass('selected');
     $(this).addClass('selected');
} );
</script>