<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<table id="planTable" class="display">
	<thead>
		<tr>
			<th style="display: none;"></th>
			<th><s:text name="label.cycle"></s:text></th>
			<th><s:text name="label.offTime"></s:text></th>
			<th><s:text name="label.onTime"></s:text></th>
			<th><s:text name="label.upss"></s:text></th>
		</tr>
	</thead>
	<tbody>
		<s:iterator value="powerPlans" var="plan">
			<tr>
				<td style="display: none;"><s:property value="#plan.planId"/></td>
				<td>
					<s:if test="#plan.cycle == 'once'">
						<s:text name="label.once"></s:text>
					</s:if>
					<s:elseif test="#plan.cycle == 'daily'">
						<s:text name="label.byDay"></s:text>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'weekly'">
						<s:text name="label.byWeek"></s:text>
					</s:elseif>
				</td>
				<td>
					<s:if test="#plan.cycle == 'once'">
						<s:if test="globalConfig.dateFormat == 'yyyy-MM-dd'">
							<s:date name="#plan.offDate" format="yyyy-MM-dd "/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:if>
						<s:elseif test="globalConfig.dateFormat == 'yyyy/MM/dd'">
							<s:date name="#plan.offDate" format="yyyy/MM/dd "/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'yyyy:MM:dd'">
							<s:date name="#plan.offDate" format="yyyy:MM:dd"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'MM-dd-yyyy'">
							<s:date name="#plan.offDate" format="MM-dd-yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'MM/dd/yyyy'">
							<s:date name="#plan.offDate" format="MM/dd/yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'MM:dd:yyyy'">
							<s:date name="#plan.offDate" format="MM:dd:yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'dd-MM-yyyy'">
							<s:date name="#plan.offDate" format="dd-MM-yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'dd/MM/yyyy'">
							<s:date name="#plan.offDate" format="dd/MM/yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
						<s:elseif test="globalConfig.dateFormat == 'dd:MM:yyyy'">
							<s:date name="#plan.offDate" format="dd:MM:yyyy"/>
							<s:date name="#plan.offTime" format="HH:mm"/>
						</s:elseif>
					</s:if>
					<s:elseif test="#plan.cycle == 'daily'">
						<s:date name="#plan.offTime" format="HH:mm"/>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'weekly'">
						<s:if test="#plan.offWeek == 1">
							<s:text name="label.sunday"></s:text>
						</s:if>
						<s:elseif test="#plan.offWeek == 2">
							<s:text name="label.monday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.offWeek == 3">
							<s:text name="label.tuesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.offWeek == 4">
							<s:text name="label.wednesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.offWeek == 5">
							<s:text name="label.thursday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.offWeek == 6">
							<s:text name="label.friday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.offWeek == 7">
							<s:text name="label.saturday"></s:text>
						</s:elseif>
						<s:date name="#plan.offTime" format="HH:mm"/>
					</s:elseif>
				</td>
				<td>
					<s:if test="#plan.cycle == 'once'">
						<s:if test="globalConfig.dateFormat == 'yyyy-MM-dd'">
					<s:date name="#plan.onDate" format="yyyy-MM-dd "/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:if>
				<s:elseif test="globalConfig.dateFormat == 'yyyy/MM/dd'">
					<s:date name="#plan.onDate" format="yyyy/MM/dd "/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'yyyy:MM:dd'">
					<s:date name="#plan.onDate" format="yyyy:MM:dd"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM-dd-yyyy'">
					<s:date name="#plan.onDate" format="MM-dd-yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM/dd/yyyy'">
					<s:date name="#plan.onDate" format="MM/dd/yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM:dd:yyyy'">
					<s:date name="#plan.onDate" format="MM:dd:yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd-MM-yyyy'">
					<s:date name="#plan.onDate" format="dd-MM-yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd/MM/yyyy'">
					<s:date name="#plan.onDate" format="dd/MM/yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd:MM:yyyy'">
					<s:date name="#plan.onDate" format="dd:MM:yyyy"/>
					<s:date name="#plan.onTime" format="HH:mm"/>
				</s:elseif>
					</s:if>
					<s:elseif test="#plan.cycle == 'daily'">
						<s:date name="#plan.onTime" format="HH:mm"/>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'weekly'">
						<s:if test="#plan.onWeek == 1">
							<s:text name="label.sunday"></s:text>
						</s:if>
						<s:elseif test="#plan.onWeek == 2">
							<s:text name="label.monday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.onWeek == 3">
							<s:text name="label.tuesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.onWeek == 4">
							<s:text name="label.wednesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.onWeek == 5">
							<s:text name="label.thursday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.onWeek == 6">
							<s:text name="label.friday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.onWeek == 7">
							<s:text name="label.saturday"></s:text>
						</s:elseif>
						<s:date name="#plan.onTime" format="HH:mm"/>
					</s:elseif>
				</td>
				<td><s:property value="#plan.ports"/></td>
			</tr>
		</s:iterator>
	</tbody>
</table>
<script>
var planTable = $("#planTable").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 scrollY:        "400px",
	 language:       {"emptyTable": " "}
});

$('#planTable tbody').on( 'mouseover', 'tr', function () {
    $(this).css("cursor","pointer");
} );

$('#planTable tbody').on( 'click', 'tr', function () {
     $('#planTable tbody tr.selected').removeClass('selected');
     $(this).addClass('selected');
} );
</script>