<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<table id="planTable" class="display">
	<thead>
		<tr>
			<th style="display: none;"></th>
			<th><s:text name="label.cycle"></s:text></th>
			<th><s:text name="label.date"></s:text></th>
			<th><s:text name="label.time"></s:text></th>
			<th><s:text name="label.operation"></s:text></th>
			<th><s:text name="label.upss"></s:text></th>
		</tr>
	</thead>
	<tbody>
		<s:iterator value="testPlans" var="plan">
			<tr>
				<td style="display: none;"><s:property value="#plan.planId"/></td>
				<td>
					<s:if test="#plan.cycle == 'once'">
						<s:text name="label.once"></s:text>
					</s:if>
					<s:elseif test="#plan.cycle == 'daily'">
						<s:text name="label.byDay"></s:text>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'weekly'">
						<s:text name="label.byWeek"></s:text>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'monthly'">
						<s:text name="label.byMonth"></s:text>
					</s:elseif>
				</td>
				<td>
					<s:if test="#plan.cycle == 'once'">
						<s:if test="globalConfig.dateFormat == 'yyyy-MM-dd'">
					<s:date name="#plan.planDate" format="yyyy-MM-dd "/>
				</s:if>
				<s:elseif test="globalConfig.dateFormat == 'yyyy/MM/dd'">
					<s:date name="#plan.planDate" format="yyyy/MM/dd "/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'yyyy:MM:dd'">
					<s:date name="#plan.planDate" format="yyyy:MM:dd"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM-dd-yyyy'">
					<s:date name="#plan.planDate" format="MM-dd-yyyy"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM/dd/yyyy'">
					<s:date name="#plan.planDate" format="MM/dd/yyyy"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'MM:dd:yyyy'">
					<s:date name="#plan.planDate" format="MM:dd:yyyy"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd-MM-yyyy'">
					<s:date name="#plan.planDate" format="dd-MM-yyyy"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd/MM/yyyy'">
					<s:date name="#plan.planDate" format="dd/MM/yyyy"/>
				</s:elseif>
				<s:elseif test="globalConfig.dateFormat == 'dd:MM:yyyy'">
					<s:date name="#plan.planDate" format="dd:MM:yyyy"/>
				</s:elseif>
					</s:if>
					<s:elseif test="#plan.cycle == 'daily'">
						&nbsp;
					</s:elseif>
					<s:elseif test="#plan.cycle == 'weekly'">
						<s:if test="#plan.planWeek ==0">
							<s:text name="label.sunday"></s:text>
						</s:if>
						<s:elseif test="#plan.planWeek ==1">
							<s:text name="label.monday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.planWeek == 2">
							<s:text name="label.tuesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.planWeek == 3">
							<s:text name="label.wednesday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.planWeek == 4">
							<s:text name="label.thursday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.planWeek == 5">
							<s:text name="label.friday"></s:text>
						</s:elseif>
						<s:elseif test="#plan.planWeek == 6">
							<s:text name="label.saturday"></s:text>
						</s:elseif>
					</s:elseif>
					<s:elseif test="#plan.cycle == 'monthly'">
						<s:property value="#plan.planMonth"/>
					</s:elseif>
				</td>
				<td>
					<s:date name="#plan.planTime" format="HH:mm"/>
				</td>
				<td>
					<s:if test="#plan.operation == 'seconds'">
						<s:if test="#parameters.protocolType == 'SEC'">
							<s:text name="label.BatteryTestCtrl"></s:text>
						</s:if>
						<s:else>
							<s:text name="label.secondsTest"></s:text>
						</s:else>
					</s:if>
					<s:elseif test="#plan.operation == 'minutes'">
						<s:text name="label.selfTest"></s:text>
					</s:elseif>
					<s:elseif test="#plan.operation == 'deep'">
						<s:text name="label.deepTest"></s:text>
					</s:elseif>
				</td>
				<td><s:property value="#plan.ports"/></td>
			</tr>
		</s:iterator>
	</tbody>
</table>
<script>
var planTable = $("#planTable").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 scrollY:        "500px",
	 language:       {"emptyTable": " "}
});

$('#planTable tbody').on( 'mouseover', 'tr', function () {
    $(this).css("cursor","pointer");
} );

$('#planTable tbody').on( 'click', 'tr', function () {
     $('#planTable tbody tr.selected').removeClass('selected');
     $(this).addClass('selected');
} );
</script>