<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>

<div id="accordion">
	<h3><s:text name="label.config"></s:text> >> <s:text name="label.netWeakupSet"></s:text></h3>
</div>
<div class="page">
	<form id="macForm">
		<table	id="macTable" class="display">
			<thead>
				<tr>
					<th>
						<s:text name="label.netcardPhyAddress"></s:text>
					</th>
					<th>
						<input type="text" id="mac" name="macAddr" placeholder="01-1F-C6-C7-E0-08" class="text" style="width: 400px;"/>
						<button id="addMac" class="btn white"><s:text name="label.add"></s:text></button>
						<button id="delMac" class="btn white"><s:text name="label.del"></s:text></button>
						<button id="weakupMac" class="btn white"><s:text name="label.wake"></s:text></button>
					</th>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td align="center">
						<s:text name="label.phyAddressList"></s:text>
					</td>
					<td>
					
					</td>
				</tr>
				<s:iterator value="weakUpMac" var="macAddr">
					<tr>
						<td>
							<div style="text-align: right;">
								<input type="checkbox" id="<s:property value="#macAddr"/>" name="macs" value="<s:property value="#macAddr"/>"/>
							</div>
						</td>
						<td>
							<label for="<s:property value="#macAddr"/>" style="cursor: pointer;"><s:property value="#macAddr"/></label>
						</td>
					</tr>
				</s:iterator>
			</tbody>
		</table>
	</form>
</div>
<script>
$("#accordion").accordion();
var macTable = $("#macTable").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 ordering:       false,
	 scrollY:        "300px",
	 language:       {"emptyTable": "<s:text name=""></s:text>"}
});
$('#macTable thead').remove();
$('#macTable tbody').on( 'click', 'tr', function () {
	var isChecked = $(this).find("input[type='checkbox']").is(':checked');
	if(isChecked)
	{
		$(this).addClass('selected');
	}
	else
	{
		$(this).removeClass('selected'); 
	}
} );

$("#addMac").on("click",function(){
	$("#macForm").attr("onSubmit","return false;");
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	var mac =$('#mac').val().trim();
	var reg =/([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}/;
	if(!reg.test(mac)){				
		var title = "<s:text name="label.netWeakUPSet"></s:text>" + " " +"<s:text name="label.add"></s:text>";
		tag(title,"<s:text name="label.invalidinput"></s:text>");
		return;
	}
	updateMacAddress("add");
});

$("#delMac").on("click",function(){
	$("#macForm").attr("onSubmit","return false;");
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	
	updateMacAddress("del");
});

$("#weakupMac").on("click",function(){
	$("#macForm").attr("onSubmit","return false;");
	var selectedRow = $('#macTable tbody tr.selected');
	if(selectedRow.length == 0)
	{
		return;
	}
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	testNetWeakUp();
});

function updateMacAddress(type)
{
	var url = "<%=request.getContextPath()%>/config/updateMacAddress?type="+type+"&"+Math.random();
	$.post(url,$("#macForm").serialize(),function(data){
		if(data == "nologin"){
			tag(title,"<s:text name="label.relogin"></s:text>");
			logout();
		}
		else if(data == "success")
		{
			if(type=="add")
			{
				tag("<s:text name="label.netWeakupSet"></s:text>","<s:text name="label.add"></s:text>"+"  "+"<s:text name="label.OperationSuccess"></s:text>");
				var mac = $("#mac").val().trim();
				var td0 = "<div style='text-align: right;'><input type='checkbox' id='"+mac+"' name='macs' value='"+mac+"'/></div>";
				var td1 = "<label for='"+mac+"' style='cursor: pointer;'>";
				td1 += mac;
				td1 += "</label>";
				macTable.row.add( [td0,td1] ).draw( false );
			}
			else if(type="del")
			{
				tag("<s:text name="label.netWeakupSet"></s:text>","<s:text name="label.del"></s:text>"+"  "+"<s:text name="label.OperationSuccess"></s:text>");
				var selectedRow = $('#macTable tbody tr.selected');
				$.each(selectedRow,function(){
					macTable.row($(this)).remove().draw( false );
				});
			}
		}
		
	});
}

function testNetWeakUp()
{
	var url = "<%=request.getContextPath()%>/config/testNetWeakUp?"+Math.random();
	$.post(url,$("#macForm").serialize(),function(data){
		tag("<s:text name="label.netWeakupSet"></s:text>","<s:text name="label.wake"></s:text>"+"  "+"<s:text name="alert.sendOK"></s:text>");
	});
}

</script>