<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>
<div id="accordion">
	<h3><s:text name="label.config"></s:text> >> <s:text name="label.modbussetting"></s:text></h3>
</div>
<script>$("#accordion").accordion();</script>
<div class="page">
	<table class="display cell-border" id="mudb">
		<thead>
			<tr>
				<th>
					<s:text name="label.modbuscomport"></s:text>
				</th>
				<th>
					<s:text name="label.upsid"></s:text>
				</th>
				<th>
					<s:text name="label.bit"></s:text>
				</th>
				<th>
					<s:text name="label.databit"></s:text>
				</th>
				<th>
					<s:text name="label.stopbit"></s:text>
				</th>
				<th>
					<s:text name="label.parity"></s:text>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td align="center">
					<select id="comPort" name="comPort" class="dropdown" onchange="getModbusConf();">
						<s:iterator value="comPort" var="item">
							<option value="<s:property value="#item"/>"><s:property value="#item"/></option>
						</s:iterator>
					</select>
				</td>
				<td align="center">
					<select id="mid" name="mid" class="dropdown">
						<s:iterator begin="0" end="247" status="status">
							<option value="<s:property value="#status.index"/>"><s:property value="#status.index"/></option>
						</s:iterator>
					</select>
				</td>
				<td align="center">
					<select id="baudRate" name="baudRate" class="dropdown">
						<option value="1200">1200</option>
						<option value="2400">2400</option>
						<option value="4800">4800</option>
						<option value="9600">9600</option>
						<option value="19200">19200</option>
					</select>
				</td>
				<td align="center">
					<select id="databit" name="databit" class="dropdown">
						<option value="7">7</option>
						<option value="8">8</option>
					</select>
				</td>
				<td align="center">
					<select id="stopbit" name="stopbit" class="dropdown">
						<option value="1">1</option>
						<option value="2">2</option>
					</select>
				</td>
				<td align="center">
					<select id="efficacy" name="efficacy" class="dropdown">
						<option value="0">NONE</option>
						<option value="1">ODD</option>
						<option value="2">EVEN</option>
					</select>
				</td>
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<th colspan="6" align="right">
					<button class="btn white" onclick="updateModbusConf();"><s:text name="label.apply"></s:text></button>
				</th>
			</tr>
		</tfoot>
	</table>
	<div style="width: 100%; height: 19px;"></div>
	<table class="display cell-border" id="passwordbox">
		<thead>
			<th>
				<s:text name="label.curPassword"></s:text>
			</th>
			<th>
				<s:text name="label.setNewPassword"></s:text>
			</th>
			<th>
				<s:text name="label.repeatPassword"></s:text>
			</th>
		</thead>
		<tbody>
			<tr>
				<td align="center">
					<input id="curPassword" type="password" class="text" style="width: 120px;"/>
				</td>
				<td align="center">
					<input id="setNewPassword" type="password" class="text" style="width: 120px;"/>
				</td>
				<td align="center">
					<input id="repeatPassword" type="password" class="text" style="width: 120px;"/>
				</td>
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<th colspan="3" align="right">
					<button class="btn white" onclick="updateModbusPassword();"><s:text name="label.apply"></s:text></button>
					<button class="btn white" onclick="resetModbusPassword();"><s:text name="label.reset"></s:text></button>
				</th>
			</tr>
		</tfoot>
	</table>
</div>
<script>
$("#accordion").accordion();
$(".display").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
	 ordering:       false
});
getModbusConf();
function getModbusConf()
{
	var comPort = $("#comPort").val();
	var url = "<%=request.getContextPath()%>/config/getModbusConfig?"+Math.random();
	$.post(url,{"comport":comPort},function(data){
		data =jQuery.parseJSON(data);//"{"baudRate":4800,"dataBit":8,"efficacy":0,"machineId":1,"stopBit":1}"
		$("#mid").val(data.machineId);
		$("#baudRate").val(data.baudRate);
		$("#databit").val(data.dataBit);
		$("#stopbit").val(data.stopBit);
		$("#efficacy").val(data.efficacy);
	});
}

function updateModbusConf()
{
	
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	
	var comPort = $("#comPort").val();
	var mid = $("#mid").val();
	var baudRate = $("#baudRate").val();
	var databit = $("#databit").val();
	var stopbit = $("#stopbit").val();
	var efficacy = $("#efficacy").val();
	
	var url = "<%=request.getContextPath()%>/config/updateModBusConfig?"+Math.random();
	$.post(url,{"comport":comPort,"modbusid":mid,"baudRate":baudRate,
		"databit":databit,"stopbit":stopbit,"efficacy":efficacy},function(data){
			if(data == "nologin"){
				tag(title,"<s:text name="label.relogin"></s:text>");
				logout();
			}
			else if(data == "success")
			{
				tag("<s:text name="label.apply"></s:text>","<s:text name="label.OperationSuccess"></s:text>");
			}
	});
}

function updateModbusPassword()
{
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	
	var curPassword = $("#curPassword").val().trim();
	var setNewPassword = $("#setNewPassword").val().trim();
	var repeatPassword = $("#repeatPassword").val().trim();
	
	if(curPassword == "")
	{
		tag("","<s:text name="alert.inputCurPsw"></s:text>");
		return;
	}
	
	if(curPassword != "<s:property value="modbusPassword"/>")
	{
		tag("","<s:text name="alert.curPswError"></s:text>");
		return;
	}
	
	if(setNewPassword == "")
	{
		tag("","<s:text name="alert.inputNewPsw"></s:text>");
		return;
	}
	
	if(repeatPassword == "")
	{
		tag("","<s:text name="alert.inputRptPsw"></s:text>");
		return;
	}
	
	if(setNewPassword != repeatPassword)
	{
		tag("","<s:text name="alert.notSame"></s:text>");
		return;
	}
	
	var url = "<%=request.getContextPath()%>/config/updateModbusPassword?"+Math.random();
	$.post(url,{"password":setNewPassword},function(data){
		if(data == "nologin"){
			tag(title,"<s:text name="label.relogin"></s:text>");
			logout();
		}
		else if(data == "success")
		{
			tag("<s:text name="label.apply"></s:text>","<s:text name="label.OperationSuccess"></s:text>");
		}
	});
}

function resetModbusPassword()
{
	$("#curPassword").val("");
	$("#setNewPassword").val("");
	$("#repeatPassword").val("");
}
</script>