<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>

<div id="accordion">
	<h3><s:text name="label.config"></s:text> >> <s:text name="label.recorddata"></s:text></h3>
</div>
<div class="page clearfix">
	<table id="logsetTable" class="display cell-border">
		<thead>
			<tr>
				<th>
					<s:text name="label.dataRecIntervalTime"></s:text>
				</th>
				<th>
					<input id="dataRecordInterval" type="text" min="30" max="600" step="30"  value="<s:property value="globalConfig.dataRecordInterval"/>" style="width: 80px;"/>
					<script>$("#dataRecordInterval").spinner();</script>
				</th>
				<th>
					<s:text name="text.Secondss"></s:text>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td align="center">
					<s:text name="label.maxdata"></s:text>
				</td>
				<td align="center">
					<input id="maxdata" name="maxdata" type="text" min="100000" max="100000000" step="1000" style="width: 80px;" value="<s:property value="globalConfig.dataLimit"/>" />
					<script>$("#maxdata").spinner();</script>
				</td>
				<td align="center">
					(>100000)
				</td>
			</tr>
			<tr>
				<td align="center">
					<s:text name="label.maxevents"></s:text>
				</td>
				<td align="center">
					<input id="maxevents" name="maxevents" type="text" min="100000" max="100000000" step="1000" style="width: 80px;" value="<s:property value="globalConfig.eventLimit"/>" />
					<script>$("#maxevents").spinner();</script>
				</td>
				<td align="center">
					(>100000)
			</tr>
		</tbody>
		<tfoot>
			<tr>
				<th colspan="3" align="right">
					<button class="btn white" id="applyLogSet"><s:text name="label.apply"></s:text></button>
					<button class="btn white" id="defaultLogSet"><s:text name="label.default"></s:text></button>
				</th>
			</tr>
		</tfoot>
	</table>
</div>
<script>
$("#accordion").accordion();
$("#logsetTable").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
     ordering:       false
});

$("#applyLogSet").on("click",function(){
	updateLogSet("<s:text name="label.apply"></s:text>");
});

$("#defaultLogSet").on("click",function(){
	$("#dataRecordInterval").val(60);
	$("#maxdata").val(100001);
	$("#maxevents").val(100001);
	updateLogSet("<s:text name="label.default"></s:text>");
});

function updateLogSet(title)
{
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	
	var dataRecordInterval = $("#dataRecordInterval").val().trim();
	var maxdata = $("#maxdata").val().trim();
	var maxevents = $("#maxevents").val().trim();
	
	var url = "<%=request.getContextPath()%>/config/updateLogSet?"+Math.random();
	$.post(url,{"dataRecordInterval":dataRecordInterval,"maxdata":maxdata,"maxevents":maxevents},function(data){
		if(data == "nologin"){
			tag(title,"<s:text name="label.relogin"></s:text>");
			logout();
		}
		else if(data == "success")
		{
			tag(title,"<s:text name="label.OperationSuccess"></s:text>");
		}
		else
		{
			tag(title,"<s:text name="label.invalidinput"></s:text>");
		}
	});
}
</script>