<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ taglib uri="/struts-tags" prefix="s" %>

<div id="accordion">
	<h3><s:text name="label.config"></s:text> >> <s:text name="label.electricEventSet"></s:text></h3>
</div>
<div style="margin-top: 9px;">
	<div style="float: left; width: 60%; border: 1px solid #a6c9e2; border-radius: 6px;">
		<table id="eventTable" class="display  ">
			<thead style="text-align:center">
				<tr>
					<th  style="display: none;">
						ID
					</th>
					<th class="jith">
						<s:text name="lable.level"></s:text>
					</th>
					<th class="jith1">
						<s:text name="lable.eventName"></s:text>
					</th>
					<th class="jith2">
						<s:text name="lable.eventType"></s:text>
					</th>
				</tr>
			</thead>
			<tbody style=" width:98%">
				<s:iterator value="events" var="event" status="status">
					<tr <s:if test="#status.index == 0">class="selected"</s:if> onclick="initEventConfig('<s:property value="#event.id"/>');">
						<td width="10%" style="display: none;">
							<s:property value="#event.id"/>
						</td>
						<td width="20%" align="center">
							<img src="<%=request.getContextPath()%>/images/level<s:property value="#event.level"/>.png">
						</td>
						<td width="40%">
							<s:property value="#event.name"/>
						</td>
						<td width="30%">
							<s:property value="#event.type"/>
						</td>
					</tr>
				</s:iterator>
				<s:iterator value="events1" var="event" status="status">
					<tr <s:if test="#status.index == 0">class="selected"</s:if> onclick="initEventConfig('<s:property value="#event.id"/>');">
						<td width="10%" style="display: none;">
							<s:property value="#event.id"/>
						</td>
						<td width="20%" align="center">
							<img src="<%=request.getContextPath()%>/images/level<s:property value="#event.level"/>.png">
						</td>
						<td width="40%">
							<s:property value="#event.name"/>
						</td>
						<td width="30%">
							<s:property value="#event.type"/>
						</td>
					</tr>
				</s:iterator>
			</tbody>
		</table>
	</div>
	<div style="float: left; width: 1%;"> &nbsp;&nbsp; </div>
	<div style="float: left; width: 38%; border: 1px solid #a6c9e2; border-radius: 6px;">
		<form id="eForm" style="min-height: 395px; max-height: 395px;"></form>
		<div style="margin-top: 9px; margin-bottom: 9px; text-align: center;">
			<button id="applyEvent" class="btn white"><s:text name="label.apply"></s:text></button>
			<button id="defaultEvent" class="btn white"><s:text name="label.default"></s:text></button>
		</div>
	</div>
</div>
<script>
$("#accordion").accordion();
$(document).ready(function() {
	var tdobj = $("#eventTable tbody tr.selected td");
	var text = $(tdobj[0]).text().trim();
	initEventConfig(text);
});
$("#eventTable").DataTable({
	 jQueryUI :      true,
	 searching:      false,
     scrollCollapse: true,
     paging:         false,
     info:           false,
     scrollY:        "380px",
		
});

$('#eventTable tbody').on( 'mouseover', 'tr', function () {
    $(this).css("cursor","pointer");
} );

$('#eventTable tbody').on( 'click', 'tr', function () {
     $('#eventTable tbody tr.selected').removeClass('selected');
     $(this).addClass('selected');
} );

function initEventConfig(eventid)
{
	var url = "<%=request.getContextPath()%>/config/getEventConfig?"+Math.random();
	$("#eForm").load(url,{"eventid":eventid});
}

$("#applyEvent").on("click",function(){
	setEventConfig();
});

$("#defaultEvent").on("click",function(){
	$("#eForm table input[type='checkbox']").removeAttr("checked");
	$("#recordMethod").prop("checked", 'true');
	$("#warningMethod").prop("checked", 'true');
	setEventConfig();
});

function setEventConfig()
{
	if(noLogined())
	{
		$( "#login_dlg" ).dialog( "open" );
		return;
	}
	var url = "<%=request.getContextPath()%>/config/setEventConfig?"+Math.random();
	$.post(url,$("#eForm").serialize(),function(data){
		if(data == "nologin"){
			tag(title,"<s:text name="label.relogin"></s:text>");
			logout();
		}
		else if(data == "success")
		{
			var tdobj = $("#eventTable tbody tr.selected td");
			var title = $(tdobj[2]).text().trim();
			tag(title,"<s:text name="label.OperationSuccess"></s:text>");
		}
	});
}
</script>