#!/bin/bash
MONITOR_HOME=/opt/Viewpower
autoStart=3;
if [ -f "/etc/redhat-release" ];then
	version=$(cat /etc/redhat-release|grep CentOS)
	if [[ $version != "" ]];then
		if [[ $version =~ "release 7" ]];then
			autoStart=1
		else
			autoStart=1
		fi
	fi
elif [ -f "/etc/issue" ];then
	version=$(cat /etc/issue|grep Ubuntu)
	if [[ $version != "" ]];then
		if [[ $version =~ "Ubuntu 20." ]] || [[ $version =~ "Ubuntu 18." ]] || [[ $version =~ "Ubuntu 19." ]] || [[ $version =~ "Ubuntu 16." ]];then
			autoStart=2
		elif [[ $version =~ "Ubuntu 14." ]] || [[ $version =~ "Ubuntu 12." ]];then
			autoStart=4
		else
			autoStart=3
		fi
	fi
fi
if [ $autoStart -eq 1 ];then
    sudo cp -f $MONITOR_HOME/upsMonitor /etc/init.d/
    sudo chkconfig --add upsMonitor
    sudo chkconfig upsMonitor on
    exit 0
elif [ $autoStart -eq 2 ];then
    if [ ! -d "/etc/systemd/system/" ];then
    	sudo mkdir /etc/systemd/system/
    fi
    sudo cp -f $MONITOR_HOME/upsMonitor.service /etc/systemd/system/
    sudo systemctl daemon-reload
    sudo systemctl enable upsMonitor.service
    exit 0
elif [ $autoStart -eq 3 ];then
    sudo cp -f $MONITOR_HOME/StartUPS.sh /etc/profile.d/
    sudo chmod 777 /etc/profile.d/StartUPS.sh
    exit 0
elif [ $autoStart -eq 4 ];then
	$MONITOR_HOME/autostart.sh
fi

