/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.bernstein.BernsteinLookAndFeel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BernsteinBorders
extends BaseBorders {
    private static Border buttonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return BernsteinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        private static final Color borderColor = new Color(255, 244, 128);
        private static final Color[] FRAME_COLORS = new Color[]{new Color(229, 187, 0), new Color(251, 232, 0), new Color(247, 225, 0), new Color(243, 216, 0), new Color(229, 187, 0)};

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!this.isResizable(component)) {
                Color color = ColorHelper.brighter(borderColor, 40.0);
                Color color2 = ColorHelper.darker(borderColor, 20.0);
                JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
                color = ColorHelper.darker(color, 20.0);
                color2 = ColorHelper.brighter(color2, 20.0);
                JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
                graphics.setColor(borderColor);
                for (int i = 2; i < 5; ++i) {
                    graphics.drawRect(i, i, n3 - 2 * i - 1, n4 - 2 * i - 1);
                }
                return;
            }
            int n5 = n3 / 3;
            int n6 = n3 * 2 / 3;
            --n3;
            Color color = borderColor;
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n, n2, n, n2 + --n4);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + n4 - 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + n4 - 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + n4 - 4);
            graphics.setColor(color);
            graphics.drawLine(n + n3, n2, n + n3, n2 + n4);
            graphics.setColor(ColorHelper.brighter(color, 30.0));
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(color, 60.0));
            graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(ColorHelper.brighter(color, 90.0));
            graphics.drawLine(n + n3 - 3, n2 + 3, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(color);
            graphics.drawLine(n + n3 - 4, n2 + 4, n + n3 - 4, n2 + n4 - 4);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n + n3, n2, n + n3, n2 + 22);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + 22);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + n3 - 2, n2 + 2, n + n3 - 2, n2 + 22);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + n3 - 3, n2 + 3, n + n3 - 3, n2 + 22);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + n3 - 4, n2 + 4, n + n3 - 4, n2 + 22);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n + n3, n2 + n4 - 22, n + n3, n2 + n4);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 22, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + n3 - 2, n2 + n4 - 22, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + n3 - 3, n2 + n4 - 22, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + n3 - 4, n2 + n4 - 22, n + n3 - 4, n2 + n4 - 4);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n, n2, n + n5, n2);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + 1, n2 + 1, n + n5, n2 + 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + 2, n2 + 2, n + n5, n2 + 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + 3, n2 + 3, n + n5, n2 + 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + 4, n2 + 4, n + n5, n2 + 4);
            graphics.setColor(color);
            graphics.drawLine(n + n5, n2, n + n3, n2);
            graphics.setColor(ColorHelper.brighter(color, 90.0));
            graphics.drawLine(n + n5, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.setColor(ColorHelper.brighter(color, 60.0));
            graphics.drawLine(n + n5, n2 + 2, n + n3 - 2, n2 + 2);
            graphics.setColor(ColorHelper.brighter(color, 30.0));
            graphics.drawLine(n + n5, n2 + 3, n + n3 - 3, n2 + 3);
            graphics.setColor(color);
            graphics.drawLine(n + n5, n2 + 4, n + n3 - 4, n2 + 4);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n + n3 - 22, n2, n + n3, n2);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + n3 - 22, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + n3 - 22, n2 + 2, n + n3 - 2, n2 + 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + n3 - 22, n2 + 3, n + n3 - 3, n2 + 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + n3 - 22, n2 + 4, n + n3 - 4, n2 + 4);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n, n2 + n4, n + n6, n2 + n4);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n6, n2 + n4 - 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + 2, n2 + n4 - 2, n + n6, n2 + n4 - 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + 3, n2 + n4 - 3, n + n6, n2 + n4 - 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + 4, n2 + n4 - 4, n + n6, n2 + n4 - 4);
            graphics.setColor(color);
            graphics.drawLine(n + n6, n2 + n4, n + n3, n2 + n4);
            graphics.setColor(ColorHelper.brighter(color, 30.0));
            graphics.drawLine(n + n6, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(ColorHelper.brighter(color, 60.0));
            graphics.drawLine(n + n6, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(ColorHelper.brighter(color, 90.0));
            graphics.drawLine(n + n6, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(color);
            graphics.drawLine(n + n6, n2 + n4 - 4, n + n3 - 4, n2 + n4 - 4);
            graphics.setColor(FRAME_COLORS[0]);
            graphics.drawLine(n + n3 - 22, n2 + n4, n + n3, n2 + n4);
            graphics.setColor(FRAME_COLORS[1]);
            graphics.drawLine(n + n3 - 22, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(FRAME_COLORS[2]);
            graphics.drawLine(n + n3 - 22, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
            graphics.setColor(FRAME_COLORS[3]);
            graphics.drawLine(n + n3 - 22, n2 + n4 - 3, n + n3 - 3, n2 + n4 - 3);
            graphics.setColor(FRAME_COLORS[4]);
            graphics.drawLine(n + n3 - 22, n2 + n4 - 4, n + n3 - 4, n2 + n4 - 4);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Color frameHiColor = ColorHelper.brighter(BernsteinLookAndFeel.getFrameColor(), 60.0);
        private static final Color frameLoColor = BernsteinLookAndFeel.getFrameColor();
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isRollover()) {
                    JTattooUtilities.draw3DBorder(graphics, frameHiColor, frameLoColor, n, n2, n3 - 1, n4);
                    JTattooUtilities.draw3DBorder(graphics, Color.white, frameHiColor, n + 1, n2 + 1, n3 - 2, n4 - 2);
                } else if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    graphics.setColor(frameHiColor);
                    graphics.drawRect(n, n2, n3 - 2, n4 - 1);
                } else {
                    graphics.setColor(BernsteinLookAndFeel.getFrameColor());
                    graphics.drawRect(n, n2, n3 - 2, n4 - 1);
                }
            } else {
                graphics.setColor(frameHiColor);
                graphics.drawRect(n, n2, n3 - 2, n4 - 1);
            }
            graphics.setColor(Color.white);
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            ColorUIResource colorUIResource = BernsteinLookAndFeel.getControlDarkShadow();
            Color color = ColorHelper.darker(colorUIResource, 8.0);
            JTattooUtilities.draw3DBorder(graphics, colorUIResource, color, n, n2, n3, n4);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

