/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.view;

import cn.com.voltronic.awt.AAButton;
import cn.com.voltronic.awt.AACheckbox;
import cn.com.voltronic.awt.AALabel;
import cn.com.voltronic.awt.AARadioButton;
import cn.com.voltronic.awt.AATextField;
import cn.com.voltronic.cmd.Cmd;
import cn.com.voltronic.console.linux.LinuxMonitorConsole;
import cn.com.voltronic.console.mac.MacMonitorConsole;
import cn.com.voltronic.console.windows.MonitorConsole;
import cn.com.voltronic.console.windows.SystemConsoleTray;
import cn.com.voltronic.consoleutil.MD5Util;
import cn.com.voltronic.consoleutil.ModifyTomcatXML;
import cn.com.voltronic.util.VolStr;
import cn.com.voltronic.view.DisplayMessage;
import cn.com.voltronicpower.StartTomcat;
import cn.com.voltronicpower.StopTomcat;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public abstract class ConfigFrame
extends JFrame {
    private static final Log logger = new Log();
    private static final long serialVersionUID = 6545582027095040441L;
    protected AAButton applyBut;
    protected AAButton cancelBut;
    protected AAButton browserButton2;
    protected AAButton jButton1;
    protected AALabel webPortLabel;
    protected AALabel hostIPLabel;
    protected AALabel portLabel;
    protected AALabel inputError3;
    protected AALabel inputError4;
    protected AALabel inputError5;
    protected AALabel inputError8;
    protected AALabel downloadLabel;
    protected AALabel savepathLabel;
    protected AALabel shutdownportLabel;
    protected AALabel inputError6;
    protected AALabel inputError7;
    protected AALabel jLabel5;
    protected AALabel jLabel6;
    protected AALabel jLabel7;
    protected AATextField webPortTextField;
    protected AATextField hostIPTextField;
    protected AATextField portTextField;
    protected AATextField downloadTextField;
    protected AATextField saveTextField;
    protected AATextField shutdownportTextField;
    protected AATextField jTextField3;
    protected JPasswordField jPasswordField1;
    protected AAButton selectBut;
    protected AAButton executeBut;
    protected AALabel jLabelpath;
    protected AALabel jLabelinOrOut;
    protected AATextField jTextFieldbackpath;
    protected JFileChooser importFile;
    protected ButtonGroup fileGroup;
    protected JRadioButton importRadio;
    protected JRadioButton exportRadio;
    protected AACheckbox jCheckBox1;
    protected AACheckbox jCheckBox2;
    protected AACheckbox jCheckBox3;
    protected AACheckbox jCheckBox4;
    protected AARadioButton autoRadio;
    protected AARadioButton manuallyRadio;
    protected JPanel jPanel1;
    protected JPanel jPanel2;
    protected JPanel jPanel3;
    protected JSeparator jSeparator1;
    protected JSeparator jSeparator2;
    protected JSeparator jSeparator3;
    protected AALabel useHttpsLabel;
    protected ButtonGroup bts;
    protected JRadioButton useHttpRadio;
    protected JRadioButton useHttpsRadio;
    protected String importStr = "import";
    private static String oldHTTP;
    protected JFileChooser fDialog;
    protected static Color color;

    static {
        color = new Color(255, 0, 0);
    }

    public abstract void initComponents();

    protected void setInitValue() {
        String webPort = "";
        String shutdownPort = "";
        String ajpPort = "";
        String downloadDir = "";
        String saveDir = "";
        String useProxyStr = "false";
        String autoDetectStr = "true";
        String useAuthCheck = "false";
        String username = "";
        String password = "";
        String proxy = "";
        String port = "";
        String autoStart = "";
        String exitMonitor = "";
        String alwaysOnTop = "";
        boolean usehttps = false;
        try {
            webPort = Config.getString((String)"port", (String)"15178").trim();
            shutdownPort = Config.getString((String)"shutdownPort", (String)"8005").trim();
            ajpPort = Config.getString((String)"ajpPort", (String)"8009").trim();
            autoStart = Config.getString((String)"autoStart", (String)"true").trim();
            exitMonitor = Config.getString((String)"exitMonitor", (String)"false").trim();
            downloadDir = Config.getString((String)"downloadDir", (String)"").trim();
            saveDir = Config.getString((String)"saveDir", (String)"").trim();
            useProxyStr = Config.getString((String)"useProxy", (String)"false").trim();
            autoDetectStr = Config.getString((String)"autoDetect", (String)"true").trim();
            proxy = Config.getString((String)"proxyIP", (String)"").trim();
            port = Config.getString((String)"proxyPort", (String)"").trim();
            useAuthCheck = Config.getString((String)"useAuth", (String)"false").trim();
            username = Config.getString((String)"proxyUser", (String)"").trim();
            password = Config.getString((String)"proxyPassword", (String)"").trim();
            alwaysOnTop = Config.getString((String)"alwaysOnTop", (String)"false").trim();
            usehttps = Config.getBoolean((String)"useHttps");
            oldHTTP = usehttps ? "https" : "http";
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.webPortTextField.setText(webPort);
        this.shutdownportTextField.setText(shutdownPort);
        this.downloadTextField.setText(downloadDir);
        Boolean useProxy = Boolean.parseBoolean(useProxyStr);
        Boolean autoDetect = Boolean.parseBoolean(autoDetectStr);
        Boolean useAuth = Boolean.parseBoolean(useAuthCheck);
        Boolean isAutoStart = Boolean.parseBoolean(autoStart);
        Boolean isExitMonitor = Boolean.parseBoolean(exitMonitor);
        Boolean isAlwaysOnTop = Boolean.parseBoolean(alwaysOnTop);
        this.hostIPTextField.setText(proxy);
        this.portTextField.setText(port);
        this.jTextField3.setText(username);
        this.jPasswordField1.setText(MD5Util.restore(password));
        if ("".equalsIgnoreCase(saveDir)) {
            saveDir = String.valueOf(System.getProperty("user.dir")) + File.separator + "UpgradeFiles";
            try {
                Config.updateProperty((String)"saveDir", (String)saveDir);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.saveTextField.setText(saveDir);
        if (MyConstants.IS_OS_WINDOWS) {
            if (isAutoStart.booleanValue()) {
                this.autoRadio.setSelected(true);
                this.manuallyRadio.setSelected(false);
            } else {
                this.autoRadio.setSelected(false);
                this.manuallyRadio.setSelected(true);
            }
            if (isExitMonitor.booleanValue()) {
                this.jCheckBox4.setSelected(true);
            } else {
                this.jCheckBox4.setSelected(false);
            }
        } else if (isAlwaysOnTop.booleanValue()) {
            this.jCheckBox4.setSelected(true);
        } else {
            this.jCheckBox4.setSelected(false);
        }
        if (autoDetect.booleanValue()) {
            this.jCheckBox2.setSelected(true);
        } else {
            this.jCheckBox2.setSelected(false);
        }
        if (useProxy.booleanValue()) {
            this.jCheckBox1.setSelected(true);
            this.hostIPLabel.setEnabled(true);
            this.portLabel.setEnabled(true);
            this.hostIPTextField.setEnabled(true);
            this.portTextField.setEnabled(true);
            if (useAuth.booleanValue()) {
                this.jCheckBox3.setSelected(true);
                this.jLabel5.setEnabled(true);
                this.jLabel6.setEnabled(true);
                this.jTextField3.setEnabled(true);
                this.jPasswordField1.setEnabled(true);
            } else {
                this.jCheckBox3.setSelected(false);
                this.jLabel5.setEnabled(false);
                this.jLabel6.setEnabled(false);
                this.jTextField3.setEnabled(false);
                this.jPasswordField1.setEnabled(false);
            }
        } else {
            this.jCheckBox1.setSelected(false);
            this.hostIPLabel.setEnabled(false);
            this.portLabel.setEnabled(false);
            this.hostIPTextField.setEnabled(false);
            this.portTextField.setEnabled(false);
            this.jCheckBox3.setEnabled(false);
            this.jLabel5.setEnabled(false);
            this.jLabel6.setEnabled(false);
            this.jTextField3.setEnabled(false);
            this.jPasswordField1.setEnabled(false);
        }
    }

    protected int getOpenDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileSelectionMode(1);
        return this.fDialog.showOpenDialog(this);
    }

    protected int getSaveDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileSelectionMode(1);
        return this.fDialog.showSaveDialog(this);
    }

    protected int importConfigDialog() {
        this.importFile = new JFileChooser();
        if (this.importStr.equals("import")) {
            this.importFile.setFileSelectionMode(0);
        } else {
            this.importFile.setFileSelectionMode(1);
        }
        return this.importFile.showSaveDialog(this);
    }

    protected void applyButActionPerformed(ActionEvent evt) {
        try {
            String newHTTP;
            String oldWebPort = Config.getString((String)"port", (String)"15178").trim();
            String oldshutdownPort = Config.getString((String)"shutdownPort", (String)"8005").trim();
            if (MyConstants.IS_OS_WINDOWS) {
                String oldAutoStart = Config.getString((String)"autoStart", (String)"true").trim();
                String oldExitMonitor = Config.getString((String)"exitMonitor", (String)"false").trim();
                String nowAutoStart = "true";
                if (this.autoRadio.isSelected()) {
                    nowAutoStart = "true";
                } else if (this.manuallyRadio.isSelected()) {
                    nowAutoStart = "false";
                }
                if (!oldAutoStart.equals(nowAutoStart)) {
                    boolean setRe = false;
                    if (nowAutoStart.equals("true")) {
                        setRe = Cmd.modifyAuto();
                    } else if (nowAutoStart.equals("false")) {
                        setRe = Cmd.modifyManually();
                    }
                    if (setRe) {
                        Config.updateProperty((String)"autoStart", (String)nowAutoStart);
                    } else {
                        DisplayMessage.showErrorDialog("message.operationfailure", "message.info");
                        return;
                    }
                }
                String nowExitMonitor = "false";
                nowExitMonitor = this.jCheckBox4.isSelected() ? "true" : "false";
                if (!oldExitMonitor.equals(nowExitMonitor)) {
                    Config.updateProperty((String)"exitMonitor", (String)nowExitMonitor);
                }
            } else {
                String oldAlwaysOnTop = Config.getString((String)"alwaysOnTop", (String)"false").trim();
                String nowAlwaysOnTop = "false";
                nowAlwaysOnTop = this.jCheckBox4.isSelected() ? "true" : "false";
                if (!oldAlwaysOnTop.equals(nowAlwaysOnTop)) {
                    Config.updateProperty((String)"alwaysOnTop", (String)nowAlwaysOnTop);
                }
            }
            String webPort = this.webPortTextField.getText().trim();
            String shutdownPort = this.shutdownportTextField.getText().trim();
            String hostIp = this.hostIPTextField.getText().trim();
            String hostPort = this.portTextField.getText().trim();
            String username = this.jTextField3.getText().trim();
            String password = new String(this.jPasswordField1.getPassword()).trim();
            String downloadText = this.downloadTextField.getText().trim();
            String saveText = this.saveTextField.getText().trim();
            if (!ConfigFrame.isNumeric(webPort) || !ConfigFrame.isNumeric(shutdownPort)) {
                DisplayMessage.showErrorDialog("message.inputerror", "message.info");
                return;
            }
            if (this.jCheckBox1.isSelected()) {
                if (!VolStr.isIP((String)hostIp) || !ConfigFrame.isNumeric(hostPort) || ConfigFrame.isNull(hostIp) || ConfigFrame.isNull(hostPort)) {
                    DisplayMessage.showErrorDialog("message.inputerror", "message.info");
                    return;
                }
                if (this.jCheckBox3.isSelected() && (ConfigFrame.isNull(username) || ConfigFrame.isNull(password))) {
                    DisplayMessage.showErrorDialog("message.inputerror", "message.info");
                    return;
                }
            }
            if (webPort.equals(shutdownPort)) {
                DisplayMessage.showErrorDialog("message.portisUsed", "message.info");
                return;
            }
            boolean validate = true;
            boolean mustStopmonitor = false;
            if (!oldWebPort.equals(webPort)) {
                if (Cmd.isUsed(webPort) || Cmd.isBind(webPort)) {
                    DisplayMessage.showErrorDialog("message.portisUsed", webPort, "message.info");
                    validate = false;
                } else {
                    mustStopmonitor = true;
                }
            }
            if (!oldshutdownPort.equals(shutdownPort)) {
                if (Cmd.isUsed(shutdownPort) || Cmd.isBind(shutdownPort)) {
                    DisplayMessage.showErrorDialog("message.portisUsed", shutdownPort, "message.info");
                    validate = false;
                } else {
                    mustStopmonitor = true;
                }
            }
            if (!validate) {
                return;
            }
            boolean useHttps = this.useHttpsRadio.isSelected();
            if (mustStopmonitor) {
                boolean re;
                if (MyConstants.IS_OS_WINDOWS) {
                    if (MonitorConsole.getConsoleTray() != null) {
                        MonitorConsole.getConsoleTray().stopMonitor("updatePort");
                    }
                } else if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                    if (LinuxMonitorConsole.getConsoleTray() != null) {
                        LinuxMonitorConsole.getConsoleTray().stopMonitor("updatePort");
                    }
                } else if (MacMonitorConsole.getMacTray() != null) {
                    MacMonitorConsole.getMacTray().stopMonitor("updatePort");
                }
                logger.info((Object)("useHttps" + useHttps));
                boolean re1 = ModifyTomcatXML.xmlUpdate(webPort, "HTTP/1.1");
                if (useHttps) {
                    re1 = ModifyTomcatXML.xmlUpdate("0", "HTTP/1.1");
                    re1 = ModifyTomcatXML.xmlUpdate("port", webPort, "scheme", "https");
                } else {
                    re1 = ModifyTomcatXML.xmlUpdate(webPort, "HTTP/1.1");
                    re1 = ModifyTomcatXML.xmlUpdate("port", "0", "scheme", "https");
                }
                if (re1) {
                    Config.updateProperty((String)"port", (String)webPort);
                }
                if (!oldshutdownPort.equals(shutdownPort) && (re = ModifyTomcatXML.xmlUpdate(shutdownPort, "SHUTDOWN"))) {
                    Config.updateProperty((String)"shutdownPort", (String)shutdownPort);
                }
                if (MyConstants.IS_OS_WINDOWS) {
                    if (MonitorConsole.getConsoleTray() != null) {
                        MonitorConsole.getConsoleTray().startMonitor("updatePort");
                    }
                } else if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                    if (LinuxMonitorConsole.getConsoleTray() != null) {
                        LinuxMonitorConsole.getConsoleTray().startMonitor("updatePort");
                    }
                } else if (MacMonitorConsole.getMacTray() != null) {
                    MacMonitorConsole.getMacTray().startMonitor("updatePort");
                }
            }
            String string = newHTTP = useHttps ? "https" : "http";
            if (!newHTTP.equals(oldHTTP)) {
                if (useHttps) {
                    ModifyTomcatXML.xmlUpdate("0", "HTTP/1.1");
                    ModifyTomcatXML.xmlUpdate("port", webPort, "scheme", "https");
                    if (MyConstants.IS_OS_WINDOWS) {
                        SystemConsoleTray.popup.remove(SystemConsoleTray.logList);
                        SystemConsoleTray.popup.remove(SystemConsoleTray.openMonitor);
                        SystemConsoleTray.popup.remove(SystemConsoleTray.exitItem);
                        SystemConsoleTray.popup.add(SystemConsoleTray.certItem);
                        SystemConsoleTray.popup.add(SystemConsoleTray.logList);
                        SystemConsoleTray.popup.add(SystemConsoleTray.openMonitor);
                        SystemConsoleTray.popup.add(SystemConsoleTray.exitItem);
                    } else if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                        LinuxMonitorConsole.getConsoleTray().setHTTPS(true);
                    } else {
                        MacMonitorConsole.getMacTray().setHTTPS(true);
                    }
                } else {
                    ModifyTomcatXML.xmlUpdate(webPort, "HTTP/1.1");
                    ModifyTomcatXML.xmlUpdate("port", "0", "scheme", "https");
                    if (MyConstants.IS_OS_WINDOWS) {
                        SystemConsoleTray.popup.remove(SystemConsoleTray.certItem);
                    } else if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                        LinuxMonitorConsole.getConsoleTray().setHTTPS(false);
                    } else {
                        MacMonitorConsole.getMacTray().setHTTPS(false);
                    }
                }
            }
            Config.updateProperty((String)"useHttps", (String)String.valueOf(useHttps));
            if (!ConfigFrame.isNull(downloadText) && !ConfigFrame.isNull(saveText)) {
                Config.updateProperty((String)"downloadDir", (String)downloadText);
                Config.updateProperty((String)"saveDir", (String)saveText);
            }
            if (this.jCheckBox2.isSelected()) {
                Config.updateProperty((String)"autoDetect", (String)"true");
            } else {
                Config.updateProperty((String)"autoDetect", (String)"false");
            }
            if (this.jCheckBox1.isSelected()) {
                Config.updateProperty((String)"useProxy", (String)"true");
                Config.updateProperty((String)"proxyIP", (String)hostIp);
                Config.updateProperty((String)"proxyPort", (String)hostPort);
                if (this.jCheckBox3.isSelected()) {
                    Config.updateProperty((String)"useAuth", (String)"true");
                    Config.updateProperty((String)"proxyUser", (String)username);
                    Config.updateProperty((String)"proxyPassword", (String)MD5Util.transform(password));
                } else {
                    Config.updateProperty((String)"useAuth", (String)"false");
                    Config.updateProperty((String)"proxyUser", (String)username);
                    Config.updateProperty((String)"proxyPassword", (String)MD5Util.transform(password));
                }
            } else {
                Config.updateProperty((String)"useProxy", (String)"false");
                Config.updateProperty((String)"proxyIP", (String)hostIp);
                Config.updateProperty((String)"proxyPort", (String)hostPort);
            }
            Config.refreashProperties();
            if (!newHTTP.equals(oldHTTP) || mustStopmonitor) {
                if (Cmd.serverstatusinapprun() == 4) {
                    StopTomcat stopTomcat = new StopTomcat();
                    stopTomcat.start();
                } else {
                    StartTomcat tomcat = new StartTomcat();
                    tomcat.start();
                }
            }
            oldHTTP = newHTTP;
        }
        catch (Exception e) {
            e.printStackTrace();
            DisplayMessage.showErrorDialog("message.operationfailure", "message.info");
        }
        this.dispose();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void testConnection() {
        HttpURLConnection httpUrl = null;
        InputStream inputStream = null;
        URL url = null;
        String dir = this.downloadTextField.getText().trim();
        System.out.println(dir);
        try {
            try {
                url = new URL(dir);
                String proxy = this.hostIPTextField.getText().trim();
                String port = this.portTextField.getText().trim();
                boolean useProxy = this.jCheckBox1.isSelected();
                boolean useAuth = this.jCheckBox3.isSelected();
                if (useProxy) {
                    Properties systemProperties = System.getProperties();
                    systemProperties.setProperty("http.proxyHost", proxy);
                    systemProperties.setProperty("http.proxyPort", port);
                }
                httpUrl = (HttpURLConnection)url.openConnection();
                httpUrl.setConnectTimeout(5000);
                httpUrl.connect();
                inputStream = httpUrl.getInputStream();
                DisplayMessage.showInfoDialog("message.connectionsuccess", "message.info");
                return;
            }
            catch (FileNotFoundException ex) {
                DisplayMessage.showInfoDialog("message.connectionsuccess", "message.info");
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                DisplayMessage.showErrorDialog("message.connectionfailure", "message.info");
                if (httpUrl != null) {
                    httpUrl.disconnect();
                }
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        finally {
            if (httpUrl != null) {
                httpUrl.disconnect();
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static boolean isNumeric(String str) {
        if (str == null || "".equalsIgnoreCase(str)) {
            return false;
        }
        int i = str.length();
        while (--i >= 0) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        int num = Integer.parseInt(str);
        return num <= 65536 && num >= 1;
    }

    protected static boolean isNull(String str) {
        return str == null || "".equalsIgnoreCase(str);
    }
}

