/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.upgrade;

import cn.com.voltronic.awt.AAButton;
import cn.com.voltronic.awt.AALabel;
import cn.com.voltronic.awt.AAPanel;
import cn.com.voltronic.awt.AATextField;
import cn.com.voltronic.consoleutil.ReadDatFile;
import cn.com.voltronic.consoleutil.ReadTempDatFile;
import cn.com.voltronic.upgrade.StopService15;
import cn.com.voltronic.upgrade.StopService16;
import cn.com.voltronic.upgrade.UpgradeUtil;
import cn.com.voltronic.view.DisplayMessage;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;

public abstract class UpByUserDialog
extends JFrame {
    private static final long serialVersionUID = 2002701722574427113L;
    protected AAButton browser;
    protected AAButton update;
    protected AALabel selectFile;
    protected AALabel note;
    protected AAPanel jPanel1;
    protected AATextField filepath;
    protected JFileChooser fDialog;
    protected String filepathStr;

    public abstract void initComponents();

    protected void updateAction() {
        String oldFileName = "";
        float oldLength = 0.0f;
        long oldTime = 0L;
        try {
            oldFileName = ReadDatFile.getString("fileName");
            oldLength = Float.parseFloat(ReadDatFile.getString("fileSize"));
            oldTime = Long.parseLong(ReadDatFile.getString("lastModified"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        File file = new File(this.filepathStr);
        String fileName = file.getName();
        long length = file.length();
        long time = file.lastModified();
        if (fileName.equals(oldFileName) && (float)length == oldLength && time == oldTime) {
            DisplayMessage.showInfoDialog("message.alreadyUpgrade", "message.info");
            UpgradeUtil.refreshStatus(true, true);
            return;
        }
        String fromZipPath = this.filepathStr.trim();
        try {
            ReadTempDatFile.updateProperty("fileName", fileName.trim());
            ReadTempDatFile.updateProperty("fileSize", String.valueOf(length));
            ReadTempDatFile.updateProperty("lastModified", String.valueOf(time));
            Config.updateProperty((String)"fromZipPath", (String)fromZipPath);
            if (System.getProperty("java.version").startsWith("1.6")) {
                StopService16 stopService = new StopService16();
                stopService.setFrame(this);
                stopService.start();
            } else {
                StopService15 stopService = new StopService15();
                stopService.setFrame(this);
                stopService.start();
            }
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected int getFileDialog() {
        this.fDialog = new JFileChooser();
        this.fDialog.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return MyConstants.IS_OS_WINDOWS ? f.getName().endsWith(".zip") || f.isDirectory() : (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS ? f.getName().endsWith(".tar.gz") || f.isDirectory() : f.getName().endsWith(".zip") || f.isDirectory());
            }

            @Override
            public String getDescription() {
                if (MyConstants.IS_OS_WINDOWS) {
                    return "*.zip";
                }
                if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                    return "*.tar.gz";
                }
                return "*.zip";
            }
        });
        int result = this.fDialog.showOpenDialog(this);
        return result;
    }
}

