/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.console.windows;

import cn.com.voltronic.cer.CertLoad;
import cn.com.voltronic.cer.CertificateJFrame;
import cn.com.voltronic.cmd.Cmd;
import cn.com.voltronic.console.UpsTray;
import cn.com.voltronic.console.UpsTrayThread;
import cn.com.voltronic.console.windows.MonitorConsole;
import cn.com.voltronic.console.windows.StartMonitorThread;
import cn.com.voltronic.console.windows.StopMonitorThread;
import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.upgrade.StartUpgrade;
import cn.com.voltronic.view.ConfigFrame15;
import cn.com.voltronic.view.ConfigFrame16;
import cn.com.voltronic.view.ConfigFrame_HTTPS;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorcommunicate.UdpClient;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.EventQueue;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;

public class SystemConsoleTray
extends UpsTray {
    private static final long serialVersionUID = -5072675904974855971L;
    private static final Log logger = new Log();
    private SystemTray tray = null;
    public static PopupMenu popup;
    private CheckboxMenuItem startItem;
    private CheckboxMenuItem stopItem;
    private boolean inApp;
    private Menu updateItem;
    public MenuItem updateOnline;
    public MenuItem updateByUser;
    public static Menu logList;
    public static MenuItem openMonitor;
    public static MenuItem exitItem;
    private boolean isFirst = true;
    private boolean isFirstNumber = true;
    public static Menu certItem;
    private boolean testModeStatus = false;

    public SystemConsoleTray() {
        try {
            this.initTray();
            Cmd.startDaemon();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerService() {
        Cmd.registerService();
    }

    public void initTray() throws AWTException {
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            popup = new PopupMenu();
            this.initMenu();
            trayIcon = MyConstants.SERVER_NAME.equals("Bxterra") ? new TrayIcon(this.monitorDownImg, "PowerFrame Personal", popup) : new TrayIcon(this.monitorDownImg, String.valueOf(MyConstants.SERVER_NAME) + " Monitor System", popup);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
                }
            };
            trayIcon.addActionListener(listener);
            this.addToSystemTray();
        }
    }

    public void addLogMenu() {
        final String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "log" + File.separator + "testlog";
        final CheckboxMenuItem testMode = new CheckboxMenuItem("Start");
        testMode.addItemListener(new ItemListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    testMode.setLabel("Stop");
                    SystemConsoleTray.this.testModeStatus = true;
                    try (SystemTrayUDPClient client = null;){
                        try {
                            client = new SystemTrayUDPClient("localhost", 51222);
                            client.send("TEST_MODE#true".getBytes());
                            return;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            if (client == null) return;
                            client.close();
                        }
                        return;
                    }
                }
                testMode.setLabel("Start");
                SystemConsoleTray.this.testModeStatus = false;
                try (SystemTrayUDPClient client = null;){
                    try {
                        client = new SystemTrayUDPClient("localhost", 51222);
                        client.send("TEST_MODE#false".getBytes());
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        if (client == null) return;
                        client.close();
                    }
                    return;
                }
            }
        });
        if (this.testModeStatus) {
            testMode.setLabel("Stop");
            testMode.setState(true);
        } else {
            testMode.setLabel("Start");
            testMode.setState(false);
        }
        logList.add(testMode);
        MenuItem moreFile = new MenuItem("Logs");
        moreFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SystemConsoleTray.this.openFile(String.valueOf(path) + File.separator);
            }
        });
        logList.add(moreFile);
    }

    public void initMenu() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
            }
        };
        ActionListener updateOnlinelistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateOnline();
            }
        };
        ActionListener updateByUserlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateByUser();
            }
        };
        ActionListener exitlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String exitMonitor = Config.getString((String)"exitMonitor", (String)"false").trim();
                Boolean isExitMonitor = Boolean.parseBoolean(exitMonitor);
                if (isExitMonitor.booleanValue()) {
                    SystemConsoleTray.this.stopMonitor("");
                }
                exitItem.setEnabled(false);
                String exitMask = "CONSOLE_EXIT";
                UpsTrayThread.stopping = true;
                try (SystemTrayUDPClient client = null;){
                    try {
                        client = new SystemTrayUDPClient("localhost", 33654);
                        client.send(exitMask.getBytes());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        if (client != null) {
                            client.close();
                        }
                    }
                }
            }
        };
        ActionListener configListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MyConstants.enableHTTPS) {
                    ConfigFrame_HTTPS.getInstance();
                } else if (System.getProperty("java.version").startsWith("1.5")) {
                    ConfigFrame15.getInstance();
                } else {
                    ConfigFrame16.getInstance();
                }
            }
        };
        ItemListener startlistener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem().toString().equals("Start Monitor")) {
                    SystemConsoleTray.this.startMonitor("");
                } else {
                    SystemConsoleTray.this.stopMonitor("");
                }
            }
        };
        final MenuItem snmpItem = new MenuItem("SNMP Manager");
        ActionListener snmplistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        CheckboxMenuItem enableSnmpitem = new CheckboxMenuItem("Enable SNMP");
        final CheckboxMenuItem timeserver = new CheckboxMenuItem("SNMP Time Server");
        ItemListener enableSNMP = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Config.updateProperty((String)"showNetSNMP", (String)"true");
                    snmpItem.setEnabled(true);
                    timeserver.setEnabled(true);
                    timeserver.setState(Config.getBoolean((String)"issnmptimeserver"));
                    SystemConsoleTray.this.sendUdpForProperties("updateVIEWPOWER");
                } else {
                    Config.updateProperty((String)"showNetSNMP", (String)"false");
                    snmpItem.setEnabled(false);
                    timeserver.setEnabled(false);
                    timeserver.setState(false);
                    SystemConsoleTray.this.sendUdpForProperties("closeAllSNMP");
                }
            }
        };
        ItemListener enabletimeserver = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Config.updateProperty((String)"issnmptimeserver", (String)"true");
                } else {
                    Config.updateProperty((String)"issnmptimeserver", (String)"false");
                }
            }
        };
        ActionListener genCertListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new CertificateJFrame().setVisible(true);
                    }
                });
            }
        };
        ActionListener loadCertListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new CertLoad().setVisible(true);
                    }
                });
            }
        };
        openMonitor = new MenuItem("Open Monitor");
        openMonitor.setEnabled(false);
        this.startItem = new CheckboxMenuItem("Start Monitor");
        this.stopItem = new CheckboxMenuItem("Stop Monitor");
        this.updateItem = new Menu("Software Update");
        this.updateOnline = new MenuItem("Online Update");
        this.updateByUser = new MenuItem("Manually Update");
        this.updateItem.add(this.updateOnline);
        this.updateItem.add(this.updateByUser);
        MenuItem configItem = new MenuItem("Configuration");
        logList = new Menu("Debug Mode");
        exitItem = new MenuItem("Exit");
        certItem = new Menu("Https");
        MenuItem genCertItem = new MenuItem("Generate certificate");
        MenuItem loadCertItem = new MenuItem("Import certificate");
        certItem.add(genCertItem);
        certItem.add(loadCertItem);
        genCertItem.addActionListener(genCertListener);
        loadCertItem.addActionListener(loadCertListener);
        openMonitor.addActionListener(listener);
        configItem.addActionListener(configListener);
        this.startItem.addItemListener(startlistener);
        this.stopItem.addItemListener(startlistener);
        enableSnmpitem.addItemListener(enableSNMP);
        snmpItem.addActionListener(snmplistener);
        timeserver.addItemListener(enabletimeserver);
        this.updateOnline.addActionListener(updateOnlinelistener);
        this.updateByUser.addActionListener(updateByUserlistener);
        exitItem.addActionListener(exitlistener);
        popup.add(this.startItem);
        popup.add(this.stopItem);
        if (MyConstants.USE_SNMP) {
            popup.add(enableSnmpitem);
            popup.add(snmpItem);
            popup.add(timeserver);
        }
        popup.add(configItem);
        popup.add(certItem);
        popup.add(logList);
        this.addLogMenu();
        popup.add(openMonitor);
        popup.add(exitItem);
        if (Config.getBoolean((String)"showNetSNMP")) {
            enableSnmpitem.setState(true);
            snmpItem.setEnabled(true);
            timeserver.setEnabled(true);
            timeserver.setState(Config.getBoolean((String)"issnmptimeserver"));
        } else {
            enableSnmpitem.setState(false);
            snmpItem.setEnabled(false);
            timeserver.setEnabled(false);
        }
        if (Config.getString((String)"useHttps").equalsIgnoreCase("false")) {
            popup.remove(certItem);
        }
    }

    @Override
    public void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
        if (trayIcon == null) {
            try {
                this.initTray();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!caption.equals("SERVICE_START")) {
            trayIcon.displayMessage(caption, text, messageType);
        }
    }

    @Override
    public void addToSystemTray() {
        try {
            this.tray.remove(trayIcon);
            this.tray.add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean statusisruning() {
        return Cmd.rmiportstatus() == 4 && Cmd.serverstatusinapprun() == 4;
    }

    private void openFile(String url) {
        try {
            File file1 = new File(url);
            if (!file1.exists() && file1.isDirectory()) {
                file1.mkdirs();
            }
            if (MyConstants.IS_OS_WINDOWS) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + file1);
            } else {
                Runtime.getRuntime().exec(file1.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void sendUdpForProperties(String cmd) {
        UdpClient udp = null;
        try {
            try {
                udp = new UdpClient("127.0.0.1");
                udp.setPort("51222");
                udp.send(cmd);
            }
            catch (Exception exception) {
                if (udp != null) {
                    udp.disconnect();
                }
            }
        }
        finally {
            if (udp != null) {
                udp.disconnect();
            }
        }
    }

    public boolean isInApp() {
        return this.inApp;
    }

    public void setInApp(boolean inApp) {
        this.inApp = inApp;
    }

    @Override
    public void displayMessage(String message) {
    }

    @Override
    public void refreshMonitorNumber(int number) {
        if (this.isOldNumber() != number > 0 || this.isFirstNumber) {
            if (number > 0) {
                if (this.isInApp()) {
                    trayIcon.setImage(this.appMonitorImg);
                } else {
                    trayIcon.setImage(this.serverMonitorImg);
                }
            } else if (this.isInApp()) {
                trayIcon.setImage(this.appNoneImg);
            } else {
                trayIcon.setImage(this.serverNoneImg);
            }
            this.setOldNumber(number > 0);
            this.isFirstNumber = false;
        }
    }

    @Override
    public void refreshTrayImg() {
        try (SystemTrayUDPClient client = null;){
            boolean running;
            boolean bl = running = Cmd.rmiportstatus() == 4;
            if (this.isOldRunning() != running || this.isFirst) {
                if (running) {
                    if (this.isInApp()) {
                        trayIcon.setImage(this.appNoneImg);
                    } else {
                        trayIcon.setImage(this.serverNoneImg);
                    }
                } else {
                    trayIcon.setImage(this.monitorDownImg);
                }
                this.startItem.setEnabled(!running);
                this.stopItem.setEnabled(running);
                this.startItem.setState(running);
                this.stopItem.setState(!running);
                openMonitor.setEnabled(running);
                this.isFirst = false;
                this.setOldRunning(running);
            }
            if (!running) {
                return;
            }
            try {
                client = new SystemTrayUDPClient("localhost", 51222);
                client.send("getProcessorNumber".getBytes("UTF-8"));
            }
            catch (Exception e) {
                logger.info((Object)e.getStackTrace());
            }
        }
    }

    @Override
    public void refreshUpgrade(boolean online, boolean manually) {
        this.updateOnline.setEnabled(online);
        this.updateByUser.setEnabled(manually);
    }

    @Override
    public void startMonitor(String mark) {
        this.displayMessage("Monitor is starting...", "Please wait...", TrayIcon.MessageType.INFO);
        StartMonitorThread startMonitor = new StartMonitorThread();
        if (Cmd.serverstatus() == 1060) {
            this.setInApp(true);
        } else {
            this.setInApp(false);
        }
        if (mark.equalsIgnoreCase("updatePort")) {
            startMonitor.setUpdatePort(true);
        } else {
            startMonitor.setUpdatePort(false);
        }
        startMonitor.setApp(this.inApp);
        startMonitor.start();
        this.isFirstNumber = true;
        while (!startMonitor.isComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setStartStop(false, true);
    }

    @Override
    public void stopMonitor(String mark) {
        boolean isUpdatePort = false;
        if (mark.equalsIgnoreCase("exit")) {
            Cmd.stopDaemon();
            this.displayMessage("Monitor is exiting...", "Please wait...", TrayIcon.MessageType.INFO);
        } else if (mark.equalsIgnoreCase("updatePort")) {
            this.displayMessage("Monitor is stopping...", "Please wait...", TrayIcon.MessageType.INFO);
            isUpdatePort = true;
        } else {
            this.displayMessage("Monitor is stopping...", "Please wait...", TrayIcon.MessageType.INFO);
        }
        StopMonitorThread stop = new StopMonitorThread();
        if (Cmd.serverstatus() == 1060) {
            this.setInApp(true);
        } else {
            this.setInApp(false);
        }
        stop.setApp(this.inApp);
        stop.setUpdatePort(isUpdatePort);
        stop.start();
        this.isFirst = true;
        while (!stop.isComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setStartStop(true, false);
    }

    @Override
    public void setStartStop(boolean start, boolean stop) {
        this.startItem.setEnabled(start);
        this.stopItem.setEnabled(stop);
    }

    public static void main(String[] args) {
        SystemConsoleTray tray = new SystemConsoleTray();
        tray.displayMessage("Monitor is starting...", "Please wait...", TrayIcon.MessageType.INFO);
    }

    @Override
    public void setHTTPS(boolean https) {
    }
}

