/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.console.windows;

import cn.com.voltronic.cmd.Cmd;
import cn.com.voltronic.console.UpsTray;
import cn.com.voltronic.console.UpsTrayThread;
import cn.com.voltronic.console.windows.MyanmarThread;
import cn.com.voltronic.console.windows.SystemConsoleTray;
import cn.com.voltronic.socket.DatagramServer;
import cn.com.voltronic.socket.SystemTrayUDPServer;
import cn.com.voltronic.upgrade.StartUpgrade;
import cn.com.voltronic.view.EventInfoDialog;
import cn.com.voltronic.view.EventInfoDialog17;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.UIManager;

public class MonitorConsole {
    private static final Log logger = new Log();
    public EventInfoDialog dialog = null;
    public EventInfoDialog17 dialog2 = null;
    public boolean ison = false;
    public List<String> infoList = new LinkedList<String>();
    public boolean isopen = false;
    public static final String UPGRADE_EXIT = "(exit:upgrade";
    public MyanmarThread myThread = null;
    private static UpsTray consoleTray;

    public static UpsTray getConsoleTray() {
        return consoleTray;
    }

    public MonitorConsole() {
        try {
            Properties props = new Properties();
            if ("NEXTVision".equals(MyConstants.VIEWPOWER_NAME) || "EVI".equals(MyConstants.VIEWPOWER_NAME)) {
                props.put("frameColor", "165 203 9");
                props.put("gridColor", "165 203 9");
                props.put("tooltipBackgroundColor", "240 250 190");
                props.put("logoString", "");
                props.put("selectionBackgroundColor", "215 250 90");
                props.put("menuSelectionBackgroundColor", "215 250 90");
                props.put("menuBackgroundColor", "236 254 207");
                props.put("menuColorLight", "203 231 249");
                props.put("menuColorDark", "236 254 207");
                props.put("controlColor", "240 250 190");
                props.put("controlColorLight", "240 250 190");
                props.put("controlColorDark", "215 250 90");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "240 250 190");
                props.put("rolloverColorLight", "240 250 190");
                props.put("rolloverColorDark", "215 250 90");
                props.put("windowTitleForegroundColor", "0 0 0");
                props.put("windowTitleBackgroundColor", "165 203 9");
                props.put("windowTitleColorLight", "240 250 190");
                props.put("windowTitleColorDark", "165 203 9");
                props.put("windowBorderColor", "240 250 190");
                props.put("backgroundColor", "236 254 207");
                props.put("backgroundColorLight", "236 254 207");
                props.put("backgroundColorDark", "215 250 90");
            } else if (MyConstants.VIEWPOWER_NAME.equals("PowerFrame")) {
                props.put("frameColor", "169 169 169");
                props.put("gridColor", "169 169 169");
                props.put("tooltipBackgroundColor", "169 169 169");
                props.put("selectionBackgroundColor", "169 169 169");
                props.put("menuSelectionBackgroundColor", "230 230 230");
                props.put("menuBackgroundColor", "230 230 230");
                props.put("menuColorLight", "230 230 230");
                props.put("menuColorDark", "230 230 230");
                props.put("logoString", "");
                props.put("controlColor", "218 254 230");
                props.put("controlColorLight", "218 254 230");
                props.put("controlColorDark", "180 240 197");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "218 254 230");
                props.put("rolloverColorLight", "218 254 230");
                props.put("rolloverColorDark", "180 240 197");
                props.put("windowTitleForegroundColor", "255 255 255");
                props.put("windowTitleBackgroundColor", "93 167 222");
                props.put("windowTitleColorLight", "115 182 67");
                props.put("windowTitleColorDark", "115 182 67");
                props.put("windowBorderColor", "115 182 67");
                props.put("backgroundColor", "230 230 230");
                props.put("backgroundColorLight", "205 231 246");
                props.put("backgroundColorDark", "180 240 197");
            } else {
                props.put("frameColor", "93 167 222");
                props.put("gridColor", "93 167 222");
                props.put("tooltipBackgroundColor", "218 254 230");
                props.put("logoString", "");
                props.put("selectionBackgroundColor", "180 240 197");
                props.put("menuSelectionBackgroundColor", "180 240 197");
                props.put("menuBackgroundColor", "205 231 246");
                props.put("menuColorLight", "203 231 249");
                props.put("menuColorDark", "205 231 246");
                props.put("controlColor", "218 254 230");
                props.put("controlColorLight", "218 254 230");
                props.put("controlColorDark", "180 240 197");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "218 254 230");
                props.put("rolloverColorLight", "218 254 230");
                props.put("rolloverColorDark", "180 240 197");
                props.put("windowTitleForegroundColor", "0 0 0");
                props.put("windowTitleBackgroundColor", "93 167 222");
                props.put("windowTitleColorLight", "218 254 230");
                props.put("windowTitleColorDark", "93 167 222");
                props.put("windowBorderColor", "218 254 230");
                props.put("backgroundColor", "205 231 246");
                props.put("backgroundColorLight", "205 231 246");
                props.put("backgroundColorDark", "180 240 197");
            }
            SmartLookAndFeel.setCurrentTheme((Properties)props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            logger.info((Object)ex.getMessage());
        }
    }

    public static void main(String[] args) {
        MonitorConsole.delJre();
        new MonitorConsole().startRun();
    }

    private static void delJre() {
        Runtime rt = Runtime.getRuntime();
        String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "jre";
        File f = new File(path);
        if (f.exists()) {
            String cmd = "cmd /C rmdir /s/q " + path;
            try {
                rt.exec(cmd);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startRun() {
        DatagramServer udpServerSocket = null;
        try {
            udpServerSocket = SystemTrayUDPServer.getServer((int)33654);
            consoleTray = new SystemConsoleTray();
            if (!consoleTray.statusisruning()) {
                consoleTray.startMonitor("");
            }
            UpsTrayThread thread = new UpsTrayThread(consoleTray);
            thread.start();
            boolean isUpgrade = false;
            while (true) {
                try {
                    while (true) {
                        StringBuffer sb;
                        String message;
                        if ((message = udpServerSocket.receive().trim()).equals("CONSOLE_EXIT")) {
                            if (udpServerSocket != null) {
                                udpServerSocket.close();
                                udpServerSocket = null;
                            }
                            Cmd.stopDaemon();
                            while (UpsTrayThread.stoped < 1) {
                                Thread.sleep(500L);
                            }
                            System.exit(0);
                            continue;
                        }
                        if (message.startsWith(UPGRADE_EXIT)) {
                            isUpgrade = true;
                            if (udpServerSocket != null) {
                                udpServerSocket.close();
                                udpServerSocket = null;
                            }
                            Cmd.stopDaemon();
                            if (isUpgrade) {
                                StartUpgrade.runUpgrade();
                            }
                            System.exit(0);
                            continue;
                        }
                        if (message.startsWith("(language:")) {
                            String currentLanguage = message.substring(10);
                            consoleTray.changeLanguage(currentLanguage);
                            continue;
                        }
                        if (message.startsWith("UPS_NUMBER")) {
                            try {
                                int number = Integer.parseInt(message.split("###")[1]);
                                consoleTray.refreshMonitorNumber(number);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (message.equals("redrawtray")) {
                            consoleTray.addToSystemTray();
                            udpServerSocket.response("redrawok");
                            continue;
                        }
                        if (message.equals("shutdown")) {
                            udpServerSocket.response("(ACK");
                            try {
                                String filePath = String.valueOf(System.getProperty("user.dir")) + File.separator + "ShutDownExe.exe shutdown ";
                                Cmd.execnoreturn(filePath);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue;
                        }
                        if (message.startsWith("exec#")) {
                            String execStr = message.split("###")[1];
                            try {
                                udpServerSocket.response("ACK");
                                Cmd.execnoreturn(execStr);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue;
                        }
                        if (!message.startsWith("(Event:")) continue;
                        String[] msgs = message.split("\\*");
                        String event = msgs[0].substring(7, msgs[0].lastIndexOf("13"));
                        String eventaddn = String.valueOf(event) + "\n";
                        String startEvent = eventaddn.substring(0, eventaddn.lastIndexOf("]") + 1);
                        String endEvent = eventaddn.substring(eventaddn.lastIndexOf("]") + 2);
                        this.infoList.add(String.valueOf(startEvent) + "\n" + "     " + endEvent);
                        if (!this.isopen) {
                            this.dialog = EventInfoDialog.getInstance();
                            this.dialog.setVisible(true);
                            this.isopen = true;
                            this.dialog.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowClosing(WindowEvent e) {
                                    MonitorConsole.this.isopen = false;
                                    MonitorConsole.this.infoList.clear();
                                    MonitorConsole.this.dialog.dispose();
                                }
                            });
                            this.dialog.jButton1.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent evt) {
                                    MonitorConsole.this.isopen = false;
                                    MonitorConsole.this.infoList.clear();
                                    MonitorConsole.this.dialog.dispose();
                                }
                            });
                            sb = new StringBuffer();
                            int i = 0;
                            while (i < this.infoList.size()) {
                                sb.append(this.infoList.get(i));
                                ++i;
                            }
                            this.dialog.getEventTextPanel().setText(sb.toString());
                            this.dialog.getEventTextPanel().setCaretPosition(this.dialog.getEventTextPanel().getText().length());
                        } else {
                            sb = new StringBuffer();
                            int size = this.infoList.size();
                            int i = 0;
                            while (i < size) {
                                sb.append(this.infoList.get(i));
                                ++i;
                            }
                            if (size >= 30) {
                                ((LinkedList)this.infoList).removeFirst();
                            }
                            this.dialog.getEventTextPanel().setText(sb.toString());
                            this.dialog.getEventTextPanel().setCaretPosition(this.dialog.getEventTextPanel().getText().length());
                        }
                        try {
                            if (!Config.getString((String)"Myanmar").equals("Myanmar")) continue;
                            this.dialog.dispose();
                            this.dialog.setAlwaysOnTop(true);
                            if (msgs.length == 2 && msgs[1].equals("1001")) {
                                try {
                                    this.isopen = false;
                                    this.infoList.clear();
                                    this.myThread = new MyanmarThread();
                                    this.myThread.start();
                                }
                                catch (Exception e) {
                                    logger.info((Object)("\u53d1\u751f\u5f02\u5e38=" + e.getMessage()));
                                }
                            }
                            if (msgs.length != 2 || !msgs[1].equals("1002")) continue;
                            Timer nTimer = new Timer();
                            nTimer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    MonitorConsole.this.myThread.closeMessageBox();
                                    MonitorConsole.this.myThread.stop();
                                    MonitorConsole.this.isopen = false;
                                    MonitorConsole.this.infoList.clear();
                                    MonitorConsole.this.dialog2.dispose();
                                }
                            }, 20000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    logger.error((Object)("error: " + e.getStackTrace()));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
            return;
        }
    }

    public static void openURL2(String url) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()) != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openURL(String url) {
        if (Config.getString((String)"useHttps").equalsIgnoreCase("true")) {
            url = "https://localhost:" + Config.getString((String)"port", (String)"15178") + "/" + MyConstants.SERVER_NAME;
        }
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                MonitorConsole.openWindowURL(url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser != null) {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void openWindowURL(String url) {
        String filePath = String.valueOf(System.getProperty("user.dir")) + File.separator + "openJDK" + File.separator + "bin" + File.separator + "ShutDownExe.exe openurl " + url.trim();
        try {
            Runtime.getRuntime().exec(filePath);
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
        }
    }
}

