/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.console.linux;

import cn.com.voltronic.cmd.Cmd;
import cn.com.voltronic.console.UpsTray;
import cn.com.voltronic.console.UpsTrayThread;
import cn.com.voltronic.console.linux.LinuxMonitorTray;
import cn.com.voltronic.socket.DatagramServer;
import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.socket.SystemTrayUDPServer;
import cn.com.voltronic.upgrade.StartUpgrade;
import cn.com.voltronic.view.EventInfoDialog;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.UIManager;

public class LinuxMonitorConsole
extends Thread {
    private static UpsTray consoleTray;
    public EventInfoDialog dialog = null;
    public List<String> infoList = new LinkedList<String>();
    public boolean isopen = false;
    public static final String UPGRADE_EXIT = "(exit:upgrade";
    private static final Log logger;
    private boolean isExit = false;

    static {
        logger = new Log();
    }

    public LinuxMonitorConsole() {
        try {
            Properties props = new Properties();
            if ("NEXTVision".equals(MyConstants.VIEWPOWER_NAME) || "EVI".equals(MyConstants.VIEWPOWER_NAME)) {
                props.put("frameColor", "165 203 9");
                props.put("gridColor", "165 203 9");
                props.put("tooltipBackgroundColor", "240 250 190");
                props.put("logoString", "");
                props.put("selectionBackgroundColor", "215 250 90");
                props.put("menuSelectionBackgroundColor", "215 250 90");
                props.put("menuBackgroundColor", "236 254 207");
                props.put("menuColorLight", "203 231 249");
                props.put("menuColorDark", "236 254 207");
                props.put("controlColor", "240 250 190");
                props.put("controlColorLight", "240 250 190");
                props.put("controlColorDark", "215 250 90");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "240 250 190");
                props.put("rolloverColorLight", "240 250 190");
                props.put("rolloverColorDark", "215 250 90");
                props.put("windowTitleForegroundColor", "0 0 0");
                props.put("windowTitleBackgroundColor", "165 203 9");
                props.put("windowTitleColorLight", "240 250 190");
                props.put("windowTitleColorDark", "165 203 9");
                props.put("windowBorderColor", "240 250 190");
                props.put("backgroundColor", "236 254 207");
                props.put("backgroundColorLight", "236 254 207");
                props.put("backgroundColorDark", "215 250 90");
            } else if (MyConstants.VIEWPOWER_NAME.equals("PowerFrame")) {
                props.put("frameColor", "169 169 169");
                props.put("gridColor", "169 169 169");
                props.put("tooltipBackgroundColor", "169 169 169");
                props.put("selectionBackgroundColor", "169 169 169");
                props.put("menuSelectionBackgroundColor", "230 230 230");
                props.put("menuBackgroundColor", "230 230 230");
                props.put("menuColorLight", "230 230 230");
                props.put("menuColorDark", "230 230 230");
                props.put("logoString", "");
                props.put("controlColor", "218 254 230");
                props.put("controlColorLight", "218 254 230");
                props.put("controlColorDark", "180 240 197");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "218 254 230");
                props.put("rolloverColorLight", "218 254 230");
                props.put("rolloverColorDark", "180 240 197");
                props.put("windowTitleForegroundColor", "255 255 255");
                props.put("windowTitleBackgroundColor", "93 167 222");
                props.put("windowTitleColorLight", "115 182 67");
                props.put("windowTitleColorDark", "115 182 67");
                props.put("windowBorderColor", "115 182 67");
                props.put("backgroundColor", "230 230 230");
                props.put("backgroundColorLight", "205 231 246");
                props.put("backgroundColorDark", "180 240 197");
            } else {
                props.put("frameColor", "93 167 222");
                props.put("gridColor", "93 167 222");
                props.put("tooltipBackgroundColor", "218 254 230");
                props.put("logoString", "");
                props.put("selectionBackgroundColor", "180 240 197");
                props.put("menuSelectionBackgroundColor", "180 240 197");
                props.put("menuBackgroundColor", "205 231 246");
                props.put("menuColorLight", "203 231 249");
                props.put("menuColorDark", "205 231 246");
                props.put("controlColor", "218 254 230");
                props.put("controlColorLight", "218 254 230");
                props.put("controlColorDark", "180 240 197");
                props.put("buttonColor", "218 230 254");
                props.put("buttonColorLight", "255 255 255");
                props.put("buttonColorDark", "244 242 232");
                props.put("rolloverColor", "218 254 230");
                props.put("rolloverColorLight", "218 254 230");
                props.put("rolloverColorDark", "180 240 197");
                props.put("windowTitleForegroundColor", "0 0 0");
                props.put("windowTitleBackgroundColor", "93 167 222");
                props.put("windowTitleColorLight", "218 254 230");
                props.put("windowTitleColorDark", "93 167 222");
                props.put("windowBorderColor", "218 254 230");
                props.put("backgroundColor", "205 231 246");
                props.put("backgroundColorLight", "205 231 246");
                props.put("backgroundColorDark", "180 240 197");
            }
            SmartLookAndFeel.setCurrentTheme((Properties)props);
            UIManager.setLookAndFeel("com.jtattoo.plaf.smart.SmartLookAndFeel");
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LinuxMonitorConsole console = new LinuxMonitorConsole();
        console.start();
    }

    public static UpsTray getConsoleTray() {
        return consoleTray;
    }

    @Override
    public void run() {
        block33: {
            DatagramServer udpServerSocket = null;
            try {
                udpServerSocket = SystemTrayUDPServer.getServer((int)33654);
                consoleTray = LinuxMonitorTray.getInstance();
                UpsTrayThread thread = new UpsTrayThread(consoleTray);
                thread.start();
                boolean isUpgrade = false;
                while (!this.isExit) {
                    try {
                        String message = udpServerSocket.receive().trim();
                        if (message.equals("CONSOLE_EXIT")) {
                            if (udpServerSocket != null) {
                                udpServerSocket.close();
                                udpServerSocket = null;
                            }
                            int time = 0;
                            while (time < 20 && SystemEnv.stoped < 4) {
                                Thread.sleep(500L);
                                ++time;
                            }
                            while (UpsTrayThread.stoped < 1) {
                                Thread.sleep(500L);
                            }
                            this.isExit = true;
                            continue;
                        }
                        if (message.startsWith(UPGRADE_EXIT)) {
                            isUpgrade = true;
                            if (udpServerSocket != null) {
                                udpServerSocket.close();
                                udpServerSocket = null;
                            }
                            Cmd.stopDaemon();
                            if (isUpgrade) {
                                StartUpgrade.runUpgrade();
                            }
                            System.exit(0);
                            continue;
                        }
                        if (message.startsWith("(language:")) {
                            String currentLanguage = message.substring(10);
                            consoleTray.changeLanguage(currentLanguage);
                            continue;
                        }
                        if (message.startsWith("UPS_NUMBER")) {
                            try {
                                int number = Integer.parseInt(message.split("###")[1]);
                                consoleTray.refreshMonitorNumber(number);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (message.startsWith("exec#")) {
                            String execStr = message.split("###")[1];
                            try {
                                Runtime.getRuntime().exec("chmod 777 " + execStr);
                                Runtime.getRuntime().exec(execStr);
                            }
                            catch (Exception ex) {
                                logger.info((Object)("Exception:" + ex.getMessage()));
                                ex.printStackTrace();
                            }
                            continue;
                        }
                        if (message.startsWith("(Event:")) {
                            StringBuffer sb;
                            String event = message.substring(7, message.lastIndexOf("13"));
                            String eventaddn = String.valueOf(event) + "\n";
                            String startEvent = eventaddn.substring(0, eventaddn.lastIndexOf("]") + 1);
                            String endEvent = eventaddn.substring(eventaddn.lastIndexOf("]") + 2);
                            this.infoList.add(String.valueOf(startEvent) + "\n" + "     " + endEvent);
                            if (!this.isopen) {
                                this.dialog = EventInfoDialog.getInstance();
                                this.dialog.setVisible(true);
                                this.isopen = true;
                                this.dialog.addWindowListener(new WindowAdapter(){

                                    @Override
                                    public void windowClosing(WindowEvent e) {
                                        LinuxMonitorConsole.this.isopen = false;
                                        LinuxMonitorConsole.this.infoList.clear();
                                        LinuxMonitorConsole.this.dialog.dispose();
                                    }
                                });
                                this.dialog.jButton1.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent evt) {
                                        LinuxMonitorConsole.this.isopen = false;
                                        LinuxMonitorConsole.this.infoList.clear();
                                        LinuxMonitorConsole.this.dialog.dispose();
                                    }
                                });
                                sb = new StringBuffer();
                                int i = 0;
                                while (i < this.infoList.size()) {
                                    sb.append(this.infoList.get(i));
                                    ++i;
                                }
                                this.dialog.getEventTextPanel().setText(sb.toString());
                                this.dialog.getEventTextPanel().setCaretPosition(this.dialog.getEventTextPanel().getText().length());
                                continue;
                            }
                            sb = new StringBuffer();
                            int size = this.infoList.size();
                            int i = 0;
                            while (i < size) {
                                sb.append(this.infoList.get(i));
                                ++i;
                            }
                            if (size >= 30) {
                                ((LinkedList)this.infoList).removeFirst();
                            }
                            this.dialog.getEventTextPanel().setText(sb.toString());
                            this.dialog.getEventTextPanel().setCaretPosition(this.dialog.getEventTextPanel().getText().length());
                            continue;
                        }
                        if (!message.equals("OPENPAGE")) continue;
                        LinuxMonitorTray.getInstance().setVisible(true);
                        LinuxMonitorTray.getInstance().setState(0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.isExit) {
                    if ("PowerWalker".equals(MyConstants.SERVER_NAME) && LinuxMonitorTray.exitConsole) {
                        consoleTray.setVisible(false);
                    } else {
                        System.exit(0);
                    }
                }
            }
            catch (Exception e) {
                LinuxMonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
                int port = 33654;
                SystemTrayUDPClient client = null;
                try {
                    try {
                        port = 33654;
                        client = new SystemTrayUDPClient("localhost", port);
                        client.send("OPENPAGE".getBytes());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (client != null) {
                            client.close();
                        }
                    }
                }
                finally {
                    if (client == null) break block33;
                    client.close();
                }
            }
        }
    }

    public static void openURL(String url) {
        try {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            int count = 0;
            while (count < browsers.length && browser == null) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                    browser = browsers[count];
                }
                ++count;
            }
            if (Config.getString((String)"useHttps").equalsIgnoreCase("true")) {
                url = "https://localhost:" + Config.getString((String)"port", (String)"15178") + "/" + MyConstants.SERVER_NAME;
            }
            if (browser != null) {
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

