/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.console.linux;

import cn.com.voltronic.cmd.Cmd;
import cn.com.voltronic.console.DisplayItems;
import cn.com.voltronic.console.UpsTray;
import cn.com.voltronic.console.UpsTrayThread;
import cn.com.voltronic.console.linux.LinuxMonitorConsole;
import cn.com.voltronic.console.linux.LinuxStartMonitorThread;
import cn.com.voltronic.console.linux.LinuxStopMonitorThread;
import cn.com.voltronic.console.windows.MonitorConsole;
import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronic.upgrade.StartUpgrade;
import cn.com.voltronic.view.ConfigFrame15;
import cn.com.voltronic.view.ConfigFrame16;
import cn.com.voltronic.view.ConfigFrame_HTTPS;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorcommunicate.UdpClient;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.awt.AWTException;
import java.awt.CheckboxMenuItem;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LinuxConsoleTray
extends UpsTray {
    private static final long serialVersionUID = -4737525294203739297L;
    private static final Log logger = new Log();
    protected static DisplayItems displayItems = new DisplayItems();
    private SystemTray tray = null;
    public static PopupMenu popup;
    private Menu updateItem;
    public MenuItem updateOnline;
    public MenuItem updateByUser;
    public MenuItem openMonitor;
    public MenuItem exitItem;
    private Menu logList;
    private Image currentImg = this.monitorDownImg;
    private boolean isFirst = true;
    private boolean isExiting = false;
    private boolean testModeStatus = false;

    public LinuxConsoleTray() {
        try {
            this.initTray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addLogMenu() {
        final String path = String.valueOf(System.getProperty("user.dir")) + File.separator + "log" + File.separator + "testlog";
        final CheckboxMenuItem testMode = new CheckboxMenuItem("Start");
        testMode.addItemListener(new ItemListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    testMode.setLabel("Stop");
                    LinuxConsoleTray.this.testModeStatus = true;
                    try (SystemTrayUDPClient client = null;){
                        try {
                            client = new SystemTrayUDPClient("localhost", 51222);
                            client.send("TEST_MODE#true".getBytes());
                            return;
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                            if (client == null) return;
                            client.close();
                        }
                        return;
                    }
                }
                testMode.setLabel("Start");
                LinuxConsoleTray.this.testModeStatus = false;
                try (SystemTrayUDPClient client = null;){
                    try {
                        client = new SystemTrayUDPClient("localhost", 51222);
                        client.send("TEST_MODE#false".getBytes());
                        return;
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        if (client == null) return;
                        client.close();
                    }
                    return;
                }
            }
        });
        if (this.testModeStatus) {
            testMode.setLabel("Stop");
            testMode.setState(true);
        } else {
            testMode.setLabel("Start");
            testMode.setState(false);
        }
        this.logList.add(testMode);
        MenuItem moreFile = new MenuItem("Logs");
        moreFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinuxConsoleTray.this.openFile(String.valueOf(path) + File.separator);
            }
        });
        this.logList.add(moreFile);
    }

    public void initTray() throws AWTException {
        if (SystemTray.isSupported()) {
            this.tray = SystemTray.getSystemTray();
            popup = new PopupMenu();
            this.initMenu();
            trayIcon = MyConstants.SERVER_NAME.equals("Bxterra") ? new TrayIcon(this.monitorDownImg, "PowerFrame Personal", popup) : new TrayIcon(this.monitorDownImg, String.valueOf(MyConstants.SERVER_NAME) + " Monitor System", popup);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
                }
            };
            trayIcon.addActionListener(listener);
            this.addToSystemTray();
        }
    }

    public void initMenu() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinuxMonitorConsole.openURL(SystemEnv.getLocalURL((String)Config.getString((String)"port")));
            }
        };
        ActionListener updateOnlinelistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateOnline();
            }
        };
        ActionListener updateByUserlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartUpgrade start = new StartUpgrade();
                start.updateByUser();
            }
        };
        ActionListener exitlistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinuxConsoleTray.this.exitItem.setEnabled(false);
                LinuxConsoleTray.this.isExiting = true;
                LinuxConsoleTray.this.stopMonitor("exit");
                String exitMask = "CONSOLE_EXIT";
                SystemEnv.stopping = true;
                UpsTrayThread.stopping = true;
                try (SystemTrayUDPClient client = null;){
                    try {
                        client = new SystemTrayUDPClient("localhost", 33654);
                        client.send(exitMask.getBytes());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        if (client != null) {
                            client.close();
                        }
                    }
                }
            }
        };
        final MenuItem snmpItem = new MenuItem("SNMP Manager");
        CheckboxMenuItem enableSnmpitem = new CheckboxMenuItem("Enable SNMP");
        final CheckboxMenuItem timeserver = new CheckboxMenuItem("SNMP Time Server");
        ActionListener snmplistener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        ItemListener enableSNMP = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Config.updateProperty((String)"showNetSNMP", (String)"true");
                    snmpItem.setEnabled(true);
                    timeserver.setEnabled(true);
                    timeserver.setState(Config.getBoolean((String)"issnmptimeserver"));
                    LinuxConsoleTray.this.sendUdpForProperties("updateVIEWPOWER");
                } else {
                    Config.updateProperty((String)"showNetSNMP", (String)"false");
                    snmpItem.setEnabled(false);
                    timeserver.setEnabled(false);
                    timeserver.setState(false);
                    LinuxConsoleTray.this.sendUdpForProperties("closeAllSNMP");
                }
            }
        };
        ItemListener enabletimeserver = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Config.updateProperty((String)"issnmptimeserver", (String)"true");
                } else {
                    Config.updateProperty((String)"issnmptimeserver", (String)"false");
                }
            }
        };
        ActionListener configListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (MyConstants.enableHTTPS) {
                    ConfigFrame_HTTPS.getInstance();
                } else if (System.getProperty("java.version").startsWith("1.5")) {
                    ConfigFrame15.getInstance();
                } else {
                    ConfigFrame16.getInstance();
                }
            }
        };
        popup = new PopupMenu();
        this.openMonitor = new MenuItem("Open Monitor");
        if (this.isFirst) {
            this.openMonitor.setEnabled(false);
        }
        this.updateItem = new Menu("Software Update");
        this.updateOnline = new MenuItem("Online Update");
        this.updateByUser = new MenuItem("Manually Update");
        this.updateItem.add(this.updateOnline);
        this.updateItem.add(this.updateByUser);
        MenuItem configItem = new MenuItem("Configuration");
        this.logList = new Menu("Test Mode");
        this.exitItem = new MenuItem("Exit");
        if (this.isExiting) {
            this.exitItem.setEnabled(false);
        }
        this.openMonitor.addActionListener(listener);
        configItem.addActionListener(configListener);
        enableSnmpitem.addItemListener(enableSNMP);
        snmpItem.addActionListener(snmplistener);
        timeserver.addItemListener(enabletimeserver);
        this.updateOnline.addActionListener(updateOnlinelistener);
        this.updateByUser.addActionListener(updateByUserlistener);
        this.exitItem.addActionListener(exitlistener);
        if (Config.getBoolean((String)"useSnmp")) {
            popup.add(enableSnmpitem);
            popup.add(snmpItem);
            popup.add(timeserver);
        }
        popup.add(configItem);
        popup.add(this.logList);
        this.addLogMenu();
        popup.add(this.openMonitor);
        popup.add(this.exitItem);
        if (Config.getBoolean((String)"showNetSNMP")) {
            enableSnmpitem.setState(true);
            snmpItem.setEnabled(true);
            timeserver.setEnabled(true);
            timeserver.setState(Config.getBoolean((String)"issnmptimeserver"));
        } else {
            enableSnmpitem.setState(false);
            snmpItem.setEnabled(false);
            timeserver.setEnabled(false);
        }
    }

    @Override
    public void displayMessage(String message) {
        String[] messages = message.split("###");
        SimpleDateFormat df = new SimpleDateFormat("MM-dd HH:mm:ss");
        String time = df.format(new Date());
        String msg = "[" + time + "]" + messages[1];
        this.displayMessage(" ", msg, TrayIcon.MessageType.valueOf(messages[2]));
    }

    @Override
    public void displayMessage(String caption, String text, TrayIcon.MessageType messageType) {
        try {
            this.isFirst = false;
            this.initTray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        trayIcon.displayMessage(caption, text, messageType);
    }

    @Override
    public boolean statusisruning() {
        return Cmd.rmiportstatus() == 4 && Cmd.serverstatusinapprun() == 4;
    }

    private void openFile(String url) {
        try {
            File file1 = new File(url);
            if (!file1.exists() && file1.isDirectory()) {
                file1.mkdirs();
            }
            Runtime.getRuntime().exec("chmod 777 " + file1);
            Runtime.getRuntime().exec("nautilus " + file1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void startMonitor(String mark) {
        this.displayMessage("Monitor is starting...", "please wait for a moment", TrayIcon.MessageType.INFO);
        LinuxStartMonitorThread start = new LinuxStartMonitorThread();
        if (mark.equalsIgnoreCase("updatePort")) {
            start.setUpdatePort(true);
        } else {
            start.setUpdatePort(false);
        }
        start.start();
        while (!start.isComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void stopMonitor(String mark) {
        if (mark.equalsIgnoreCase("exit")) {
            this.displayMessage("Monitor is exiting...", "please wait for a moment", TrayIcon.MessageType.INFO);
        } else {
            this.displayMessage("Monitor is stopping...", "please wait for a moment", TrayIcon.MessageType.INFO);
        }
        LinuxStopMonitorThread thread = new LinuxStopMonitorThread();
        if (mark.equalsIgnoreCase("updatePort")) {
            thread.setUpdatePort(true);
        } else {
            thread.setUpdatePort(false);
        }
        thread.start();
        while (!thread.isComplete()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setOldNumber(false);
        this.setOldRunning(false);
    }

    public void sendUdpForProperties(String cmd) {
        UdpClient udp = null;
        try {
            try {
                udp = new UdpClient("localhost");
                udp.setPort("51222");
                udp.send(cmd);
            }
            catch (Exception exception) {
                if (udp != null) {
                    udp.disconnect();
                }
            }
        }
        finally {
            if (udp != null) {
                udp.disconnect();
            }
        }
    }

    @Override
    public void refreshMonitorNumber(int number) {
        if (this.isOldNumber() != number > 0) {
            if (number > 0) {
                trayIcon.setImage(this.appMonitorImg);
                this.setCurrentImg(this.appMonitorImg);
            } else {
                trayIcon.setImage(this.appNoneImg);
                this.setCurrentImg(this.appNoneImg);
            }
            this.setOldNumber(number > 0);
        }
    }

    @Override
    public void refreshTrayImg() {
        block6: {
            SystemTrayUDPClient client = null;
            try {
                boolean running = this.statusisruning();
                if (this.isOldRunning() != running) {
                    if (running) {
                        trayIcon.setImage(this.appNoneImg);
                        this.setCurrentImg(this.appNoneImg);
                    } else {
                        trayIcon.setImage(this.monitorDownImg);
                        this.setCurrentImg(this.monitorDownImg);
                    }
                    this.setOldRunning(running);
                    this.openMonitor.setEnabled(running);
                }
                if (running) {
                    client = new SystemTrayUDPClient("localhost", 51222);
                    client.send("getProcessorNumber".getBytes("UTF-8"));
                }
            }
            catch (Exception e) {
                if (client == null) break block6;
                client.close();
            }
        }
    }

    @Override
    public void refreshUpgrade(boolean online, boolean manually) {
        this.updateOnline.setEnabled(online);
        this.updateByUser.setEnabled(manually);
    }

    @Override
    public void addToSystemTray() {
        try {
            if (this.tray.getTrayIcons().length > 0) {
                this.tray.remove(this.tray.getTrayIcons()[0]);
            }
            this.tray.add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public Image getCurrentImg() {
        return this.currentImg;
    }

    public void setCurrentImg(Image currentImg) {
        this.currentImg = currentImg;
    }

    @Override
    public void setStartStop(boolean start, boolean stop) {
    }

    @Override
    public void setHTTPS(boolean https) {
    }
}

