/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.console;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DisplayItems {
    private static ArrayList<DisplayItem> _items = new ArrayList();
    private static int LEFTSPLIT = 16;
    private static String RN = "\n\r";

    public static void main(String[] args) {
        DisplayItems item = new DisplayItems();
        item.addItem("test1");
        item.addItem("test2");
        item.addItem("test3");
        System.out.println(item.getText().substring(LEFTSPLIT));
        System.out.println(item.getText());
    }

    public String getText() {
        String text = "";
        while (_items.size() > 0 && _items.get(0).isExpired()) {
            _items.remove(0);
        }
        for (DisplayItem item : _items) {
            if (item.isExpired()) continue;
            if (text.length() != 0) {
                text = String.valueOf(text) + RN;
            }
            text = String.valueOf(text) + item.getText();
        }
        return text;
    }

    public void addItem(String text) {
        if (text.trim().length() != 0) {
            DisplayItem item2;
            for (DisplayItem item2 : _items) {
                if (!item2.getNodeText().equals(text)) continue;
                _items.remove(item2);
                break;
            }
            item2 = new DisplayItem(text);
            _items.add(item2);
        }
    }

    class DisplayItem {
        private String _text;
        private long _timeinseconds = System.currentTimeMillis();

        public DisplayItem(String text) {
            SimpleDateFormat df = new SimpleDateFormat("MM-dd HH:mm:ss");
            String time = df.format(new Date());
            this._text = "[" + time + "]" + text;
        }

        public String getText() {
            return this._text;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this._timeinseconds > 6000L;
        }

        public String getNodeText() {
            return this._text.substring(LEFTSPLIT);
        }
    }
}

