/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronic.cmd;

import cn.com.voltronic.cmd.StreamClear;
import cn.com.voltronic.socket.DatagramServer;
import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Cmd {
    private static final Log logger = new Log();
    private static final String DIR = System.getProperty("user.dir");
    private static final String TOMCATFILE = String.valueOf(DIR) + "\\tomcat\\bin\\service.bat";
    private static final String STARTTOMCAT = "sc start upsTomcat";
    private static final String STOPTOMCAT = "sc stop upsTomcat";
    private static final String QUERYSERVER = "sc query upsTomcat";
    private static final String STARTTOMCATINAPP = String.valueOf(DIR) + "\\tomcat\\bin\\startup.bat";
    private static final String STOPTOMCATINAPP = String.valueOf(DIR) + "\\tomcat\\bin\\shutdown.bat";
    private static final String DAEMONSTART = String.valueOf(DIR) + "\\console\\upsTray.exe start";
    private static final String DAEMONCHANGE = String.valueOf(DIR) + "\\console\\upsTray.exe change";
    private static final String DAEMONSTOP = String.valueOf(DIR) + "\\console\\upsTray.exe stop";
    private static final String STARTMONITOR = "sc start upsMonitor";
    private static final String STOPMONITOR = "sc stop upsMonitor";
    private static final String QUERYUPSMONITOR_STATUS = "sc query upsMonitor";
    private static final String LINUX_STARTTOMCAT = String.valueOf(DIR) + "/tomcat/bin/start.sh";
    private static final String LINUX_STOPTOMCAT = String.valueOf(DIR) + "/tomcat/bin/stop.sh";
    private static final String MAC_STARTTOMCAT = String.valueOf(DIR) + "/tomcat/bin/startup.sh";
    private static final String MAC_STOPTOMCAT = String.valueOf(DIR) + "/tomcat/bin/shutdown.sh";
    private static final String AUTOSTART_MONITOR = "sc config upsMonitor start= auto";
    private static final String MANUALLYSTART_MONITOR = "sc config upsMonitor start= demand";
    private static final String FORBIDSTART_MONITOR = "sc config upsMonitor start= disabled";
    public static final int RUNNING = 4;
    public static final int STOP_PENDING = 3;
    public static final int START_PENDING = 2;
    public static final int STOPPED = 1;
    public static final int NOTEXIST = 1060;
    public static final int INSTALLED = 5000;

    public static int startserver() {
        return Cmd.parsingbuffer(STARTTOMCAT);
    }

    public static int queryUPSMonitorServiceStatus() {
        int status = Cmd.parsingbuffer(QUERYUPSMONITOR_STATUS);
        return status;
    }

    public static void startUPSMonitorService() {
        try {
            Cmd.execnoreturn(STARTMONITOR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startUPSMonitorApp() {
    }

    public static void stopUPSMonitorService() {
        try {
            Cmd.execnoreturn(STOPMONITOR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startserverinapp() {
        try {
            Cmd.execnoreturn(STARTTOMCATINAPP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startTomcatServerLinux() {
        try {
            Cmd.execnoreturn(LINUX_STARTTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startTomcatServerMac() {
        try {
            Cmd.execnoreturn(MAC_STARTTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int stopserver() {
        return Cmd.parsingbuffer(STOPTOMCAT);
    }

    public static void stopserverinapp() {
        try {
            Cmd.execnoreturn(STOPTOMCATINAPP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopTomcatServerLinux() {
        try {
            Cmd.execnoreturn(LINUX_STOPTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopTomcatServerMac() {
        try {
            Cmd.execnoreturn(MAC_STOPTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int registerService() {
        String command = "\"" + TOMCATFILE + "\"" + " install " + "upsTomcat";
        if (Cmd.serverstatus() == 1060) {
            return Cmd.parsingbuffer(command);
        }
        return -1;
    }

    public static int serverstatus() {
        int status = Cmd.parsingbuffer(QUERYSERVER);
        return status;
    }

    public static int serverstatusinapprun() {
        int result;
        block8: {
            result = 1;
            try (SystemTrayUDPClient client = null;){
                try {
                    client = new SystemTrayUDPClient("localhost", 51223);
                    client.send("VP_LINK".getBytes("UTF-8"));
                    String str = client.receiveString();
                    if ("tomcatOK".equals(str)) {
                        result = 4;
                        break block8;
                    }
                    result = 1;
                }
                catch (Exception exception) {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return result;
    }

    public static int rmiportstatus() {
        int result;
        block8: {
            result = 1;
            try (SystemTrayUDPClient client = null;){
                try {
                    client = new SystemTrayUDPClient("localhost", 51222);
                    client.send("VP_LINK".getBytes("UTF-8"));
                    String str = client.receiveString();
                    if ("monitorOK".equals(str)) {
                        result = 4;
                        break block8;
                    }
                    result = 1;
                }
                catch (Exception exception) {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return result;
    }

    public static int serverstatusinappstop() {
        int result;
        block8: {
            result = 1;
            try (SystemTrayUDPClient client = null;){
                try {
                    client = new SystemTrayUDPClient("localhost", 51223);
                    client.send("VP_LINK".getBytes("UTF-8"));
                    String str = client.receiveString();
                    if ("tomcatOK".equals(str)) {
                        result = 4;
                        break block8;
                    }
                    result = 1;
                }
                catch (Exception exception) {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return result;
    }

    private static int parsingbufferinapp(String cmd, String port) {
        Process proc = Cmd.execmd_pro(cmd);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StreamClear clear = new StreamClear(proc.getErrorStream());
        clear.start();
        return Cmd.parsinginapp(bufferedReader, port);
    }

    protected static int parsingbufferinappLinux(String cmd, String port) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
            proc.waitFor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        StreamClear clear = new StreamClear(proc.getErrorStream());
        clear.start();
        return Cmd.parsinginapp(bufferedReader, port);
    }

    public static void execnoreturn(String cmd) throws Exception {
        try {
            Process proc = Cmd.execmd_pro(cmd);
            StreamClear clear = new StreamClear(proc.getErrorStream());
            clear.start();
            StreamClear input = new StreamClear(proc.getInputStream());
            input.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int parsingbuffer(String cmd) {
        BufferedReader bufferedReader = null;
        try {
            Process proc = Cmd.execmd_pro(cmd);
            bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            StreamClear clear = new StreamClear(proc.getErrorStream());
            clear.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return Cmd.parsing(bufferedReader);
    }

    private static int parsinginapp(BufferedReader bufferedReader, String strport) {
        int results = 1;
        try {
            try {
                String readline = bufferedReader.readLine();
                while (readline != null) {
                    String str = "LISTENING";
                    str = MyConstants.IS_OS_WINDOWS ? "LISTENING" : "LISTEN";
                    if (readline.indexOf(str) != -1 && readline.indexOf(strport) != -1) {
                        results = 4;
                        break;
                    }
                    readline = bufferedReader.readLine();
                }
                while ((readline = bufferedReader.readLine()) != null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private static Process execmd_pro(String cmd) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return proc;
    }

    private static int parsing(BufferedReader bufferedReader) {
        String readline = null;
        int result = 0;
        try {
            try {
                while ((readline = bufferedReader.readLine()) != null) {
                    if (readline.indexOf("STATE") != -1) {
                        if (readline.indexOf("RUNNING") != -1) {
                            result = 4;
                            break;
                        }
                        if (readline.indexOf("STOP_PENDING") != -1) {
                            result = 3;
                            break;
                        }
                        if (readline.indexOf("START_PENDING") != -1) {
                            result = 2;
                            break;
                        }
                        if (readline.indexOf("STOPPED") == -1) break;
                        result = 1;
                        break;
                    }
                    if (readline.indexOf("installed") != -1) {
                        result = 5000;
                        break;
                    }
                    if (readline.indexOf("1060") == -1) continue;
                    result = 1060;
                    break;
                }
                while ((readline = bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean isUsed(String port) {
        boolean result = false;
        int re = Cmd.parsingbufferinapp("netstat -a ", port);
        if (re == 4) {
            result = true;
        }
        return result;
    }

    public static boolean isBind(String port) {
        boolean result = true;
        try (DatagramServer udpServer = null;){
            try {
                udpServer = new DatagramServer("0.0.0.0", Integer.parseInt(port));
                result = false;
            }
            catch (Exception e) {
                result = true;
                if (udpServer != null) {
                    udpServer.close();
                }
            }
        }
        return result;
    }

    public static void startDaemon() {
        try {
            int port = 33654;
            Cmd.execnoreturn(String.valueOf(DAEMONSTART) + " " + port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zchangeDaemon(String oldPort, String newPort) {
        try {
            Cmd.execnoreturn(String.valueOf(DAEMONCHANGE) + " " + oldPort + " " + newPort);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void execnoreturnLinux(String cmd) throws Exception {
        try {
            Process proc = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
            proc.waitFor();
            StreamClear clear = new StreamClear(proc.getErrorStream());
            clear.start();
            StreamClear input = new StreamClear(proc.getInputStream());
            input.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopDaemon() {
        try {
            int port = 33654;
            Cmd.execnoreturn(String.valueOf(DAEMONSTOP) + " " + port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Process execmd_cmd(String cmd) throws Exception {
        Process proc = null;
        proc = Runtime.getRuntime().exec(cmd);
        return proc;
    }

    public static boolean modifyAuto() {
        try {
            Cmd.execmd_cmd(AUTOSTART_MONITOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean modifyManually() {
        try {
            Cmd.execmd_cmd(MANUALLYSTART_MONITOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean modifyForbid() {
        try {
            Cmd.execmd_cmd(FORBIDSTART_MONITOR);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            String path = "C:\\Program Files\\ViewPower2.08\\upsMonitor.exe";
            Process pro = Runtime.getRuntime().exec(path);
            StreamClear clear = new StreamClear(pro.getErrorStream());
            clear.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

