/*
 * Decompiled with CFR 0.152.
 */
package usb;

import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.SaveEvent;
import cn.com.voltronicpower.work.ShutdownInterface;
import java.io.File;
import usb.IUSBComm;
import usb.USBComm;

public class USBCommEx
implements IUSBComm,
ShutdownInterface {
    private static final Log logger = new Log();
    private static USBComm usbNative = null;

    static {
        usbNative = new USBComm();
        usbNative.addVidPid(1637, 20833);
        usbNative.addVidPid(11878, 256);
        usbNative.addVidPid(11878, 257);
        usbNative.addVidPid(11878, 258);
        usbNative.addVidPid(11816, 1);
        usbNative.addVidPid(4271, 2);
        usbNative.addVidPid(2478, 12328);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownOS() {
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            this.waitforSolaris();
            if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                USBCommEx.shutdown();
            } else {
                usbNative.poweroffOS();
            }
        }
    }

    public static void shutdown() {
        String password = AES128CBC.decryptWithoutPrivateKey(ConfigDao.qryValue("systempwd"));
        String shutdown = PropertiesUtils.getProperty("Shutdownconfigure.linuxCMD").trim();
        try {
            Runtime rt = Runtime.getRuntime();
            rt.exec("sync");
            Thread.sleep(1000L);
            rt.exec(shutdown);
            Thread.sleep(1000L);
            rt.exec(new String[]{"/bin/sh", "-c", "echo " + password + " | sudo -S " + shutdown});
            Thread.sleep(1000L);
            rt.exec("su root");
            rt.exec("echo " + password);
            Thread.sleep(1000L);
            rt.exec(String.valueOf(System.getProperty("user.dir")) + File.separator + "shutdown " + password);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        USBCommEx usb = new USBCommEx();
        String dd = usb.findUSBDevices();
        System.out.println("-------dd----------:" + dd);
        String[] usbs = dd.split("#");
        System.out.println(dd);
        String[] stringArray = usbs;
        int n = usbs.length;
        int n2 = 0;
        while (n2 < n) {
            String usbname = stringArray[n2];
            String qs = "QPI\r";
            String value = usb.sendCommand(usbname, qs);
            System.out.println("value=" + value);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findUSBDevices() {
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            this.waitforSolaris();
            return usbNative.findAllUSBs();
        }
    }

    @Override
    public void beep(int time) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeUSBPort(String usbID) {
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            this.waitforSolaris();
            usbNative.closeUSBPort(usbID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendCommand(String usbID, String command) {
        usbNative.setUseCRC(0);
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            StringBuilder sb = new StringBuilder();
            boolean bflag = false;
            String res = "";
            byte[] bytes = usbNative.sendCommand(usbID, command);
            int i = 0;
            while (i < bytes.length) {
                byte ch = bytes[i];
                if (ch == 13) {
                    bflag = true;
                    break;
                }
                if (ch < 0) {
                    sb.append((char)(ch & 0xFF));
                } else {
                    sb.append((char)ch);
                }
                ++i;
            }
            String xx = sb.toString();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (bflag) {
                res = xx;
            }
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("usbID:" + usbID + " Command=" + command + " ret=" + res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendCommand(String usbID, String command, boolean useCRC) {
        usbNative.setUseCRC(useCRC ? 1 : 0);
        String res = "";
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            StringBuilder sb = new StringBuilder();
            boolean bflag = false;
            byte[] bytes = usbNative.sendCommand(usbID, command);
            int i = 0;
            while (i < bytes.length) {
                byte ch = bytes[i];
                if (ch == 13) {
                    bflag = true;
                    break;
                }
                if (ch < 0) {
                    sb.append((char)(ch & 0xFF));
                } else {
                    sb.append((char)ch);
                }
                ++i;
            }
            if (bflag) {
                res = sb.toString();
            }
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("usbID:" + usbID + " Command=" + command + " ret=" + res);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void suspendOS() {
        USBComm uSBComm = usbNative;
        synchronized (uSBComm) {
            this.waitforSolaris();
            usbNative.suspendOS();
        }
    }

    private void waitforSolaris() {
        if (MyConstants.IS_OS_SOLARIS) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

