/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.data.bean.PowerPlan;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.TestPlan;
import cn.com.voltronicpower.data.dao.BatteryTestPlanDao;
import cn.com.voltronicpower.data.dao.PowerPlanDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.processor.P00Processor;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import cn.com.voltronicpower.work.SystemShutdown;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class UpsScheduler
extends Thread {
    private static final Log logger = new Log();
    protected static final String ACK = "(ACK";
    protected static final String NAK = "(NAK";
    private static final long INTEVAL_MILLIS = 10000L;
    private static long lastWarnTime;

    @Override
    public void run() {
        int count = 0;
        while (!SystemEnv.stopping) {
            try {
                if (count != 0) {
                    UpsScheduler.sleep(1000L);
                } else {
                    try {
                        this.excutePowerControlPlan();
                    }
                    catch (Exception e) {
                        logger.error("run power control plan error" + e.getMessage());
                    }
                    try {
                        this.excuteBatteryTest();
                    }
                    catch (Exception e) {
                        logger.error("run battery test plan error");
                    }
                }
                if (++count < 10) continue;
                count = 0;
            }
            catch (InterruptedException e) {
                logger.error("run scheduler error");
            }
        }
        ++SystemEnv.stoped;
    }

    private void excutePowerControlPlan() {
        PowerPlanDao planDao = new PowerPlanDao();
        ArrayList<PowerPlan> plans = planDao.getPowerPlans();
        for (PowerPlan plan : plans) {
            if (plan.getCycle().equals("once")) {
                this.oncePlanCtrl(plan);
                continue;
            }
            if (plan.getCycle().equals("daily")) {
                this.dailyPlanCtrl(plan);
                continue;
            }
            if (plan.getCycle().equals("weekly")) {
                this.weeklyPlanCtrl(plan);
                continue;
            }
            plan.getCycle().equals("monthly");
        }
    }

    private void excuteBatteryTest() {
        BatteryTestPlanDao planDao = new BatteryTestPlanDao();
        ArrayList<TestPlan> plans = planDao.getBatteryTestPlans();
        for (TestPlan plan : plans) {
            if (plan.getCycle().equals("once")) {
                this.onceTestCtrl(plan);
                continue;
            }
            if (plan.getCycle().equals("daily")) {
                this.dailyTestCtrl(plan);
                continue;
            }
            if (plan.getCycle().equals("weekly")) {
                this.weeklyTestCtrl(plan);
                continue;
            }
            if (!plan.getCycle().equals("monthly")) continue;
            this.monthlyTestCtrl(plan);
        }
    }

    private void oncePlanCtrl(PowerPlan plan) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        Date offDate = this.combinDate(plan.getOffDate(), plan.getOffTime());
        if (shutdown.isPlanShutdown()) {
            long inteval = offDate.getTime() - shutdown.getShutdownTimeMillis() - System.currentTimeMillis();
            if (!"ATMUSE".equalsIgnoreCase(MyConstants.Customized)) {
                this.shutdownWarning(inteval);
            }
            this.execFile(shutdown, inteval);
            if (inteval > 0L && inteval < 10000L) {
                this.oncePowerOff(plan, offDate, true);
            }
        } else {
            long inteval = offDate.getTime() - System.currentTimeMillis();
            if (inteval > 0L && inteval < 10000L) {
                this.oncePowerOff(plan, offDate, false);
            }
        }
    }

    private void oncePowerOff(PowerPlan plan, Date offDate, boolean isShutdown) {
        String[] ports;
        Date onDate = this.combinDate(plan.getOnDate(), plan.getOnTime());
        int minutes = (int)((onDate.getTime() - offDate.getTime()) / 60000L);
        String[] stringArray = ports = plan.getPorts().split(" ");
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            try {
                MonitorProcessor processer = this.getProcesser(port);
                if (processer != null) {
                    String ptid = processer.getProtocol().getProtocolID();
                    EventsHandler.handleEvent(port, "6005", ptid, processer.getDeviceId(), false);
                    this.doPlan(processer, isShutdown, minutes);
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            ++n2;
        }
    }

    private void shutdownWarning(long leftSeconds) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        if (leftSeconds > 0L && leftSeconds < (long)(shutdown.getBeforeAlertTime() * 1000) && System.currentTimeMillis() - lastWarnTime > (long)(shutdown.getAlertIntervalTime() * 1000)) {
            lastWarnTime = System.currentTimeMillis();
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            String type = null;
            String name = null;
            leftSeconds /= 1000L;
            if (config.getLanguage().equals("zh_CN")) {
                type = "\u7cfb\u7edf\u5173\u673a\u4fe1\u606f";
                name = shutdown.isShutdownMode() ? "\u7cfb\u7edf\u5c06\u5728" + leftSeconds + "\u79d2\u540e\u5173\u95ed" : "\u7cfb\u7edf\u5c06\u5728" + leftSeconds + "\u79d2\u540e\u4f11\u7720";
            } else {
                type = "System Shutdown Infomation";
                name = shutdown.isShutdownMode() ? "System shutdown after " + leftSeconds + " seconds" : "System sleep after " + leftSeconds + " seconds";
            }
            EventsHandler.trayClient(type, null, name, "000");
        }
    }

    private Date combinDate(Date dayDate, Date timeDate) {
        Calendar dayCa = Calendar.getInstance();
        dayCa.setTime(dayDate);
        Calendar timeCa = Calendar.getInstance();
        timeCa.setTime(timeDate);
        timeCa.set(dayCa.get(1), dayCa.get(2), dayCa.get(5));
        return timeCa.getTime();
    }

    private void execFile(Shutdownconfigure shutdown, long inteval) {
        long intevalExec;
        String executeFile = shutdown.getExcuteProgram();
        if (MyConstants.IS_OS_WINDOWS) {
            executeFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "slientbat.exe " + executeFile;
        }
        if (shutdown.getExcuteProgram() != null && !shutdown.getExcuteProgram().equals("") && (intevalExec = inteval - shutdown.getExcuteProgramTimeMillis()) > 0L && intevalExec < 10000L) {
            try {
                Runtime.getRuntime().exec(executeFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void dailyPlanCtrl(PowerPlan plan) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        Date offDate = this.combinDate(new Date(), plan.getOffTime());
        if (shutdown.isPlanShutdown()) {
            long inteval = offDate.getTime() - shutdown.getShutdownTimeMillis() - System.currentTimeMillis();
            if (!"ATMUSE".equalsIgnoreCase(MyConstants.Customized)) {
                this.shutdownWarning(inteval);
            }
            this.execFile(shutdown, inteval);
            if (inteval > 0L && inteval < 10000L) {
                this.dailyPowerOff(plan, offDate, true);
            }
        } else {
            long inteval = offDate.getTime() - System.currentTimeMillis();
            if (inteval > 0L && inteval < 10000L) {
                this.dailyPowerOff(plan, offDate, false);
            }
        }
    }

    private void dailyPowerOff(PowerPlan plan, Date offDate, boolean isShutdown) {
        String[] ports;
        Date onDate = this.combinDate(new Date(), plan.getOnTime());
        if (onDate.getTime() <= offDate.getTime()) {
            Calendar ca = Calendar.getInstance();
            ca.add(6, 1);
            onDate = this.combinDate(ca.getTime(), plan.getOnTime());
        }
        int minutes = (int)((onDate.getTime() - offDate.getTime()) / 60000L);
        String[] stringArray = ports = plan.getPorts().split(" ");
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            try {
                MonitorProcessor processer = this.getProcesser(port);
                if (processer != null) {
                    String ptid = processer.getProtocol().getProtocolID();
                    EventsHandler.handleEvent(port, "6006", ptid, processer.getDeviceId(), false);
                    this.doPlan(processer, isShutdown, minutes);
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            ++n2;
        }
    }

    private void weeklyPlanCtrl(PowerPlan plan) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        Calendar ca = Calendar.getInstance();
        if (plan.getOffWeek() != ca.get(7)) {
            return;
        }
        Date offDate = this.combinDate(new Date(), plan.getOffTime());
        if (shutdown.isPlanShutdown()) {
            long inteval = offDate.getTime() - shutdown.getShutdownTimeMillis() - System.currentTimeMillis();
            if (!"ATMUSE".equalsIgnoreCase(MyConstants.Customized)) {
                this.shutdownWarning(inteval);
            }
            this.execFile(shutdown, inteval);
            if (inteval > 0L && inteval < 10000L) {
                this.weeklyPowerOff(plan, ca, offDate, true);
            }
        } else {
            long inteval = offDate.getTime() - System.currentTimeMillis();
            if (inteval > 0L && inteval < 10000L) {
                this.weeklyPowerOff(plan, ca, offDate, false);
            }
        }
    }

    private void weeklyPowerOff(PowerPlan plan, Calendar ca, Date offDate, boolean isShutdown) {
        String[] ports;
        if (plan.getOnWeek() == plan.getOffWeek()) {
            if (plan.getOnTime().getTime() <= plan.getOffTime().getTime()) {
                ca.add(3, 1);
            }
        } else if (plan.getOnWeek() < plan.getOffWeek()) {
            ca.add(3, 1);
            ca.add(7, (plan.getOffWeek() - plan.getOnWeek()) * -1);
        } else if (plan.getOnWeek() > plan.getOffWeek()) {
            ca.add(7, plan.getOnWeek() - plan.getOffWeek());
        }
        Date onDate = this.combinDate(ca.getTime(), plan.getOnTime());
        int minutes = (int)((onDate.getTime() - offDate.getTime()) / 60000L);
        String[] stringArray = ports = plan.getPorts().split(" ");
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            try {
                MonitorProcessor processer = this.getProcesser(port);
                if (processer != null) {
                    String ptid = processer.getProtocol().getProtocolID();
                    EventsHandler.handleEvent(port, "6007", ptid, processer.getDeviceId(), false);
                    this.doPlan(processer, isShutdown, minutes);
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            ++n2;
        }
    }

    private void monthlyPlanCtrl(PowerPlan plan) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        Calendar ca = Calendar.getInstance();
        if (plan.getOffMonth() != ca.get(5)) {
            return;
        }
        Date offDate = this.combinDate(new Date(), plan.getOffTime());
        if (shutdown.isPlanShutdown()) {
            long inteval = offDate.getTime() - shutdown.getShutdownTimeMillis() - System.currentTimeMillis();
            if (!"ATMUSE".equalsIgnoreCase(MyConstants.Customized)) {
                this.shutdownWarning(inteval);
            }
            this.execFile(shutdown, inteval);
            if (inteval > 0L && inteval < 10000L) {
                this.monthPowerOff(plan, ca, offDate, true);
            }
        } else {
            long inteval = offDate.getTime() - System.currentTimeMillis();
            if (inteval > 0L && inteval < 10000L) {
                this.monthPowerOff(plan, ca, offDate, false);
            }
        }
    }

    private void monthPowerOff(PowerPlan plan, Calendar ca, Date offDate, boolean isShutdown) {
        String[] ports;
        ca.set(5, plan.getOnMonth());
        Date onDate = this.combinDate(ca.getTime(), plan.getOnTime());
        int minutes = (int)((onDate.getTime() - offDate.getTime()) / 60000L);
        String[] stringArray = ports = plan.getPorts().split(" ");
        int n = ports.length;
        int n2 = 0;
        while (n2 < n) {
            String port = stringArray[n2];
            try {
                MonitorProcessor processer = this.getProcesser(port);
                if (processer != null) {
                    String ptid = processer.getProtocol().getProtocolID();
                    EventsHandler.handleEvent(port, "6008", ptid, processer.getDeviceId(), false);
                    this.doPlan(processer, isShutdown, minutes);
                }
            }
            catch (Exception e) {
                logger.error(e.toString());
            }
            ++n2;
        }
    }

    public void doPlan(MonitorProcessor processer, boolean isShutdown, int minutes) throws Exception {
        if (isShutdown) {
            processer.offSwitchCtrl(minutes);
            SystemShutdown.shutdown(processer.getDeviceName(), processer.getProtocol().getProtocolID(), processer.getDeviceId());
        } else {
            processer.offSwitchCtrlOntime(minutes);
        }
    }

    private void onceTestCtrl(TestPlan plan) {
        Date testDate = this.combinDate(plan.getPlanDate(), plan.getPlanTime());
        long inteval = testDate.getTime() - System.currentTimeMillis();
        if (inteval > 0L && inteval < 10000L) {
            this.testOperation(plan);
        }
    }

    private void dailyTestCtrl(TestPlan plan) {
        Date testDate = this.combinDate(new Date(), plan.getPlanTime());
        long inteval = testDate.getTime() - System.currentTimeMillis();
        if (inteval > 0L && inteval < 10000L) {
            this.testOperation(plan);
        }
    }

    public static void main(String[] args) {
        Calendar ca = Calendar.getInstance();
    }

    private void weeklyTestCtrl(TestPlan plan) {
        Date testDate;
        long inteval;
        Calendar ca = Calendar.getInstance();
        if (plan.getPlanWeek() == ca.get(7) - 1 && (inteval = (testDate = this.combinDate(ca.getTime(), plan.getPlanTime())).getTime() - System.currentTimeMillis()) > 0L && inteval < 10000L) {
            this.testOperation(plan);
        }
    }

    private void monthlyTestCtrl(TestPlan plan) {
        Date testDate;
        long inteval;
        Calendar ca = Calendar.getInstance();
        if (plan.getPlanMonth() == ca.get(5) && (inteval = (testDate = this.combinDate(ca.getTime(), plan.getPlanTime())).getTime() - System.currentTimeMillis()) > 0L && inteval < 10000L) {
            this.testOperation(plan);
        }
    }

    private MonitorProcessor getProcesser(String port) {
        MonitorProcessor processer = null;
        if (Config.getBoolean("showLocalUPS")) {
            processer = CommConnector.getInstance().getCommProcesser(port);
        }
        return processer;
    }

    private void testOperation(TestPlan plan) {
        block18: {
            String[] ports;
            block19: {
                block17: {
                    ports = plan.getPorts().split(" ");
                    if (!plan.getOperation().equals("seconds")) break block17;
                    String[] stringArray = ports;
                    int n = ports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String port = stringArray[n2];
                        MonitorProcessor processer = this.getProcesser(port);
                        if (this.isCouldExcuteBatteryTest(processer)) {
                            String ret = "";
                            try {
                                ret = processer.tenSencondsBatteryTestCtrl();
                                this.recordBatteryTestEvent(port, processer.getProtocol().getProtocolID(), plan.getCycle(), processer.getDeviceId());
                                if (!ret.equals(ACK)) {
                                    EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                                }
                            }
                            catch (Exception e) {
                                EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                            }
                        }
                        ++n2;
                    }
                    break block18;
                }
                if (!plan.getOperation().equals("minutes")) break block19;
                String[] stringArray = ports;
                int n = ports.length;
                int n3 = 0;
                while (n3 < n) {
                    String port = stringArray[n3];
                    MonitorProcessor processer = this.getProcesser(port);
                    if (this.isCouldExcuteBatteryTest(processer)) {
                        String ret = "";
                        try {
                            ret = processer.munitesBatteryTestCtrl(plan.getDelayMinute());
                            this.recordBatteryTestEvent(port, processer.getProtocol().getProtocolID(), plan.getCycle(), processer.getDeviceId());
                            if (!ret.equals(ACK)) {
                                EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                            }
                        }
                        catch (Exception e) {
                            EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                        }
                    }
                    ++n3;
                }
                break block18;
            }
            if (!plan.getOperation().equals("deep")) break block18;
            String[] stringArray = ports;
            int n = ports.length;
            int n4 = 0;
            while (n4 < n) {
                String port = stringArray[n4];
                MonitorProcessor processer = this.getProcesser(port);
                if (this.isCouldExcuteBatteryTest(processer)) {
                    String ret = "";
                    try {
                        if (processer instanceof P00Processor) {
                            ret = ((P00Processor)processer).testOperationP00();
                            this.recordBatteryTestEvent(port, processer.getProtocol().getProtocolID(), plan.getCycle(), processer.getDeviceId());
                            if (!ret.equals(ACK)) {
                                EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                            }
                        } else {
                            processer.testOperation();
                            this.recordBatteryTestEvent(port, processer.getProtocol().getProtocolID(), plan.getCycle(), processer.getDeviceId());
                        }
                    }
                    catch (Exception e) {
                        EventsHandler.handleEvent(port, "4002", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                    }
                }
                ++n4;
            }
        }
    }

    private final boolean isCouldExcuteBatteryTest(MonitorProcessor processer) {
        if (processer != null) {
            return processer.getProtocol().isCouldExcuteBatteryTest(processer.getWorkInfo());
        }
        return false;
    }

    private final void recordBatteryTestEvent(String portName, String ptid, String planCycle, String sn) {
        if (planCycle.equals("once")) {
            EventsHandler.handleEvent(portName, "4009", ptid, sn, false);
            BatteryTestEndHandler.putBatteryTestEvent("4009");
        } else if (planCycle.equals("daily")) {
            EventsHandler.handleEvent(portName, "4009", ptid, sn, false);
            BatteryTestEndHandler.putBatteryTestEvent("4009");
        } else if (planCycle.equals("weekly")) {
            EventsHandler.handleEvent(portName, "4009", ptid, sn, false);
            BatteryTestEndHandler.putBatteryTestEvent("4009");
        } else if (planCycle.equals("monthly")) {
            EventsHandler.handleEvent(portName, "4009", ptid, sn, false);
            BatteryTestEndHandler.putBatteryTestEvent("4009");
        }
    }
}

