/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.tomcat.Cmd;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.work.ShutdownInterface;
import java.awt.Toolkit;
import java.io.IOException;

public class SystemShutdown {
    private static final Log logger = new Log();
    private static long lastExcuteTime;
    private static ShutdownInterface _shutdownObj;

    static {
        _shutdownObj = null;
    }

    public static void setShutdownObj(ShutdownInterface shutdownObj) {
        _shutdownObj = shutdownObj;
    }

    public static ShutdownInterface getShutdownObj() {
        return _shutdownObj;
    }

    public static void shutdown(String portName, String ptid, String sn) {
        Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
        if (System.currentTimeMillis() - lastExcuteTime <= 60000L) {
            return;
        }
        if (_shutdownObj == null) {
            return;
        }
        lastExcuteTime = System.currentTimeMillis();
        if (shutdown.isShutdownMode()) {
            EventsHandler.handleEvent(portName, "7001", ptid, sn, MyConstants.IS_OS_MAC);
            if (MyConstants.IS_OS_LINUX || MyConstants.IS_OS_SOLARIS) {
                Cmd.stopTomcatServerLinux();
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            _shutdownObj.shutdownOS();
        } else {
            EventsHandler.handleEvent(portName, "7002", ptid, sn, MyConstants.IS_OS_MAC);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            _shutdownObj.suspendOS();
        }
        CommConnector.getInstance().closeAllProcessers();
    }

    public static void cancelShutdown() {
        block2: {
            if (!MyConstants.IS_OS_WINDOWS) break block2;
            try {
                Runtime.getRuntime().exec("cmd start call shutdown -a");
            }
            catch (IOException e) {
                System.out.println("\u6267\u884c\u5931\u8d25");
            }
        }
    }

    public static void main(String[] args) {
        Toolkit.getDefaultToolkit().beep();
    }
}

