/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiclass.SearchService;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.UpsTree;
import org.dom4j.Element;

public class SearchUPSThread
extends Thread {
    private static final Log logger = new Log();
    private String ipAddr1;
    private String ipAddr2;

    public SearchUPSThread(String addr1, String addr2) {
        this.ipAddr1 = addr1;
        this.ipAddr2 = addr2;
    }

    @Override
    public void run() {
        SystemEnv.refreshSearchingUPS = true;
        try {
            String[] ipaddr1List = this.ipAddr1.split("\\.");
            String[] ipaddr2List = this.ipAddr2.split("\\.");
            String ipTemp = String.valueOf(ipaddr1List[0]) + "." + ipaddr1List[1] + "." + ipaddr1List[2] + ".";
            if (ipaddr1List.length == 4 || ipaddr2List.length == 4) {
                int start = Integer.parseInt(ipaddr1List[3]);
                int end = Integer.parseInt(ipaddr2List[3]);
                int temp = start;
                while (temp <= end) {
                    SearchService service;
                    Element computerEle;
                    String ip = String.valueOf(ipTemp) + temp;
                    if (!SystemEnv.getLocalHostAddress().equals(ip) && (computerEle = (service = new SearchService()).searchRemoteUps(ip)) != null) {
                        UpsTree.getInstance().putComputer(computerEle, "INTERNET");
                    }
                    ++temp;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SystemEnv.refreshSearchingUPS = false;
        SystemEnv.refreshSearchUPSTree = MyConstants.getRefreshTree();
    }
}

