/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.RemoteShutdown;
import cn.com.voltronicpower.data.bean.SSHInfo;
import cn.com.voltronicpower.data.dao.SSHInfoDao;
import cn.com.voltronicpower.monitorcommunicate.UdpClient;
import cn.com.voltronicpower.utilities.ExcuteSSH;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.TCPShutdownClient;
import cn.com.voltronicpower.work.RemoteShutdownThread;
import cn.com.voltronicpower.work.RemoteShutdownThreadPool;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

public class RemoteShutdownProcesser {
    private static long lastSendTime;
    private static final Log logger;

    static {
        logger = new Log();
    }

    public void sendRemoteShutdownMsg() {
        if (System.currentTimeMillis() - lastSendTime <= 60000L) {
            return;
        }
        RemoteShutdown shutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(shutdown);
        boolean parallel = shutdown.isParallel();
        RemoteShutdownThreadPool pool = null;
        if (parallel) {
            pool = new RemoteShutdownThreadPool();
            pool.initPool();
        }
        if (shutdown.isBatteryMode() || shutdown.isBatteryLowLevel()) {
            SSHInfoDao dao = new SSHInfoDao();
            List<SSHInfo> infos = dao.getSSHInfos();
            for (SSHInfo info : infos) {
                String ipAddr = info.getIp();
                String user = info.getUser();
                String password = info.getPassword();
                String command = info.getCommand();
                String port = info.getPort();
                boolean sshmode = info.isSshMode();
                if (sshmode) {
                    this.excuteSSHCmd(ipAddr, user, password, command, port);
                    continue;
                }
                this.sendShutdownUDP(ipAddr, pool);
            }
        }
        lastSendTime = System.currentTimeMillis();
    }

    public void sendLowLevelRemoteShutdownMsg() {
        if (System.currentTimeMillis() - lastSendTime <= 60000L) {
            return;
        }
        RemoteShutdown shutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(shutdown);
        if (shutdown.isBatteryLowLevel() || shutdown.isBatteryLowLevel()) {
            SSHInfoDao dao = new SSHInfoDao();
            List<SSHInfo> infos = dao.getSSHInfos();
            boolean parallel = shutdown.isParallel();
            RemoteShutdownThreadPool pool = null;
            if (parallel) {
                pool = new RemoteShutdownThreadPool();
                pool.initPool();
            }
            for (SSHInfo info : infos) {
                String ipAddr = info.getIp();
                String user = info.getUser();
                String password = info.getPassword();
                String command = info.getCommand();
                String port = info.getPort();
                boolean sshmode = info.isSshMode();
                if (sshmode) {
                    this.excuteSSHCmd(ipAddr, user, password, command, port);
                    continue;
                }
                this.sendShutdownUDP(ipAddr, pool);
            }
        }
        lastSendTime = System.currentTimeMillis();
    }

    public void excuteSSHCmd(String ipAddr, String user, String password, String sshcommand, String sshPort) {
        if ("root".equals(user)) {
            if (!sshcommand.equals("")) {
                String[] command = new String[]{sshcommand};
                if (sshPort.equals("")) {
                    sshPort = "22";
                }
                new ExcuteSSH(ipAddr, Integer.parseInt(sshPort), user, password).executeCommands(command);
            } else {
                String[] command = new String[]{"halt"};
                new ExcuteSSH(ipAddr, 22, user, password).executeCommands(command);
            }
        } else {
            String cmd = "sudo halt";
            String port = "22";
            if (!sshcommand.equals("")) {
                cmd = "sudo " + sshcommand;
            }
            if (!port.equals("")) {
                port = sshPort;
            }
            String[] command = new String[]{cmd, password};
            new ExcuteSSH(ipAddr, Integer.parseInt(port), user, password).executeCommands(command);
        }
    }

    public void sendRemoteBatCapShutdownMsg() {
        if (System.currentTimeMillis() - lastSendTime <= 60000L) {
            return;
        }
        RemoteShutdown shutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(shutdown);
        if (shutdown.isBatCapRemoteShutdown()) {
            this.handleSSHShutdown();
        }
        lastSendTime = System.currentTimeMillis();
    }

    public void sendOverTempRemoteShutdownMsg() {
        if (System.currentTimeMillis() - lastSendTime <= 60000L) {
            return;
        }
        RemoteShutdown shutdown = new RemoteShutdown();
        PropertiesUtils.wrapProperties(shutdown);
        if (shutdown.isOverTemperatureRemoteShutdown()) {
            this.handleSSHShutdown();
        }
        lastSendTime = System.currentTimeMillis();
    }

    private void handleSSHShutdown() {
        SSHInfoDao dao = new SSHInfoDao();
        List<SSHInfo> infos = dao.getSSHInfos();
        for (SSHInfo info : infos) {
            String ipAddr = info.getIp();
            String user = info.getUser();
            String password = info.getPassword();
            String command = info.getCommand();
            String port = info.getPort();
            boolean sshmode = info.isSshMode();
            if (sshmode) {
                this.excuteSSHCmd(ipAddr, user, password, command, port);
                continue;
            }
            this.sendShutdownUDP(ipAddr, null);
        }
    }

    public void sendShutdownUDP(String ipAddr, RemoteShutdownThreadPool pool) {
        if (SystemEnv.useTCPShutdown) {
            String cmd = "shutdown##true";
            TCPShutdownClient tcp = new TCPShutdownClient(ipAddr, Integer.parseInt("31234"), cmd);
            if (pool != null) {
                RemoteShutdownThread remoteThread = new RemoteShutdownThread(tcp);
                pool.addThread(remoteThread);
                return;
            }
            int times = 0;
            String rtnstr = "";
            boolean startOK = false;
            do {
                rtnstr = tcp.sendAndReceived();
                try {
                    startOK = rtnstr.startsWith("OK");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } while (++times < 3 && !startOK);
        } else {
            UdpClient udp = null;
            try {
                try {
                    udp = new UdpClient(ipAddr);
                    udp.setPort("31234");
                    udp.send("shutdown#" + this.getAllLocalIPAddress());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (udp != null) {
                        udp.disconnect();
                    }
                }
            }
            finally {
                if (udp != null) {
                    udp.disconnect();
                }
            }
        }
    }

    public static void main(String[] args) {
        new RemoteShutdownProcesser().excuteSSHCmd("192.168.160.83", "root", "1234qwer.", "poweroff", "22");
    }

    private String getAllLocalIPAddress() {
        String ips = "";
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    ips = String.valueOf(ips) + ip.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ips;
    }
}

