/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.WorkDataDao;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.util.Collection;
import java.util.Date;

public class DataRecordThread
extends Thread {
    @Override
    public void run() {
        int count = 0;
        while (!SystemEnv.stopping) {
            try {
                int intevalTime = PropertiesUtils.getGlobalConfig().getDataRecordInterval();
                if (intevalTime == 0) {
                    intevalTime = 60;
                }
                if (count != 0) {
                    DataRecordThread.sleep(1000L);
                } else {
                    this.Recordhandler();
                }
                if (++count < intevalTime) continue;
                count = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++SystemEnv.stoped;
    }

    public void Recordhandler() {
        try {
            Collection<MonitorProcessor> processers = null;
            if (Config.getBoolean("showLocalUPS")) {
                processers = CommConnector.getInstance().getProcessers();
                Date date = new Date();
                for (MonitorProcessor processer : processers) {
                    WorkDataDao workDataDao = new WorkDataDao();
                    WorkInfo workInfo = processer.getWorkInfo();
                    if (workInfo.getPtid() == null || "".equals(workInfo.getPtid()) || processer.getDeviceName() == null || "".equals(processer.getDeviceName())) continue;
                    workInfo.setCurrentTime(date);
                    workDataDao.addWorkData(workInfo, processer.getDeviceName());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

