/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.work;

import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.dao.BatteryWarnDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class BatteryWarnHandler
extends Thread {
    @Override
    public void run() {
        int count = 0;
        int intevalTime = PropertiesUtils.getGlobalConfig().getBatteryWarnInterval() * 3600;
        if (intevalTime == 0) {
            intevalTime = 1;
        }
        while (!SystemEnv.stopping) {
            try {
                if (count == 0) {
                    this.excuteBatteryWarn();
                } else {
                    BatteryWarnHandler.sleep(1000L);
                }
                if (++count < intevalTime) continue;
                count = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ++SystemEnv.stoped;
    }

    public void excuteBatteryWarn() {
        BatteryWarnDao dao = new BatteryWarnDao();
        List<BuyInfo> list = dao.getBattery();
        for (BuyInfo info : list) {
            if (info.getBatteryLifetime() <= 0 || !info.isUsePrompt()) continue;
            Date buydate = info.getBatteryBuyDate();
            Calendar ca = Calendar.getInstance();
            ca.setTime(buydate);
            ca.add(2, info.getBatteryLifetime());
            if (!ca.getTime().before(new Date())) continue;
            this.doWarn(info);
        }
    }

    public void doWarn(BuyInfo info) {
        EventsHandler.batteryWarnEvent(info);
    }
}

