/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.UpsInfo;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class UpsTree {
    private static UpsTree upsTree = new UpsTree();
    private Document upsTreeDoc;
    private Map<String, UpsInfo> networkUps = new HashMap<String, UpsInfo>();
    private Set<String> computerAddrs = new HashSet<String>();

    private UpsTree() {
        this.upsTreeDoc = DocumentHelper.createDocument();
        Element root = this.upsTreeDoc.addElement("root");
        if (Config.getBoolean("showLocalUPS")) {
            root.addElement("node").addAttribute("label", "CURRENT").addAttribute("bool", "lan");
            root.addElement("node").addAttribute("label", "LAN").addAttribute("bool", "lan");
            if (!MyConstants.Customized.equals("ABB")) {
                root.addElement("node").addAttribute("label", "INTERNET").addAttribute("bool", "lan");
            }
        }
    }

    private synchronized void refreshLocalPort() {
        Element localEle = (Element)this.upsTreeDoc.selectSingleNode("//node[@label='CURRENT']");
        Iterator iter = localEle.elementIterator();
        while (iter.hasNext()) {
            localEle.remove((Element)iter.next());
        }
        Element localHostEle = localEle.addElement("node").addAttribute("label", SystemEnv.getLocalHostName()).addAttribute("bool", "computer");
        Map<String, MonitorProcessor> upsMaps = CommConnector.getInstance().getProcesserMap();
        for (MonitorProcessor processer : upsMaps.values()) {
            localHostEle.addElement("node").addAttribute("label", String.valueOf(processer.getDeviceName()) + "_" + processer.getProtocol().getProtocolID()).addAttribute("bool", "port");
        }
    }

    public static UpsTree getInstance() {
        return upsTree;
    }

    public Document getUpsTreeDoc() throws UnknownHostException {
        if (Config.getBoolean("showLocalUPS")) {
            this.refreshLocalPort();
        }
        return this.upsTreeDoc;
    }

    public UpsInfo getNetworkUps(String computerLabel, String portName) {
        return this.networkUps.get(String.valueOf(computerLabel) + "-" + portName);
    }

    public synchronized void putComputer(Element computerEle, String networkType) {
        String ipAddr = computerEle.attributeValue("label");
        if (!SystemEnv.getLocalHostAddress().equals(ipAddr)) {
            List portEles = computerEle.elements("node");
            for (Element portEle : portEles) {
                UpsInfo upsInfo = CommConnector.getInstance().conventElement(portEle);
                String portName = portEle.attributeValue("label");
                this.networkUps.put(String.valueOf(ipAddr) + "-" + portName.substring(0, portName.indexOf("_")), upsInfo);
            }
            Element networkEle = (Element)this.upsTreeDoc.selectSingleNode("//node[@label='" + networkType + "']");
            List computEles = networkEle.elements("node");
            for (Element ele : computEles) {
                String addr = ele.attributeValue("label");
                if (!ipAddr.equals(addr)) continue;
                networkEle.remove(ele);
            }
            networkEle.add(computerEle);
            this.computerAddrs.add(ipAddr);
        }
    }

    public void removeNetworkUps(String networkType) {
        Element networkEle = (Element)this.upsTreeDoc.selectSingleNode("//node[@label='" + networkType + "']");
        List computerEles = networkEle.elements("node");
        for (Element ele : computerEles) {
            networkEle.remove(ele);
        }
    }

    public Set<String> getComputerAddrs() {
        return this.computerAddrs;
    }

    public static void main(String[] args) {
        try {
            InetAddress ip = InetAddress.getByAddress(new byte[]{-64, -88, 104, 103});
            System.out.println("ip:" + ip.getHostName());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }
}

