/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class TCPShutdownClient {
    public static String REQUEST_PRIVATE_KEY = "Please send me the private key,thanks !";
    protected String ipAddress;
    protected int port;
    protected String msg;
    private static final Log logger = new Log();

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public TCPShutdownClient(String ipaddr, int port, String msg) {
        this.ipAddress = ipaddr;
        this.port = port;
        this.msg = msg;
    }

    public void run() {
        int times = 0;
        String rtnstr = "";
        boolean startOK = false;
        do {
            rtnstr = this.sendAndReceived();
            try {
                startOK = rtnstr.startsWith("OK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } while (++times < 3 && !startOK);
    }

    public String sendAndReceived() {
        byte[] result = null;
        Socket socket = null;
        InputStream input = null;
        OutputStream output = null;
        byte[] recbuf = new byte[1024];
        try {
            try {
                int len = 0;
                socket = new Socket(this.ipAddress, this.port);
                input = socket.getInputStream();
                output = socket.getOutputStream();
                byte[] senddata = AES128CBC.encryptAndGenerateIV(AES128CBC.getPublicKey(), REQUEST_PRIVATE_KEY);
                output.write(senddata, 0, senddata.length);
                output.flush();
                len = input.read(recbuf);
                byte[] receivedata = null;
                if (len > 0) {
                    receivedata = new byte[len];
                    System.arraycopy(recbuf, 0, receivedata, 0, len);
                }
                if (receivedata != null) {
                    byte[] privatekey = AES128CBC.descryptWithIV(AES128CBC.getPublicKey(), receivedata);
                    System.out.println("2=" + new String(privatekey));
                    if (privatekey != null) {
                        senddata = AES128CBC.encryptAndGenerateIV(privatekey, this.msg);
                        output.write(senddata);
                        output.flush();
                        len = input.read(recbuf);
                        receivedata = null;
                        if (len > 0) {
                            receivedata = new byte[len];
                            System.arraycopy(recbuf, 0, receivedata, 0, len);
                            System.out.println("3=" + new String(receivedata));
                            result = AES128CBC.descryptWithIV(privatekey, receivedata);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        if (result != null) {
            System.out.println("4=" + new String(result));
            return new String(result);
        }
        return null;
    }

    public static void main(String[] args) {
        String cmd = "shutdown##true";
        TCPShutdownClient tcp = new TCPShutdownClient("192.168.160.59", 31234, cmd);
        tcp.sendAndReceived();
    }
}

