/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.data.bean.EletricEvent;
import cn.com.voltronicpower.data.bean.EmailInfo;
import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.data.bean.SmsInfo;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.mail.EmailSendUtil;
import cn.com.voltronicpower.mail.EmailUtil;
import cn.com.voltronicpower.modem.ModemAdapter;
import cn.com.voltronicpower.modem.SendSMSByHttp;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SendEventsUtil
extends Thread {
    private static final Log logger = new Log();
    private String portName;
    private String eventName;
    private String eventType;
    private EletricEvent eventConfig;
    private GlobalConfig globalConfig;
    private String sn;
    private String encode = "UTF-8";

    public SendEventsUtil() {
    }

    public SendEventsUtil(String portName, String eventType, String eventName, EletricEvent eventConfig, GlobalConfig globalConfig, String sn) {
        this.portName = portName;
        this.eventType = eventType;
        this.eventName = eventName;
        this.eventConfig = eventConfig;
        this.globalConfig = globalConfig;
        this.sn = sn;
    }

    public static void main(String[] args) {
        SendEventsUtil seu = new SendEventsUtil("COM3", null, "--0000000000000000000---1/nCommunication estabulish---1", null, null, "");
        seu.start();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        SmsInfo smsInfo = new SmsInfo();
        PropertiesUtils.wrapProperties(smsInfo);
        String[] destinations = this.eventConfig.getMobileStr().split(",");
        if (destinations != null && destinations.length > 0) {
            try {
                String content = null;
                content = this.globalConfig.getLanguage().equals("zh_CN") && "LADIS".equalsIgnoreCase(Config.getString("Customized")) ? "\u53d1\u9001\u6765\u81ea: " + this.portName + "_" + this.sn + "\r\n\u4e8b\u4ef6: " + this.eventName + "\r\n\u7c7b\u578b: " + this.eventType : "Send from: " + this.portName.substring(this.portName.lastIndexOf("_") + 1) + "_" + this.sn + "\r\nEvent:" + this.eventName;
                content = String.valueOf(content) + "\r\nDate_Time:" + DateUtils.getFormatTimestamp((Date)new Date());
                if ("LADIS".equalsIgnoreCase(Config.getString("Customized"))) {
                    content = "\u3010\u96f7\u8fea\u53f8UPS\u3011" + content;
                    System.out.println("\u96f7\u8fea\u53f8UPS\u5185\u5bb9:" + content.length() + "\n" + content);
                    this.smsServiceHandle(smsInfo, destinations, content);
                } else {
                    List<String> smss;
                    ModemAdapter adapter = new ModemAdapter(smsInfo.getComPort(), Integer.parseInt(smsInfo.getBit()), destinations, content);
                    if (smsInfo.isPdu()) {
                        this.encode = "UTF-16BE";
                        if (content.getBytes(this.encode).length < 140) {
                            adapter.startSendForPDU();
                        } else {
                            smss = this.smsMessage(content, 140);
                            boolean i = true;
                            for (String string : smss) {
                                ModemAdapter adapterPDU = new ModemAdapter(smsInfo.getComPort(), Integer.parseInt(smsInfo.getBit()), destinations, string);
                                adapterPDU.startSendForPDU();
                            }
                        }
                    } else {
                        this.encode = "UTF-8";
                        if (content.getBytes(this.encode).length < 160) {
                            adapter.startSendForAT();
                        } else {
                            smss = this.smsMessage(content, 160);
                            for (String sms : smss) {
                                ModemAdapter adapterAT = new ModemAdapter(smsInfo.getComPort(), Integer.parseInt(smsInfo.getBit()), destinations, sms);
                                adapterAT.startSendForAT();
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EmailInfo info = new EmailInfo();
        info.setAccount(ConfigDao.qryValue("EmailInfo.account"));
        info.setRecievers(ConfigDao.qryValue("EmailInfo.recievers"));
        info.setSender(ConfigDao.qryValue("EmailInfo.sender"));
        info.setSmtp(ConfigDao.qryValue("EmailInfo.smtp"));
        info.setPort(Integer.parseInt(ConfigDao.qryValue("EmailInfo.port")));
        info.setNeedAuth(Boolean.valueOf(Boolean.parseBoolean(ConfigDao.qryValue("EmailInfo.needAuth"))));
        info.setPassword(AES128CBC.descryptLocal(ConfigDao.qryValue("EmailInfo.password")));
        String encrypt = ConfigDao.qryValue("EmailInfo.encrypt");
        if (encrypt.equalsIgnoreCase("none")) {
            info.setEnableNone(true);
            info.setEnableSSL(false);
            info.setEnableTLS(false);
        } else if (encrypt.equalsIgnoreCase("TLS")) {
            info.setEnableNone(false);
            info.setEnableSSL(false);
            info.setEnableTLS(true);
        } else {
            info.setEnableNone(false);
            info.setEnableSSL(true);
            info.setEnableTLS(false);
        }
        String emailReceivers = this.eventConfig.getEmailStr();
        EmailSendUtil sendmail = null;
        sendmail = info.isEnableNone() ? new EmailSendUtil(info) : (MyConstants.Customized.equalsIgnoreCase("WattBox") ? new EmailSendUtil(info) : new EmailSendUtil(info));
        logger.info("---------emailReceivers.length()-----" + emailReceivers.length());
        if (info.getSmtp().length() != 0 && info.getAccount().length() != 0 && emailReceivers.length() != 0) {
            void var7_17;
            Object var7_14 = null;
            if (this.globalConfig.getLanguage().equals("zh_CN")) {
                String string = "\u6765\u81ea " + this.portName + "_" + this.sn + "\uff1b  \r\n\u4e8b\u4ef6: " + this.eventName + "\uff1b  \r\n\u7c7b\u578b: " + this.eventType;
            } else {
                String string = "From " + this.portName + "_" + this.sn + ";  \r\nEvent: " + this.eventName + ";  \r\nType: " + this.eventType;
            }
            String string = String.valueOf(var7_17) + ";  \r\nContact: " + info.getAccount() + ";  \r\nDateTime: " + DateUtils.getFormatTimestamp((Date)new Date());
            String[] strs = null;
            if (emailReceivers.indexOf(",") != -1) {
                strs = emailReceivers.split(",");
            }
            if (strs != null) {
                int i = 0;
                while (i < strs.length) {
                    String receiver = strs[i].trim();
                    if (info.isEnableNone()) {
                        ((EmailUtil)sendmail).sendMail(receiver, this.eventName, string);
                    } else if (MyConstants.Customized.equalsIgnoreCase("WattBox") || MyConstants.Customized.equalsIgnoreCase("NetGuard")) {
                        ((EmailUtil)sendmail).sendMail(receiver, this.eventName, string);
                    } else {
                        sendmail.send(info, receiver, this.eventName, string);
                    }
                    ++i;
                }
            } else if (info.isEnableNone()) {
                ((EmailUtil)sendmail).sendMail(emailReceivers, this.eventName, string);
            } else if (MyConstants.Customized.equalsIgnoreCase("WattBox")) {
                ((EmailUtil)sendmail).sendMail(emailReceivers, this.eventName, string);
            } else {
                sendmail.send(info, emailReceivers, this.eventName, string);
            }
        }
    }

    private List<String> smsMessage(String message, int len) {
        String language = this.globalConfig.getLanguage();
        ArrayList<String> sms = new ArrayList<String>();
        try {
            if (language.equals("zh_CN") || language.equals("zh_TW") || language.equals("jp_JP")) {
                byte[] bytes = message.getBytes(this.encode);
                while (bytes.length > len) {
                    String split = new String(bytes, 0, len - 2, this.encode);
                    split = this.stringSplit(bytes, message, split, 0, len - 2);
                    sms.add(split);
                    message = message.substring(split.length());
                    bytes = message.getBytes(this.encode);
                }
                sms.add(message);
            } else {
                int item = 0;
                String[] array = message.split(" ");
                String split = "";
                String temp = "";
                while (item < array.length) {
                    split = temp;
                    byte[] bytes = (temp = String.valueOf(temp) + array[item] + " ").getBytes(this.encode);
                    if (bytes.length > len) {
                        if (split.equals("")) {
                            ++item;
                            continue;
                        }
                        sms.add(split);
                        temp = "";
                        continue;
                    }
                    ++item;
                }
                if (!temp.equals("")) {
                    sms.add(temp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sms;
    }

    private String stringSplit(byte[] bytes, String message, String split, int head, int tail) throws UnsupportedEncodingException {
        while (tail > head) {
            if (message.contains(split)) {
                message = message.substring(split.length());
                break;
            }
            split = new String(bytes, head, --tail, "UTF-8");
        }
        return split;
    }

    public String smsServiceHandle(SmsInfo smsInfo, String[] destinations, String content) throws Exception {
        String phones = "";
        int length = destinations.length;
        String result = "";
        int i = 0;
        while (i < length) {
            phones = i != 0 && i % 100 == 0 ? String.valueOf(phones) + destinations[i] + "_" : (i == length - 1 ? String.valueOf(phones) + destinations[i] : String.valueOf(phones) + destinations[i] + ",");
            ++i;
        }
        if (length >= 100) {
            String[] hundredPhones = phones.split("_");
            int i2 = 0;
            while (i2 < hundredPhones.length) {
                if (hundredPhones[i2] != null && hundredPhones[i2].length() != 0) {
                    SendSMSByHttp ssb = new SendSMSByHttp();
                    result = ssb.callWebService(smsInfo, hundredPhones[i2], content);
                }
                ++i2;
            }
        } else {
            SendSMSByHttp ssb = new SendSMSByHttp();
            result = ssb.callWebService(smsInfo, phones, content);
        }
        return result;
    }
}

