/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronic.util.DateUtils;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.rmiclass.HistoryService;
import cn.com.voltronicpower.utilities.CSVUtil;
import cn.com.voltronicpower.utilities.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class SaveEvent {
    private static final Log logger = new Log();
    public static String oldDateString = DateUtils.getNowDate((String)"yyyy-MM-dd");
    private static HistoryService historyServ = null;
    private static DefaultTableModel jTabModel;
    static String titleStr;

    static {
        titleStr = "DATE  EVENT  TYPE";
    }

    public static synchronized void saveData(String message) {
        if (!SystemEnv.IS_TEST_MODE) {
            return;
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            try {
                String nowDateString;
                String url = String.valueOf(System.getProperty("user.dir")) + File.separator + "log" + File.separator + "testlog";
                File f = new File(url);
                if (!f.exists()) {
                    f.mkdirs();
                }
                if (!oldDateString.equals(nowDateString = DateUtils.getNowDate((String)"yyyy-MM-dd"))) {
                    SystemEnv.setFileNumber();
                    oldDateString = nowDateString;
                }
                String nowDateFile = String.valueOf(nowDateString) + "_" + SystemEnv.getFileNumber() + ".log";
                File file = new File(String.valueOf(url) + File.separator + nowDateFile);
                if (!file.exists()) {
                    file.createNewFile();
                }
                fos = new FileOutputStream(file, true);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                bw = new BufferedWriter(osw);
                String nowTime = DateUtils.getFormatTimestamp((Date)new Date());
                bw.write("[" + nowTime + "]" + message);
                bw.newLine();
                bw.flush();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void exportDatasForCSV(String portName, String ptid, String sn) {
        String url = String.valueOf(System.getProperty("user.dir")) + File.separator + "datas" + File.separator + "backup";
        String path = Config.getString("dataBackupPath");
        if (path == null || path.length() <= 0) {
            path = url;
        }
        Object[] titles = titleStr.split("  ");
        JTable jTable = new JTable();
        GregorianCalendar c = new GregorianCalendar();
        Date date = c.getTime();
        ArrayList<EventInfo> list = null;
        try {
            if (historyServ == null) {
                historyServ = new HistoryService();
            }
            list = historyServ.queryPortEvents(date, date, portName, ptid);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        ArrayList<String[]> strs = new ArrayList<String[]>();
        int i = 0;
        while (i < list.size()) {
            EventInfo info = list.get(i);
            strs.add(new String[]{DateUtils.getFormatTimestamp((Date)info.getOccurTime()), info.getEnName(), info.getEnType()});
            ++i;
        }
        Object[][] obj = new Object[strs.size()][titles.length];
        int i2 = 0;
        while (i2 < strs.size()) {
            int j = 0;
            while (j < titles.length) {
                obj[i2][j] = ((String[])strs.get(i2))[j];
                ++j;
            }
            ++i2;
        }
        jTabModel = new DefaultTableModel(obj, titles);
        jTable.setModel(jTabModel);
        CSVUtil csv = new CSVUtil(jTable, null, path, String.valueOf(portName) + "_" + ptid);
        csv.execute();
    }
}

