/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.data.bean.ModBusConfig;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.utilities.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import org.springframework.beans.BeanWrapperImpl;

public class PropertiesUtils {
    private static Properties properties;
    public static GlobalConfig globalConfig;
    private static final Log logger;
    private static Shutdownconfigure shutdown;
    private static HashMap<String, ModBusConfig> modbusconfigMap;
    private static String propFile;

    static {
        globalConfig = new GlobalConfig();
        logger = new Log();
        shutdown = new Shutdownconfigure();
        modbusconfigMap = new HashMap();
        propFile = "";
    }

    public static void initProperties() {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        propFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "config" + File.separator + "ups.properties";
        InputStream in = null;
        try {
            try {
                in = new FileInputStream(propFile);
                properties = new Properties();
                properties.load(in);
                PropertiesUtils.wrapProperties(globalConfig);
                PropertiesUtils.wrapProperties(shutdown);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                    Locale.setDefault(locale);
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                in.close();
                Locale.setDefault(locale);
            }
            catch (IOException iOException) {}
        }
    }

    public static void wrapProperties(Object obj) {
        Field[] fields = obj.getClass().getDeclaredFields();
        String className = obj.getClass().getSimpleName();
        BeanWrapperImpl configWrapper = new BeanWrapperImpl(obj);
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (!fieldName.equals("serialVersionUID")) {
                String valueStr;
                String key = String.valueOf(className) + "." + fieldName;
                if (fields[i].getType().getSimpleName().equals("boolean")) {
                    String str = "false";
                    try {
                        str = properties.getProperty(key).trim();
                    }
                    catch (Exception e) {
                        str = "batModeShutdown".equals(fieldName) ? "true" : "false";
                    }
                    configWrapper.setPropertyValue(fieldName, (Object)Boolean.parseBoolean(str));
                } else if (fields[i].getType().getSimpleName().equals("int")) {
                    int value;
                    block13: {
                        valueStr = "";
                        value = 0;
                        try {
                            valueStr = properties.getProperty(key);
                            value = Integer.parseInt(valueStr);
                        }
                        catch (Exception e) {
                            if (fields[i].getName().contains("reconnectCount")) {
                                value = 5;
                            }
                            if (!fields[i].getName().contains("batModeShutdownTime")) break block13;
                            value = 10;
                        }
                    }
                    configWrapper.setPropertyValue(fieldName, (Object)value);
                } else if (fields[i].getType().getSimpleName().equals("float")) {
                    valueStr = properties.getProperty(key);
                    float value = valueStr != null ? Float.parseFloat(valueStr) : 2.0f;
                    configWrapper.setPropertyValue(fieldName, (Object)Float.valueOf(value));
                } else {
                    String value = properties.getProperty(key);
                    value = value != null ? value : "";
                    configWrapper.setPropertyValue(fieldName, (Object)value);
                }
            }
            ++i;
        }
    }

    public static void setModBusConfigs() {
        PropertiesUtils.wrapProperties(globalConfig);
        modbusconfigMap.clear();
        String modbusInfo = PropertiesUtils.getGlobalConfig().getModBusComConfig();
        if (modbusInfo != null && !"".equals(modbusInfo)) {
            String[] modbusconfigs = modbusInfo.split(";");
            int item_i = 0;
            while (item_i < modbusconfigs.length) {
                String config = modbusconfigs[item_i];
                ModBusConfig modbusconfig = new ModBusConfig();
                modbusconfig.parseString(config);
                if (!modbusconfigMap.containsKey(modbusconfig.getComPort())) {
                    modbusconfigMap.put(modbusconfig.getComPort(), modbusconfig);
                }
                ++item_i;
            }
        }
    }

    public static HashMap<String, ModBusConfig> getModBusConfig() {
        return modbusconfigMap;
    }

    public static ModBusConfig getModBusConfigbyComPort(String comPort) {
        if (PropertiesUtils.getModBusConfig().containsKey(comPort)) {
            return PropertiesUtils.getModBusConfig().get(comPort);
        }
        return new ModBusConfig();
    }

    public static void updateProperties(Object obj) throws Exception {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Field[] fields = obj.getClass().getDeclaredFields();
        String className = obj.getClass().getSimpleName();
        BeanWrapperImpl configWrapper = new BeanWrapperImpl(obj);
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (!fieldName.equals("serialVersionUID")) {
                String key = String.valueOf(className) + "." + fieldName;
                properties.setProperty(key, String.valueOf(configWrapper.getPropertyValue(fieldName)));
            }
            ++i;
        }
        FileOutputStream fileOut = new FileOutputStream(propFile);
        properties.store(fileOut, "last update time" + new Date().toString());
        if (fileOut != null) {
            fileOut.close();
        }
        Locale.setDefault(locale);
    }

    public static void updateProperty(String key, String value) throws Exception {
        properties.setProperty(key, value);
        FileOutputStream fileOut = new FileOutputStream(propFile);
        properties.store(fileOut, "last update time" + new Date().toString());
        if (fileOut != null) {
            fileOut.close();
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void refreshProperties() {
        InputStream in = null;
        try {
            try {
                in = new FileInputStream(propFile);
                properties = new Properties();
                properties.load(in);
                PropertiesUtils.wrapProperties(globalConfig);
                PropertiesUtils.wrapProperties(shutdown);
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static GlobalConfig getGlobalConfig() {
        return globalConfig;
    }

    public static Shutdownconfigure getShutdownconfigure() {
        return shutdown;
    }

    public static void setShutdownconfigure(Shutdownconfigure shutdown) {
        PropertiesUtils.shutdown = shutdown;
    }

    public static void updateProperties(Object[] objs, Properties properties, File file) throws Exception {
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            PropertiesUtils.updateProperties(obj, properties);
            ++n2;
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        properties.store(fileOut, "last update time" + new Date().toString());
        if (fileOut != null) {
            fileOut.close();
        }
    }

    public static void updateProperties(Object obj, Properties properties, File file) throws Exception {
        PropertiesUtils.updateProperties(obj, properties);
        FileOutputStream fileOut = new FileOutputStream(file);
        properties.store(fileOut, "last update time" + new Date().toString());
        if (fileOut != null) {
            fileOut.close();
        }
    }

    public static void updateProperties(Object obj, Properties properties) {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        Field[] fields = obj.getClass().getDeclaredFields();
        String className = obj.getClass().getSimpleName();
        BeanWrapperImpl configWrapper = new BeanWrapperImpl(obj);
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (!fieldName.equals("serialVersionUID")) {
                String key = String.valueOf(className) + "." + fieldName;
                properties.setProperty(key, String.valueOf(configWrapper.getPropertyValue(fieldName)));
            }
            ++i;
        }
        Locale.setDefault(locale);
    }

    public static void wrapProperties(Object obj, Properties properties) {
        Field[] fields = obj.getClass().getDeclaredFields();
        String className = obj.getClass().getSimpleName();
        BeanWrapperImpl configWrapper = new BeanWrapperImpl(obj);
        int i = 0;
        while (i < fields.length) {
            String fieldName = fields[i].getName();
            if (!fieldName.equals("serialVersionUID")) {
                String key = String.valueOf(className) + "." + fieldName;
                configWrapper.setPropertyValue(fieldName, (Object)properties.getProperty(key));
            }
            ++i;
        }
    }
}

