/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
    private static final Log log = new Log();

    private static String getLineInfo() {
        StackTraceElement ste = new Throwable().getStackTrace()[3];
        return MessageFormat.format("[{0}:{1}]", ste.getClassName(), ste.getLineNumber());
    }

    public static void main(String[] args) {
        Object m = null;
        log.error("-----test--");
    }

    private void write(Level logLevel, String content) {
        boolean isContinue = true;
        if (!isContinue) {
            return;
        }
        FileOutputStream out = null;
        FilterOutputStream Buff = null;
        try {
            try {
                String fileName;
                File file;
                Date currentDate = new Date();
                String logRoot = System.getProperty("user.dir");
                if (logRoot == null || logRoot.isEmpty()) {
                    logRoot = "";
                }
                if (!(file = new File(fileName = String.valueOf(logRoot) + "/log/" + logLevel.levelStr.toLowerCase() + ".log")).exists()) {
                    file.createNewFile();
                }
                out = new FileOutputStream(fileName, true);
                Buff = new BufferedOutputStream(out);
                String msg = MessageFormat.format("{0} {1} {2} - {3}\r\n", this.df.format(currentDate), logLevel.levelStr, Log.getLineInfo(), content);
                Buff.write(msg.getBytes("utf-8"));
                System.out.println("--Msg:" + msg);
                ((BufferedOutputStream)Buff).flush();
                Buff.close();
            }
            catch (Exception var15) {
                var15.printStackTrace();
                try {
                    Buff.close();
                    out.close();
                }
                catch (Exception var14) {
                    var14.printStackTrace();
                }
            }
        }
        finally {
            try {
                Buff.close();
                out.close();
            }
            catch (Exception var14) {
                var14.printStackTrace();
            }
        }
    }

    public void info(Object content) {
        System.out.println("info-----" + content);
        this.write(Level.INFO, content.toString());
    }

    public void warn(Object content) {
        this.write(Level.WARN, content.toString());
    }

    public void error(Object content) {
        this.write(Level.ERROR, content.toString());
    }

    public void debug(Object content) {
        this.write(Level.DEBUG, content.toString());
    }

    public static enum Level {
        ERROR(40, "ERROR"),
        WARN(30, "WARN"),
        INFO(20, "INFO"),
        DEBUG(10, "DEBUG"),
        TRACE(0, "TRACE");

        private int levelInt;
        private String levelStr;

        private Level(int i, String s) {
            this.levelInt = i;
            this.levelStr = s;
        }

        public int toInt() {
            return this.levelInt;
        }

        public String toString() {
            return this.levelStr;
        }
    }
}

