/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronicpower.data.bean.EletricEvent;
import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.data.bean.PowerPlan;
import cn.com.voltronicpower.data.bean.SSHInfo;
import cn.com.voltronicpower.data.bean.TestPlan;
import cn.com.voltronicpower.data.dao.BatteryTestPlanDao;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.data.dao.EventConfigDao;
import cn.com.voltronicpower.data.dao.EventDao;
import cn.com.voltronicpower.data.dao.PowerPlanDao;
import cn.com.voltronicpower.data.dao.SSHInfoDao;
import cn.com.voltronicpower.data.tools.DBManager;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.MyMap;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExportAndImport {
    private static final Log logger = new Log();
    public static Map<String, String> map = new MyMap<String, String>();
    public static List<String> tablenames = new ArrayList<String>();
    public static final String linebreak = System.getProperty("line.separator");
    public static String path = "E:\\";

    public static boolean inittables() {
        boolean res;
        block21: {
            res = false;
            Connection conn = DBManager.getConnection();
            Statement st = null;
            ResultSet re = null;
            try {
                try {
                    st = conn.createStatement();
                    DatabaseMetaData dmd = conn.getMetaData();
                    re = dmd.getTables(null, null, null, new String[]{"TABLE"});
                    while (re.next()) {
                        String tableName = re.getString("table_name");
                        tablenames.add(tableName);
                    }
                    res = true;
                }
                catch (Exception s) {
                    s.printStackTrace();
                    if (st != null) {
                        try {
                            st.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (re == null) break block21;
                    try {
                        re.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception exception) {}
                }
                if (re != null) {
                    try {
                        re.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return res;
    }

    public static String exportConfig() {
        Map<Object, Object> configMap = new MyMap<String, String>();
        if (!tablenames.contains("DBCONFIG")) {
            configMap.put("EmailInfo.sender", PropertiesUtils.getProperty("EmailInfo.sender"));
            configMap.put("EmailInfo.account", PropertiesUtils.getProperty("EmailInfo.account"));
            configMap.put("EmailInfo.password", AES128CBC.encryptLocal(PropertiesUtils.getProperty("EmailInfo.password")));
            configMap.put("EmailInfo.port", PropertiesUtils.getProperty("EmailInfo.port"));
            configMap.put("EmailInfo.encrypt", PropertiesUtils.getProperty("EmailInfo.encrypt"));
            configMap.put("EmailInfo.needAuth", PropertiesUtils.getProperty("EmailInfo.needAuth"));
            configMap.put("EmailInfo.recievers", PropertiesUtils.getProperty("EmailInfo.recievers"));
            configMap.put("EmailInfo.smtp", PropertiesUtils.getProperty("EmailInfo.smtp"));
        } else {
            configMap = ConfigDao.qryAllValue();
        }
        String str = JSON.toJSONString(configMap);
        map.put("dbconfig", str);
        return str;
    }

    public static String exportSSHINFO() {
        List<Object> list = new ArrayList();
        if (!tablenames.contains("SSHINFO")) {
            String remoteIps = PropertiesUtils.getProperty("RemoteShutdown.remoteIps");
            if (remoteIps != null && !remoteIps.trim().equals("")) {
                String[] ips;
                String[] stringArray = ips = remoteIps.split(";");
                int n = ips.length;
                int n2 = 0;
                while (n2 < n) {
                    String ip = stringArray[n2];
                    if (ip != null && !ip.trim().equals("")) {
                        SSHInfo info = new SSHInfo();
                        info.setIp(ip);
                        info.setSshMode(false);
                        list.add(info);
                    }
                    ++n2;
                }
            }
        } else {
            SSHInfoDao dao = new SSHInfoDao();
            list = dao.getSSHInfos();
        }
        String str = JSONObject.toJSONString(list);
        map.put("SSHINFO", str);
        return str;
    }

    public static String exportSchedule_test() {
        BatteryTestPlanDao dao = new BatteryTestPlanDao();
        ArrayList<TestPlan> list = dao.getBatteryTestPlans();
        String str = JSONObject.toJSONString(list);
        map.put("BATTERY_TEST_PLAN", str);
        return str;
    }

    public static void exportConfigFile() {
        map.put("Shutdownconfigure.beforeAlertTime", PropertiesUtils.getProperty("Shutdownconfigure.beforeAlertTime"));
        map.put("Shutdownconfigure.lowBatShutdownUPS", PropertiesUtils.getProperty("Shutdownconfigure.lowBatShutdownUPS"));
        map.put("Shutdownconfigure.excuteProgramTime", PropertiesUtils.getProperty("Shutdownconfigure.excuteProgramTime"));
        map.put("Shutdownconfigure.parallel", PropertiesUtils.getProperty("Shutdownconfigure.parallel"));
        map.put("Shutdownconfigure.linuxCMD", PropertiesUtils.getProperty("Shutdownconfigure.linuxCMD"));
        map.put("Shutdownconfigure.noShutLocalExecute", PropertiesUtils.getProperty("Shutdownconfigure.noShutLocalExecute"));
        map.put("Shutdownconfigure.batModeShutdownSeconds", PropertiesUtils.getProperty("Shutdownconfigure.batModeShutdownSeconds"));
        map.put("Shutdownconfigure.excuteProgram", PropertiesUtils.getProperty("Shutdownconfigure.excuteProgram"));
        map.put("Shutdownconfigure.turnOnUPSdelay", PropertiesUtils.getProperty("Shutdownconfigure.turnOnUPSdelay"));
        map.put("Shutdownconfigure.alertIntervalTime", PropertiesUtils.getProperty("Shutdownconfigure.alertIntervalTime"));
        map.put("Shutdownconfigure.batModeShutdown", PropertiesUtils.getProperty("Shutdownconfigure.batModeShutdown"));
        map.put("Shutdownconfigure.turnOnUPS", PropertiesUtils.getProperty("Shutdownconfigure.turnOnUPS"));
        map.put("Shutdownconfigure.planShutdown", PropertiesUtils.getProperty("Shutdownconfigure.planShutdown"));
        map.put("Shutdownconfigure.overTemperatureShutdown", PropertiesUtils.getProperty("Shutdownconfigure.overTemperatureShutdown"));
        map.put("Shutdownconfigure.overTemperatureValue", PropertiesUtils.getProperty("Shutdownconfigure.overTemperatureValue"));
        map.put("Shutdownconfigure.batModeShutdownTime", PropertiesUtils.getProperty("Shutdownconfigure.batModeShutdownTime"));
        map.put("Shutdownconfigure.shutdownTime", PropertiesUtils.getProperty("Shutdownconfigure.shutdownTime"));
        map.put("Shutdownconfigure.cancelShutExcute", PropertiesUtils.getProperty("Shutdownconfigure.cancelShutExcute"));
        map.put("Shutdownconfigure.lowBatShutdown", PropertiesUtils.getProperty("Shutdownconfigure.lowBatShutdown"));
        map.put("Shutdownconfigure.batCapacity", PropertiesUtils.getProperty("Shutdownconfigure.batCapacity"));
        map.put("Shutdownconfigure.batCapacityShutdown", PropertiesUtils.getProperty("Shutdownconfigure.batCapacityShutdown"));
        map.put("Shutdownconfigure.shutdownMode", PropertiesUtils.getProperty("Shutdownconfigure.shutdownMode"));
        map.put("Shutdownconfigure.remoteShutdown", PropertiesUtils.getProperty("Shutdownconfigure.remoteShutdown"));
        map.put("Shutdownconfigure.batCapacityShutdown", PropertiesUtils.getProperty("Shutdownconfigure.batCapacityShutdown"));
        map.put("Shutdownconfigure.remoteAddrs", PropertiesUtils.getProperty("Shutdownconfigure.remoteAddrs"));
        map.put("Shutdownconfigure.batModeShutdownUps", PropertiesUtils.getProperty("Shutdownconfigure.batModeShutdownUps"));
        map.put("Shutdownconfigure.batCapacityShutdown", PropertiesUtils.getProperty("Shutdownconfigure.batCapacityShutdown"));
        map.put("SmsInfo.proxyPort", PropertiesUtils.getProperty("SmsInfo.proxyPort"));
        map.put("SmsInfo.proxy", PropertiesUtils.getProperty("SmsInfo.proxy"));
        map.put("SmsInfo.SMS_Server", PropertiesUtils.getProperty("SmsInfo.SMS_Server"));
        map.put("SmsInfo.bit", PropertiesUtils.getProperty("SmsInfo.bit"));
        map.put("SmsInfo.name", PropertiesUtils.getProperty("SmsInfo.name"));
        map.put("SmsInfo.password", PropertiesUtils.getProperty("SmsInfo.password"));
        map.put("SmsInfo.id", PropertiesUtils.getProperty("SmsInfo.id"));
        map.put("SmsInfo.chid", PropertiesUtils.getProperty("SmsInfo.chid"));
        map.put("SmsInfo.timestamp", PropertiesUtils.getProperty("SmsInfo.timestamp"));
        map.put("SmsInfo.comPort", PropertiesUtils.getProperty("SmsInfo.comPort"));
        map.put("SmsInfo.pdu", PropertiesUtils.getProperty("SmsInfo.pdu"));
        map.put("SmsInfo.centerNum", PropertiesUtils.getProperty("SmsInfo.centerNum"));
        map.put("SmsInfo.mobileNums", PropertiesUtils.getProperty("SmsInfo.mobileNums"));
        map.put("SmsInfo.useProxySet", PropertiesUtils.getProperty("SmsInfo.useProxySet"));
        map.put("SmsInfo.service", PropertiesUtils.getProperty("SmsInfo.service"));
        map.put("SmsInfo.pdu", PropertiesUtils.getProperty("SmsInfo.pdu"));
        map.put("netWeakUpCtrl", PropertiesUtils.getProperty("netWeakUpCtrl"));
        map.put("notScanComport", PropertiesUtils.getProperty("notScanComport"));
        map.put("GlobalConfig.dataAnalysisInterval", PropertiesUtils.getProperty("GlobalConfig.dataAnalysisInterval"));
        map.put("GlobalConfig.language", PropertiesUtils.getProperty("GlobalConfig.language"));
        map.put("GlobalConfig.dataRecordInterval", PropertiesUtils.getProperty("GlobalConfig.dataRecordInterval"));
        map.put("limitComs", PropertiesUtils.getProperty("limitComs"));
        map.put("macAddress", PropertiesUtils.getProperty("macAddress"));
    }

    public static String exportSchedule_power() {
        PowerPlanDao dao = new PowerPlanDao();
        ArrayList<PowerPlan> list = dao.getPowerPlans();
        String str = JSONObject.toJSONString(list);
        map.put("POWER_PLAN", str);
        return str;
    }

    public static String exportEventsConfig() {
        EventConfigDao dao = new EventConfigDao();
        List<EletricEvent> list = dao.getEventAllConfig2();
        String str = JSONObject.toJSONString(list);
        map.put("event_config", str);
        return str;
    }

    private static String exportEvent_record() {
        EventDao dao = new EventDao();
        List<EventInfo> list = dao.selcetALL();
        String str = JSONObject.toJSONString(list);
        map.put("event_record", str);
        return str;
    }

    public static void execExport() {
        block20: {
            try {
                ExportAndImport.inittables();
                PropertiesUtils.initProperties();
                ExportAndImport.exportConfig();
                ExportAndImport.exportSSHINFO();
                ExportAndImport.exportEventsConfig();
                ExportAndImport.exportSchedule_test();
                ExportAndImport.exportConfigFile();
                ExportAndImport.exportSchedule_power();
                ExportAndImport.exportEvent_record();
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.info("export erroe" + e1.getMessage());
            }
            logger.info("-----------------path:" + path);
            File bakup = new File(String.valueOf(path) + "ViewPower_bakup");
            BufferedWriter br = null;
            try {
                try {
                    if (bakup.exists()) {
                        bakup.delete();
                    }
                    bakup.createNewFile();
                    br = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(bakup)));
                    for (String key : map.keySet()) {
                        br.write(String.valueOf(key) + "#equal#" + map.get(key));
                        br.write("#separatorchar#");
                    }
                    br.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Connection conn = DBManager.getConnection();
        try {
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void importConfiguration() {
        block20: {
            PropertiesUtils.initProperties();
            File file = new File(path);
            String line = "";
            String str = "";
            BufferedReader br = null;
            try {
                String[] strs;
                br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                while ((line = br.readLine()) != null) {
                    if (line.trim().equals("")) continue;
                    str = String.valueOf(str) + line;
                }
                String[] stringArray = strs = str.split("#separatorchar#");
                int n = strs.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s != null && !s.trim().equals("")) {
                        String[] ss = s.split("#equal#");
                        String k = ss[0];
                        String v = "";
                        v = ss.length != 2 ? "" : ss[1];
                        map.put(k, v);
                    }
                    ++n2;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                break block20;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    break block20;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            }
            if (br == null) break block20;
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ExportAndImport.execImport();
    }

    public static boolean execImport() {
        logger.info("path-----" + path);
        boolean result = false;
        try {
            SSHInfoDao sshDao = new SSHInfoDao();
            sshDao.clearRemoteIP();
            String sshs = map.get("SSHINFO");
            if (sshs != null) {
                List list = new ArrayList();
                list = JSONArray.parseArray((String)sshs, SSHInfo.class);
                for (SSHInfo info : list) {
                    sshDao.addInfo(info);
                }
            }
            map.remove("SSHINFO");
            logger.info("DBCONFIG");
            String configStr = map.get("dbconfig");
            if (configStr != null) {
                Map dbmap = (Map)JSON.parse((String)configStr);
                ConfigDao configDao = new ConfigDao();
                for (String key : dbmap.keySet()) {
                    if (key.equals("EmailInfo.password") || key.equals("guestPassword") || key.equals("GlobalConfig.modbusPassword") || key.equals("managerPassword")) {
                        String[] list = ((String)dbmap.get(key)).split(" ");
                        logger.info("key---" + key + "---val---" + (String)dbmap.get(key));
                        logger.info("list.length:" + list.length);
                        Object k = new byte[list.length];
                        int l = 0;
                        while (l < list.length) {
                            k[l] = Byte.parseByte(list[l]);
                            ++l;
                        }
                        ConfigDao.updateValue(key, new String((byte[])k, "utf-8"));
                        logger.info(new String((byte[])k, "utf-8"));
                        try {
                            System.out.println(AES128CBC.descryptLocal(new String((byte[])k, "utf-8")));
                        }
                        catch (Exception e) {
                            logger.info("---" + e.getMessage());
                            e.printStackTrace();
                        }
                        continue;
                    }
                    ConfigDao.updateValue(key, (String)dbmap.get(key));
                }
            }
            map.remove("dbconfig");
            String eventStr = map.get("event_config");
            if (eventStr != null) {
                EventConfigDao eventsDao = new EventConfigDao();
                eventsDao.deleteAll();
                List events = JSONArray.parseArray((String)eventStr, EletricEvent.class);
                for (EletricEvent info : events) {
                    eventsDao.importEletricEvent(info);
                }
            }
            map.remove("event_config");
            String event_record = map.get("event_record");
            if (!event_record.equals(null)) {
                EventDao daorecord = new EventDao();
                List eventrecords = JSONArray.parseArray((String)event_record, EventInfo.class);
                for (EventInfo eventre : eventrecords) {
                    daorecord.addEvent(eventre);
                }
            }
            map.remove("event_record");
            String powerplan = map.get("POWER_PLAN");
            if (powerplan != null) {
                PowerPlanDao powerDao = new PowerPlanDao();
                powerDao.deleteAll();
                List powerplans = JSONArray.parseArray((String)powerplan, PowerPlan.class);
                for (PowerPlan info : powerplans) {
                    powerDao.addPowerPlan(info);
                }
            }
            map.remove("POWER_PLAN");
            String testplan = map.get("BATTERY_TEST_PLAN");
            if (testplan != null) {
                BatteryTestPlanDao testDao = new BatteryTestPlanDao();
                testDao.deleteAll();
                List testplans = JSONArray.parseArray((String)testplan, TestPlan.class);
                for (TestPlan info : testplans) {
                    testDao.addBatteryTestPlan(info);
                }
            }
            map.remove("BATTERY_TEST_PLAN");
            for (String key : map.keySet()) {
                PropertiesUtils.updateProperty(key, map.get(key));
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void main(String[] args) {
        ExportAndImport.execExport();
    }
}

