/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronicpower.utilities.Log;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import expect4j.Closure;
import expect4j.Expect4j;
import expect4j.ExpectState;
import expect4j.matches.EofMatch;
import expect4j.matches.Match;
import expect4j.matches.RegExpMatch;
import expect4j.matches.TimeoutMatch;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.oro.text.regex.MalformedPatternException;

public class ExcuteSSH {
    private static final Log log = new Log();
    private Session session;
    private ChannelShell channel;
    private static Expect4j expect = null;
    private static final long defaultTimeOut = 1000L;
    private StringBuffer buffer = new StringBuffer();
    public static final int COMMAND_EXECUTION_SUCCESS_OPCODE = -2;
    public static final String BACKSLASH_R = "\r";
    public static final String BACKSLASH_N = "\n";
    public static final String COLON_CHAR = ":";
    public static String ENTER_CHARACTER = "\r";
    public static final int SSH_PORT = 22;
    public static String[] linuxPromptRegEx = new String[]{"~]#", "~#", "#", ":~#", "/$", ">"};
    public static String[] errorMsg = new String[]{"could not acquire the config lock "};
    private String ip;
    private int port;
    private String user;
    private String password;

    public ExcuteSSH(String ip, int port, String user, String password) {
        this.ip = ip;
        this.port = port;
        this.user = user;
        this.password = password;
        expect = this.getExpect();
    }

    public void disconnect() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public String getResponse() {
        return this.buffer.toString();
    }

    private Expect4j getExpect() {
        try {
            log.info(1);
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.user, this.ip, this.port);
            this.session.setPassword(this.password);
            log.info("2user" + this.user + "-- ");
            Hashtable<String, String> config = new Hashtable<String, String>();
            config.put("StrictHostKeyChecking", "no");
            log.info("3password-" + this.password + "--");
            this.session.setConfig(config);
            localUserInfo ui = new localUserInfo();
            this.session.setUserInfo((UserInfo)ui);
            log.info(4);
            this.session.connect();
            log.info(5);
            this.channel = (ChannelShell)this.session.openChannel("shell");
            Expect4j expect = new Expect4j(this.channel.getInputStream(), this.channel.getOutputStream());
            this.channel.connect();
            log.info(6);
            return expect;
        }
        catch (Exception ex) {
            log.error("Connect to " + this.ip + COLON_CHAR + this.port + "failed,please check your username and password!");
            log.info("error --" + ex.getMessage());
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean executeCommands(String[] commands) {
        int n;
        int n2;
        String[] stringArray;
        if (expect == null) {
            return false;
        }
        log.debug("----------Running commands are listed as follows:----------");
        String[] stringArray2 = commands;
        int n3 = commands.length;
        int n4 = 0;
        while (n4 < n3) {
            String command = stringArray2[n4];
            log.debug(command);
            ++n4;
        }
        log.debug("----------End----------");
        Closure closure = new Closure(){

            public void run(ExpectState expectState) throws Exception {
                ExcuteSSH.this.buffer.append(expectState.getBuffer());
                expectState.exp_continue();
            }
        };
        ArrayList<Match> lstPattern = new ArrayList<Match>();
        String[] regEx = linuxPromptRegEx;
        if (regEx != null && regEx.length > 0) {
            stringArray2 = regEx;
            // MONITORENTER : regEx
            stringArray = regEx;
            n2 = regEx.length;
            n = 0;
            while (true) {
                if (n >= n2) {
                    lstPattern.add((Match)new EofMatch(new Closure(){

                        public void run(ExpectState state) {
                        }
                    }));
                    lstPattern.add((Match)new TimeoutMatch(1000L, new Closure(){

                        public void run(ExpectState state) {
                        }
                    }));
                    // MONITOREXIT : stringArray2
                    break;
                }
                String regexElement = stringArray[n];
                try {
                    RegExpMatch mat = new RegExpMatch(regexElement, closure);
                    lstPattern.add((Match)mat);
                }
                catch (MalformedPatternException e) {
                    // MONITOREXIT : stringArray2
                    return false;
                }
                catch (Exception e) {
                    // MONITOREXIT : stringArray2
                    return false;
                }
                ++n;
            }
        }
        try {
            boolean isSuccess = true;
            stringArray = commands;
            n2 = commands.length;
            n = 0;
            while (true) {
                block18: {
                    if (n < n2) break block18;
                }
                String strCmd = stringArray[n];
                isSuccess = this.isSuccess(lstPattern, strCmd);
                ++n;
            }
            isSuccess = !this.checkResult(expect.expect(lstPattern));
            String response = this.buffer.toString().toLowerCase();
            String[] stringArray3 = errorMsg;
            int n5 = errorMsg.length;
            n2 = 0;
            while (true) {
                if (n2 >= n5) {
                    return isSuccess;
                }
                String msg = stringArray3[n2];
                if (response.indexOf(msg) > -1) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private boolean isSuccess(List<Match> objPattern, String strCommandPattern) {
        try {
            boolean isFailed = this.checkResult(expect.expect(objPattern));
            if (!isFailed) {
                expect.send(strCommandPattern);
                expect.send(BACKSLASH_R);
                return true;
            }
            return false;
        }
        catch (MalformedPatternException ex) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean checkResult(int intRetVal) {
        return intRetVal == -2;
    }

    public static void main(String[] args) {
        ExcuteSSH sh = new ExcuteSSH("192.168.160.152", 22, "root", "123456");
        String[] cmd = new String[]{"shutdown -h now", sh.password};
        sh.executeCommands(cmd);
    }

    public static class localUserInfo
    implements UserInfo {
        String passwd;

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptYesNo(String str) {
            return true;
        }

        public String getPassphrase() {
            return null;
        }

        public boolean promptPassphrase(String message) {
            return true;
        }

        public boolean promptPassword(String message) {
            return true;
        }

        public void showMessage(String message) {
        }
    }
}

