/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.utilities;

import cn.com.voltronic.util.DateUtils;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.GregorianCalendar;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class CSVUtil {
    private JTable table = null;
    private Component parentComp = null;
    private String path;
    private String deviceName;
    private String oldDeviceName = "";
    public static String oldDateString = DateUtils.getNowDate((String)"yyyy-MM-dd");

    public CSVUtil(JTable table, Component parentComp, String path, String deviceName) {
        this.table = table;
        this.parentComp = parentComp;
        this.path = path;
        this.deviceName = deviceName;
    }

    public boolean execute() {
        block11: {
            if (this.table != null) break block11;
            return false;
        }
        try {
            String nowDateString;
            File f2;
            File f = new File(this.path);
            if (!f.exists()) {
                f.mkdirs();
            }
            GregorianCalendar c = new GregorianCalendar();
            int year = c.get(1);
            int month = c.get(2) + 1;
            File f1 = new File(String.valueOf(f.getPath()) + File.separator + year);
            if (!f1.exists()) {
                f1.mkdirs();
            }
            if (!(f2 = new File(String.valueOf(f1.getPath()) + File.separator + month)).exists()) {
                f2.mkdirs();
            }
            if (!oldDateString.equals(nowDateString = DateUtils.getNowDate((String)"yyyy-MM-dd"))) {
                oldDateString = nowDateString;
            }
            if (!this.oldDeviceName.equals(this.deviceName)) {
                this.oldDeviceName = this.deviceName;
            }
            String nowDateFile = String.valueOf(nowDateString) + "_" + this.deviceName + ".csv";
            File file = new File(String.valueOf(f2.getPath()) + File.separator + nowDateFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            if (file != null) {
                file.exists();
                if (CSVUtil.getExtension(file).equalsIgnoreCase("csv")) {
                    return CSVFileWriter.writeTableModel(this.table, file);
                }
                return XMLFileWriter.writeTableModel(this.table, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private File showSaveDialog() {
        JFileChooser chooser = new JFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.addChoosableFileFilter(new CSVFileFilter());
        chooser.addChoosableFileFilter(new XMLFileFilter());
        chooser.setFileSelectionMode(0);
        int ret = chooser.showSaveDialog(this.parentComp);
        if (ret == 0) {
            File f = chooser.getSelectedFile();
            FileFilter filter = chooser.getFileFilter();
            if (filter instanceof CSVFileFilter) {
                String extension = CSVUtil.getExtension(f);
                if (extension == null || !extension.equalsIgnoreCase(((CSVFileFilter)filter).getExtension())) {
                    return new File(String.valueOf(f.getAbsolutePath()) + "." + ((CSVFileFilter)filter).getExtension());
                }
            } else {
                String extension = CSVUtil.getExtension(f);
                if (extension == null || !extension.equalsIgnoreCase(((XMLFileFilter)filter).getExtension())) {
                    return new File(String.valueOf(f.getAbsolutePath()) + "." + ((XMLFileFilter)filter).getExtension());
                }
            }
            return f;
        }
        return null;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static void main(String[] args) {
        CSVUtil csv = new CSVUtil(null, null, "", "");
        csv.execute();
    }

    static class CSVFileFilter
    extends FileFilter {
        CSVFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                if (this.getExtension().equalsIgnoreCase(CSVUtil.getExtension(f))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "csv format";
        }

        public String getExtension() {
            return "csv";
        }
    }

    static class CSVFileWriter {
        CSVFileWriter() {
        }

        public static boolean writeTableModel(JTable fTable, File file) {
            FileOutputStream fos = null;
            OutputStreamWriter osw = null;
            BufferedWriter bw = null;
            if (fTable == null) {
                return false;
            }
            TableModel tableModel = fTable.getModel();
            StringBuffer fileBuf = new StringBuffer("");
            int rowCount = tableModel.getRowCount();
            int columnCount = tableModel.getColumnCount();
            int col = 0;
            while (col < columnCount) {
                fileBuf.append(tableModel.getColumnName(col));
                fileBuf.append(",");
                ++col;
            }
            fileBuf.append("\n");
            int row = 0;
            while (row < rowCount) {
                int col2 = 0;
                while (col2 < columnCount) {
                    fileBuf.append(tableModel.getValueAt(row, col2).toString());
                    if (col2 != columnCount - 1) {
                        fileBuf.append(",");
                    }
                    ++col2;
                }
                fileBuf.append("\n");
                ++row;
            }
            try {
                fos = new FileOutputStream(file);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                bw = new BufferedWriter(osw);
                bw.write(fileBuf.toString());
                bw.flush();
                bw.newLine();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return false;
            }
            finally {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class XMLFileFilter
    extends FileFilter {
        XMLFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                if (this.getExtension().equalsIgnoreCase(CSVUtil.getExtension(f))) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "xls format";
        }

        public String getExtension() {
            return "xls";
        }
    }

    static class XMLFileWriter {
        XMLFileWriter() {
        }

        public static boolean writeTableModel(JTable fTable, File file) {
            if (fTable == null) {
                return false;
            }
            TableModel tableModel = fTable.getModel();
            int rowCount = tableModel.getRowCount();
            int columnCount = tableModel.getColumnCount();
            WorkbookSettings ws = new WorkbookSettings();
            try {
                WritableWorkbook workbook = Workbook.createWorkbook((File)file, (WorkbookSettings)ws);
                String name = fTable.getName() != null ? fTable.getName() : "sheet1";
                WritableSheet sheet = workbook.createSheet(name, 0);
                WritableFont arial10ptBold = new WritableFont(WritableFont.ARIAL, 10, WritableFont.BOLD);
                WritableCellFormat headerFormat = new WritableCellFormat(arial10ptBold);
                WritableCellFormat wrappedformat = new WritableCellFormat(WritableWorkbook.ARIAL_10_PT);
                wrappedformat.setWrap(true);
                int col = 0;
                while (col < columnCount) {
                    sheet.addCell((WritableCell)new Label(col, 0, tableModel.getColumnName(col), (CellFormat)headerFormat));
                    ++col;
                }
                int row = 0;
                while (row < rowCount) {
                    int col2 = 0;
                    while (col2 < columnCount) {
                        sheet.addCell((WritableCell)new Label(col2, row + 1, tableModel.getValueAt(row, col2).toString(), (CellFormat)wrappedformat));
                        ++col2;
                    }
                    ++row;
                }
                workbook.write();
                workbook.close();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
                return false;
            }
            return true;
        }
    }
}

