/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.tomcat;

import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.tomcat.StreamClear;
import cn.com.voltronicpower.utilities.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Cmd {
    private static final Log logger = new Log();
    private static final String DIR = System.getProperty("user.dir");
    private static final String TOMCATFILE = String.valueOf(DIR) + "\\tomcat\\bin\\service.bat";
    private static final String STARTTOMCAT = "sc start upsTomcat";
    private static final String STOPTOMCAT = "sc stop upsTomcat";
    private static final String QUERYSERVER = "sc query upsTomcat";
    private static final String STARTTOMCATINAPP = String.valueOf(DIR) + "\\tomcat\\bin\\startup.bat";
    private static final String STOPTOMCATINAPP = String.valueOf(DIR) + "\\tomcat\\bin\\shutdown.bat";
    private static final String LINUX_STARTTOMCAT = String.valueOf(DIR) + "/tomcat/bin/start.sh";
    private static final String LINUX_STOPTOMCAT = String.valueOf(DIR) + "/tomcat/bin/stop.sh";
    private static final String MAC_STARTTOMCAT = String.valueOf(DIR) + "/tomcat/bin/startup.sh";
    private static final String MAC_STOPTOMCAT = String.valueOf(DIR) + "/tomcat/bin/shutdown.sh";
    public static final int RUNNING = 4;
    public static final int STOP_PENDING = 3;
    public static final int START_PENDING = 2;
    public static final int STOPPED = 1;
    public static final int NOTEXIST = 1060;
    public static final int INSTALLED = 5000;

    public static int startserver() {
        return Cmd.parsingbuffer(STARTTOMCAT);
    }

    public static void startserverinapp() {
        try {
            Cmd.execnoreturn(STARTTOMCATINAPP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startTomcatServerLinux() {
        try {
            Cmd.execnoreturn(LINUX_STARTTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void startTomcatServerMac() {
        try {
            Cmd.execnoreturn(MAC_STARTTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int stopserver() {
        return Cmd.parsingbuffer(STOPTOMCAT);
    }

    public static void stopserverinapp() {
        try {
            Cmd.execnoreturn(STOPTOMCATINAPP);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopTomcatServerLinux() {
        try {
            Cmd.execnoreturn(LINUX_STOPTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopTomcatServerMac() {
        try {
            Cmd.execnoreturn(MAC_STOPTOMCAT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int registerService() {
        String command = "\"" + TOMCATFILE + "\"" + " install " + "upsTomcat" + " & exit";
        if (Cmd.serverstatus() == 1060) {
            return Cmd.parsingbuffer(command);
        }
        return -1;
    }

    public static int serverstatus() {
        int status = Cmd.parsingbuffer(QUERYSERVER);
        return status;
    }

    public static int serverstatusinapprun() {
        int result;
        block8: {
            result = 1;
            try (SystemTrayUDPClient client = null;){
                try {
                    client = new SystemTrayUDPClient("localhost", 51223);
                    client.send("VP_LINK".getBytes("UTF-8"));
                    String str = client.receiveString();
                    if ("tomcatOK".equals(str)) {
                        result = 4;
                        break block8;
                    }
                    result = 1;
                }
                catch (Exception exception) {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return result;
    }

    public static int serverstatusinappstop() {
        int result;
        block8: {
            result = 1;
            try (SystemTrayUDPClient client = null;){
                try {
                    client = new SystemTrayUDPClient("localhost", 51223);
                    client.send("VP_LINK".getBytes("UTF-8"));
                    String str = client.receiveString();
                    if ("tomcatOK".equals(str)) {
                        result = 4;
                        break block8;
                    }
                    result = 1;
                }
                catch (Exception exception) {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        return result;
    }

    public static void execnoreturn(String cmd) throws Exception {
        try {
            Process proc = Cmd.execmd_pro(cmd);
            StreamClear clear = new StreamClear(proc.getErrorStream());
            clear.start();
            StreamClear input = new StreamClear(proc.getInputStream());
            input.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static int parsingbuffer(String cmd) {
        BufferedReader bufferedReader = null;
        try {
            Process proc = Cmd.execmd_pro(cmd);
            bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            StreamClear clear = new StreamClear(proc.getErrorStream());
            clear.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return Cmd.parsing(bufferedReader);
    }

    protected static int parsinginapp(BufferedReader bufferedReader, String strport) {
        int results = 1;
        try {
            try {
                String readline;
                while ((readline = bufferedReader.readLine()) != null) {
                    String str = "LISTENING";
                    str = MyConstants.IS_OS_WINDOWS ? "LISTENING" : "LISTEN";
                    if (readline.indexOf(str) == -1 || readline.indexOf(strport) == -1) continue;
                    results = 4;
                    break;
                }
                while ((readline = bufferedReader.readLine()) != null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    private static Process execmd_pro(String cmd) {
        Process proc = null;
        try {
            proc = Runtime.getRuntime().exec(cmd);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return proc;
    }

    private static int parsing(BufferedReader bufferedReader) {
        String readline = null;
        int result = 0;
        try {
            try {
                while ((readline = bufferedReader.readLine()) != null) {
                    if (readline.indexOf("STATE") != -1) {
                        if (readline.indexOf("RUNNING") != -1) {
                            result = 4;
                            break;
                        }
                        if (readline.indexOf("STOP_PENDING") != -1) {
                            result = 3;
                            break;
                        }
                        if (readline.indexOf("START_PENDING") != -1) {
                            result = 2;
                            break;
                        }
                        if (readline.indexOf("STOPPED") == -1) break;
                        result = 1;
                        break;
                    }
                    if (readline.indexOf("installed") != -1) {
                        result = 5000;
                        break;
                    }
                    if (readline.indexOf("1060") == -1) continue;
                    result = 1060;
                    break;
                }
                while ((readline = bufferedReader.readLine()) != null) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            int i = 1;
            while (i < 254) {
                Cmd.execnoreturn("ping 192.168.107." + i);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

