/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.data.bean.EletricEvent;
import cn.com.voltronicpower.data.bean.EmailInfo;
import cn.com.voltronicpower.data.bean.Event;
import cn.com.voltronicpower.data.bean.LocalComs;
import cn.com.voltronicpower.data.bean.ModBusConfig;
import cn.com.voltronicpower.data.bean.SmsInfo;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.data.dao.EventConfigDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.mail.EmailSendUtil;
import cn.com.voltronicpower.mail.EmailUtil;
import cn.com.voltronicpower.mail.InstallCert;
import cn.com.voltronicpower.mail.MailUtil;
import cn.com.voltronicpower.modem.ModemAdapter;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.SystemServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.NetworkWake;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.utilities.SendEventsUtil;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SystemService
extends ServiceSupport
implements SystemServiceInterface {
    private static final long serialVersionUID = 4548863083735807227L;
    private static final Log log = new Log();

    public String userLogin(String loginType, String password) throws RemoteException {
        boolean result;
        String managerPassword = ConfigDao.qryValue("managerPassword");
        if (managerPassword == null) {
            managerPassword = "administrator";
            managerPassword = this.updateManagerPassword(managerPassword);
        }
        if (result = managerPassword.equals(AES128CBC.encryptLocal(password))) {
            return "success";
        }
        return "failure";
    }

    public boolean validatePassword(String password) throws RemoteException {
        try {
            String managerPassword = ConfigDao.qryValue("managerPassword");
            boolean bl = managerPassword.equals(AES128CBC.encryptLocal(password));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getModbusPassword() throws RemoteException {
        String modbusPassword = ConfigDao.qryValue("GlobalConfig.modbusPassword");
        modbusPassword = AES128CBC.descryptLocal(modbusPassword);
        return modbusPassword;
    }

    public boolean getAccessRemoteCtrl() throws RemoteException {
        try {
            String bool = PropertiesUtils.getProperty("accessRemoteCtrl");
            if (bool == null) {
                bool = "false";
            }
            return Boolean.parseBoolean(bool);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String updateManagerPassword(String managerPassword) throws RemoteException {
        try {
            String password = AES128CBC.encryptLocal(managerPassword);
            ConfigDao.updateValue("managerPassword", password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return managerPassword;
    }

    public String updateModbusPassword(String modbuspwd) throws RemoteException {
        try {
            String password = AES128CBC.encryptLocal(modbuspwd);
            ConfigDao.updateValue("GlobalConfig.modbusPassword", password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modbuspwd;
    }

    public String updateGuestPassword(String guestPassword, boolean accessRemoteCtrl) throws RemoteException {
        try {
            String password = AES128CBC.encryptLocal(guestPassword);
            ConfigDao.updateValue("guestPassword", password);
            PropertiesUtils.updateProperty("accessRemoteCtrl", String.valueOf(accessRemoteCtrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guestPassword;
    }

    public SmsInfo getSmsInfo() throws RemoteException {
        SmsInfo info = new SmsInfo();
        try {
            if (MyConstants.Customized.equals("LADIS")) {
                info.setChid(ConfigDao.qryValue("chid"));
                info.setTimestamp(ConfigDao.qryValue("timestamp"));
                info.setUseProxySet(ConfigDao.qryValue("useProxySet").equals("true"));
                info.setProxy(ConfigDao.qryValue("proxy"));
                info.setProxyPort(ConfigDao.qryValue("proxyPort"));
                info.setComPort(ConfigDao.qryValue("comPort"));
                info.setBit(ConfigDao.qryValue("bit"));
                info.setPdu(ConfigDao.qryValue("pdu").equals("true"));
                info.setService(ConfigDao.qryValue("service"));
                info.setMobileNums(ConfigDao.qryValue("mobileNums"));
                info.setName(ConfigDao.qryValue("apiCode"));
                info.setPassword(ConfigDao.qryValue("secret"));
            } else {
                PropertiesUtils.wrapProperties(info);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    public SmsInfo updateSmsInfo(SmsInfo info) throws RemoteException {
        try {
            if (MyConstants.Customized.equals("LADIS")) {
                String chid = info.getChid();
                String delayTimes = info.getTimestamp().trim();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long current = delayTimes == null || "".equals(delayTimes) ? System.currentTimeMillis() : System.currentTimeMillis() + Long.parseLong(info.getTimestamp()) * 1000L;
                Date dates = new Date(current);
                String Timestamp2 = sdf.format(dates);
                ConfigDao.updateValue("timestamp", info.getTimestamp());
                ConfigDao.updateValue("proxy", info.getProxy());
                ConfigDao.updateValue("proxyPort", info.getProxyPort());
                ConfigDao.updateValue("comPort", info.getComPort());
                ConfigDao.updateValue("bit", info.getBit());
                ConfigDao.updateValue("service", info.getService());
                ConfigDao.updateValue("mobileNums", info.getMobileNums());
                ConfigDao.updateValue("bit", info.getBit());
                ConfigDao.updateValue("chid", chid);
                ConfigDao.updateValue("sendtime", Timestamp2);
                if (!info.getName().equals("languang") && !info.getName().equals("")) {
                    ConfigDao.updateValue("apiCode", info.getName());
                }
                if (!info.getPassword().equals("languang123") && !info.getPassword().equals("")) {
                    ConfigDao.updateValue("secret", info.getPassword());
                }
            } else {
                PropertiesUtils.updateProperties(info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public EmailInfo getEmailInfo() throws RemoteException {
        EmailInfo info = new EmailInfo();
        try {
            info.setAccount(ConfigDao.qryValue("EmailInfo.account"));
            info.setSmtp(ConfigDao.qryValue("EmailInfo.smtp"));
            info.setSender(ConfigDao.qryValue("EmailInfo.sender"));
            info.setPort(Integer.parseInt(ConfigDao.qryValue("EmailInfo.port")));
            info.setNeedAuth(Boolean.valueOf(Boolean.parseBoolean(ConfigDao.qryValue("EmailInfo.needAuth"))));
            info.setPassword(AES128CBC.descryptLocal(ConfigDao.qryValue("EmailInfo.password")));
            info.setRecievers(ConfigDao.qryValue("EmailInfo.recievers"));
            if (ConfigDao.qryValue("EmailInfo.encrypt").equalsIgnoreCase("none")) {
                info.setEnableNone(true);
                info.setEnableSSL(false);
                info.setEnableTLS(false);
            } else if (ConfigDao.qryValue("EmailInfo.encrypt").equalsIgnoreCase("ssl")) {
                info.setEnableNone(false);
                info.setEnableSSL(true);
                info.setEnableTLS(false);
            } else {
                info.setEnableNone(false);
                info.setEnableSSL(false);
                info.setEnableTLS(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public EmailInfo updateEmailInfo(EmailInfo info) throws RemoteException {
        log.info("updateEmailInfo" + info.getAccount());
        try {
            ConfigDao.updateValue("EmailInfo.account", info.getAccount());
            ConfigDao.updateValue("EmailInfo.smtp", info.getSmtp());
            ConfigDao.updateValue("EmailInfo.sender", info.getSender());
            ConfigDao.updateValue("EmailInfo.port", String.valueOf(info.getPort()));
            ConfigDao.updateValue("EmailInfo.needAuth", "" + info.getNeedAuth());
            ConfigDao.updateValue("EmailInfo.password", AES128CBC.encryptLocal(info.getPassword()));
            ConfigDao.updateValue("EmailInfo.recievers", info.getRecievers());
            if (info.isEnableNone()) {
                ConfigDao.updateValue("EmailInfo.encrypt", "none");
            } else if (info.isEnableSSL()) {
                ConfigDao.updateValue("EmailInfo.encrypt", "ssl");
            } else if (info.isEnableTLS()) {
                ConfigDao.updateValue("EmailInfo.encrypt", "tls");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public static void main(String[] args) {
        try {
            EmailInfo info = new EmailInfo();
            info.setEnableTLS(true);
            info.setPort(25);
            info.setPassword("ROTUHPPNTJRRGIGQ");
            info.setSmtp("sntp.163.com");
            info.setNeedAuth(Boolean.valueOf(true));
            info.setSender("peilida1998@163.com");
            info.setAccount("test");
            SystemService s = new SystemService();
            s.testMailConfig(info, "peilida1998@163.com");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String testMailConfig(EmailInfo info, String to) throws RemoteException {
        String[] toWho;
        String subject = String.valueOf(this.getCustomer()) + " test mail.";
        log.info("test mail config");
        boolean flag = false;
        String[] stringArray = toWho = to.split(",");
        int n = toWho.length;
        int n2 = 0;
        while (n2 < n) {
            EmailUtil sendmail;
            String rece = stringArray[n2];
            if (info.isEnableNone()) {
                sendmail = new EmailSendUtil(info);
                flag = ((EmailSendUtil)sendmail).sendMail(rece, subject, String.valueOf(info.getAccount()) + " test!!!!");
            } else if (info.isEnableSSL()) {
                sendmail = new MailUtil();
                flag = ((MailUtil)sendmail).send(info, rece, subject, String.valueOf(info.getAccount()) + " test!!!!");
            } else if (MyConstants.Customized.equalsIgnoreCase("WattBox")) {
                sendmail = new EmailSendUtil(info);
                flag = ((EmailSendUtil)sendmail).sendMail(rece, subject, String.valueOf(info.getAccount()) + " test!!!!");
            } else if (MyConstants.Customized.equalsIgnoreCase("NetGuard")) {
                sendmail = new EmailSendUtil(info);
                flag = ((EmailSendUtil)sendmail).sendMail(rece, subject, String.valueOf(info.getAccount()) + " test!!!!");
            } else {
                sendmail = new EmailSendUtil(info);
                flag = ((EmailSendUtil)sendmail).sendMail(rece, subject, String.valueOf(info.getAccount()) + " test!!!!");
            }
            ++n2;
        }
        return flag ? "success" : "failure";
    }

    public String getMacAddress() throws RemoteException {
        String macAddress = PropertiesUtils.getProperty("macAddress");
        if (macAddress == null) {
            macAddress = "";
        }
        return macAddress;
    }

    public boolean getNetWeakUpCtrl() throws RemoteException {
        try {
            String bool = PropertiesUtils.getProperty("netWeakUpCtrl");
            if (bool == null) {
                bool = "true";
            }
            return Boolean.parseBoolean(bool);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String updateMacAddress(String macAddress) throws RemoteException {
        try {
            if (macAddress == null) {
                macAddress = "";
            }
            PropertiesUtils.updateProperty("macAddress", macAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return PropertiesUtils.getProperty("macAddress");
    }

    public Boolean updateNetWeakUpCtrl(boolean netWeakUpCtrl) throws RemoteException {
        try {
            PropertiesUtils.updateProperty("netWeakUpCtrl", String.valueOf(netWeakUpCtrl));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return netWeakUpCtrl;
    }

    public EletricEvent getEventConfigById(String eventId) throws RemoteException {
        EletricEvent event = null;
        try {
            EventConfigDao configDao = new EventConfigDao();
            event = configDao.getEventConfigById(eventId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    public EletricEvent setEventConfig(EletricEvent event) throws RemoteException {
        try {
            EventConfigDao configDao = new EventConfigDao();
            if (configDao.isExistConfig(event.getEventId())) {
                configDao.setEventConfig(event);
            } else {
                configDao.addEventConfig(event);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return event;
    }

    public String testNetworkWake(String[] macAddr) throws RemoteException {
        try {
            NetworkWake wake = new NetworkWake();
            wake.wakeLanPC(macAddr);
        }
        catch (Exception e) {
            return "failure";
        }
        return "success";
    }

    public ArrayList<String> getPorts() throws RemoteException {
        return CommConnector.getInstance().getPorts();
    }

    public String testSms(SmsInfo smsInfo) throws RemoteException {
        ModemAdapter adapter;
        block5: {
            String[] destinations = smsInfo.getMobileNums().split(",");
            adapter = new ModemAdapter(smsInfo.getComPort(), Integer.parseInt(smsInfo.getBit()), destinations, "send test success");
            if (!smsInfo.isPdu()) break block5;
            if (adapter.startSendForPDU()) {
                return "success";
            }
        }
        try {
            if (adapter.startSendForAT()) {
                return "success";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "failure";
    }

    public String testSmsByWebService(SmsInfo smsInfo) throws RemoteException {
        try {
            String[] destinations;
            SendEventsUtil send;
            String result;
            String stateStr;
            if (MyConstants.Customized.equals("LADIS")) {
                String chid = smsInfo.getChid();
                ConfigDao.updateValue("chid", chid);
                String delayTimes = smsInfo.getTimestamp().trim();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                long current = delayTimes == null || "".equals(delayTimes) ? System.currentTimeMillis() : System.currentTimeMillis() + Long.parseLong(smsInfo.getTimestamp()) * 1000L;
                Date dates = new Date(current);
                String Timestamp2 = sdf.format(dates);
                ConfigDao.updateValue("timestamp", smsInfo.getTimestamp());
                ConfigDao.updateValue("proxy", smsInfo.getProxy());
                ConfigDao.updateValue("proxyPort", smsInfo.getProxyPort());
                ConfigDao.updateValue("comPort", smsInfo.getComPort());
                ConfigDao.updateValue("bit", smsInfo.getBit());
                ConfigDao.updateValue("service", smsInfo.getService());
                ConfigDao.updateValue("mobileNums", smsInfo.getMobileNums());
                ConfigDao.updateValue("bit", smsInfo.getBit());
                ConfigDao.updateValue("sendtime", Timestamp2);
            }
            if ("\u77ed\u4fe1\u63d0\u4ea4\u6210\u529f".equals(stateStr = (result = (send = new SendEventsUtil()).smsServiceHandle(smsInfo, destinations = smsInfo.getMobileNums().split(","), "\u3010\u96f7\u8fea\u53f8UPS\u3011Send test successful")).substring(result.indexOf("<Result>") + 8, result.indexOf("</Result>")))) {
                return "success";
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return "failure";
    }

    public ArrayList<LocalComs> getLocalComs() throws RemoteException {
        ArrayList<LocalComs> list = null;
        try {
            list = CommConnector.getInstance().getLocalComs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public String getShowExchangeValue() throws RemoteException {
        String value = PropertiesUtils.getProperty("showExchange");
        if (value == null) {
            value = "false";
        }
        return value;
    }

    public void updateShowExchangeValue(String value) throws RemoteException {
        try {
            PropertiesUtils.updateProperty("showExchange", value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCustomer() throws RemoteException {
        String customer = MyConstants.VIEWPOWER_NAME;
        return customer;
    }

    public String getDeviceSelect() throws RemoteException {
        String customer = MyConstants.SELECT_DEVICE;
        return customer;
    }

    public String updateState(String comName, boolean remove) throws RemoteException {
        String oldValue = PropertiesUtils.getProperty("limitComs");
        String result = "";
        if (oldValue != null && !"".equals(oldValue)) {
            String[] arr = oldValue.split(",");
            ArrayList<String> list = new ArrayList<String>();
            int item = 0;
            while (item < arr.length) {
                list.add(arr[item]);
                ++item;
            }
            if (remove) {
                if (!list.contains(comName)) {
                    result = oldValue;
                } else {
                    list.remove(comName);
                    item = 0;
                    while (item < list.size()) {
                        result = String.valueOf(result) + (String)list.get(item);
                        if (item != list.size() - 1) {
                            result = String.valueOf(result) + ",";
                        }
                        ++item;
                    }
                }
            } else {
                result = list.contains(comName) ? oldValue : String.valueOf(oldValue) + "," + comName;
            }
        } else {
            result = remove ? "" : comName;
        }
        try {
            PropertiesUtils.updateProperty("limitComs", result);
            if (!remove) {
                CommConnector.getInstance().getCommProcesser(comName).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public ModBusConfig getModBusConfig(String comport) throws RemoteException {
        ModBusConfig config = new ModBusConfig();
        if (PropertiesUtils.getModBusConfig().containsKey(comport)) {
            config = PropertiesUtils.getModBusConfig().get(comport);
        }
        return config;
    }

    public void updateModBusConfig(ModBusConfig config) throws RemoteException {
        StringBuffer value = new StringBuffer();
        try {
            String oldvalue = PropertiesUtils.getGlobalConfig().getModBusComConfig();
            if (oldvalue.indexOf(config.getComPort()) >= 0) {
                String[] item = oldvalue.split(";");
                int item_i = 0;
                while (item_i < item.length) {
                    if (item[item_i].startsWith(config.getComPort())) {
                        value.append(config.toString());
                    } else {
                        value.append(item[item_i]).append(";");
                    }
                    ++item_i;
                }
            } else {
                if (oldvalue != null && !"".equals(oldvalue)) {
                    value.append(oldvalue);
                }
                value.append(config.toString());
            }
            PropertiesUtils.updateProperty("GlobalConfig.modBusComConfig", value.toString());
            PropertiesUtils.setModBusConfigs();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String applyExchangeCert(String domain) {
        try {
            InstallCert.insertCert(domain);
        }
        catch (Exception e) {
            return "failure";
        }
        return "success";
    }

    public String loadCurrentXML(String fileName) throws RemoteException {
        try {
            return EventsHandler.doDocument(fileName).asXML();
        }
        catch (Exception e) {
            throw new RemoteException();
        }
    }

    public boolean getScanComPort() throws RemoteException {
        String bool = PropertiesUtils.getProperty("notScanComport");
        if (bool == null) {
            bool = "false";
        }
        return Boolean.parseBoolean(bool);
    }

    public String setScanComPort(boolean value) throws RemoteException {
        try {
            PropertiesUtils.updateProperty("notScanComport", value ? "true" : "false");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value ? "true" : "false";
    }

    public List<Event> getEvents(String fileName) throws RemoteException {
        return EventsHandler.getEvents(fileName);
    }
}

