/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.BatteryNumber;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.RatingInfo;
import cn.com.voltronicpower.data.bean.UpsIdentity;
import cn.com.voltronicpower.data.bean.UpsInfo;
import cn.com.voltronicpower.data.dao.SSHInfoDao;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorcommunicate.UDPController;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.SearchServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.UpsTree;
import cn.com.voltronicpower.work.SearchUPSThread;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class SearchService
extends ServiceSupport
implements SearchServiceInterface {
    private static final long serialVersionUID = 1153009075533976255L;
    private static final Log logger = new Log();

    public UpsInfo getUpsInfo(String lanLabel, String computerLabel, String portName) throws RemoteException {
        try {
            if (lanLabel.equals("CURRENT")) {
                MonitorProcessor processer = null;
                try {
                    InetAddress.getByName(portName);
                    processer = CommConnector.getInstance().getProcesserMap().get(portName);
                }
                catch (UnknownHostException e) {
                    processer = CommConnector.getInstance().getCommProcesser(portName);
                }
                BuyInfo buyInfo = processer.getBuyInfo();
                UpsIdentity identity = processer.getIdentity();
                System.out.println("identity.fw" + identity.getTecnoFW());
                System.out.println("identity.fw" + identity.getTecnoModelName());
                RatingInfo ratingInfo = processer.getRatingInfo();
                BatteryNumber batteryNumber = processer.getBatteryNumber();
                UpsInfo upsInfo = new UpsInfo(String.valueOf(processer.getProtocol().getProtocolID()), identity, ratingInfo, batteryNumber, buyInfo);
                return upsInfo;
            }
            return UpsTree.getInstance().getNetworkUps(computerLabel, portName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getUpsTree() throws RemoteException {
        String result = null;
        try {
            result = UpsTree.getInstance().getUpsTreeDoc().asXML();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ArrayList<String> getInterfaces() throws RemoteException {
        List<InetAddress> addrs = SystemEnv.getInterfaces();
        ArrayList<String> ips = new ArrayList<String>(addrs.size());
        List<String> li = this.queryLan();
        for (InetAddress addr : addrs) {
            ips.add(addr.getHostAddress());
        }
        ips.addAll(li);
        return ips;
    }

    public String searchUps(String ipAddr1, String ipAddr2) throws RemoteException {
        SearchUPSThread thread = new SearchUPSThread(ipAddr1, ipAddr2);
        thread.start();
        return "success";
    }

    public String autoSearch(String ipAddr) throws RemoteException {
        String[] ips;
        String[] stringArray = ips = ipAddr.split(",");
        int n = ips.length;
        int n2 = 0;
        while (n2 < n) {
            block14: {
                block12: {
                    SearchUPSThread thread;
                    Matcher mat;
                    Pattern pat;
                    String regex;
                    String ip;
                    block13: {
                        block11: {
                            ip = stringArray[n2];
                            System.out.println("auto:" + ip);
                            if (!SystemEnv.isLan(ip)) break block11;
                            UDPController.startSearch(ip);
                            break block12;
                        }
                        if (ip.split("\\.").length != 4) break block13;
                        regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
                        pat = Pattern.compile(regex);
                        mat = pat.matcher(ip);
                        if (mat.matches()) {
                            thread = new SearchUPSThread(ip, ip);
                            thread.start();
                        }
                        break block12;
                    }
                    if (ip.split("\\.").length != 3) break block14;
                    regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){2}";
                    pat = Pattern.compile(regex);
                    mat = pat.matcher(ip);
                    if (mat.matches()) {
                        thread = new SearchUPSThread(String.valueOf(ip) + ".1", String.valueOf(ip) + ".254");
                        thread.start();
                    }
                }
                try {
                    Thread.sleep(4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return "success";
    }

    public String PeriodSearch(String s) throws RemoteException {
        if (s.equals("get")) {
            String searchPeriod = Config.getString("searchPeriod");
            return searchPeriod;
        }
        Config.updateProperty("searchPeriod", s);
        Config.refreashProperties();
        return s;
    }

    public static void main(String[] args) throws RemoteException {
        String ipAddr1 = "192.168.0";
        SearchService sss = new SearchService();
        sss.addLan(ipAddr1);
        SearchService service = new SearchService();
        Element computerEle = service.searchRemoteUps(ipAddr1);
    }

    public Element searchRemoteUps(String ipAddr) throws RemoteException {
        URL url = null;
        HttpURLConnection conn = null;
        Element element = null;
        String http = Config.getBoolean("useHttps") ? "https" : "http";
        try {
            int c;
            String localIP = InetAddress.getLocalHost().getHostName();
            url = new URL(String.valueOf(http) + "://" + ipAddr + ":" + MyConstants.SERVER_PORT + "/" + MyConstants.VIEWPOWER_NAME + "/SearchServlet?localIP=" + localIP + "&destIP=" + ipAddr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setReadTimeout(3000);
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setRequestProperty("Cache-Control", "no-cache");
            OutputStream buf = conn.getOutputStream();
            buf = new BufferedOutputStream(buf);
            OutputStreamWriter out = new OutputStreamWriter(buf);
            String ddd = "name=fdsafdsa&fddd=fdsafds";
            out.write(ddd);
            out.flush();
            out.close();
            InputStream in = conn.getInputStream();
            InputStreamReader rData = new InputStreamReader(in);
            StringBuilder sb = new StringBuilder();
            while ((c = ((Reader)rData).read()) != -1) {
                sb.append((char)c);
            }
            String node = sb.toString();
            System.out.println("node:" + node);
            Document document = DocumentHelper.parseText((String)node);
            element = document.getRootElement();
            in.close();
        }
        catch (Exception e) {
            logger.debug(e.toString());
        }
        return element;
    }

    public String getLocalUpsInfoXML() throws RemoteException {
        try {
            String xml = CommConnector.getInstance().getLocalUpsInfoXML().asXML();
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getLocalUpsInfoXML(String arg0) throws RemoteException {
        try {
            String xml = CommConnector.getInstance().getLocalUpsInfoXML(arg0).asXML();
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public List<String> queryLan() {
        List<String> list = null;
        SSHInfoDao dao = new SSHInfoDao();
        list = dao.queryLan();
        return list;
    }

    public boolean addLan(String lan) {
        if (lan.split("\\.").length == 4) {
            String regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
            Pattern pat = Pattern.compile(regex);
            Matcher mat = pat.matcher(lan);
            if (mat.matches()) {
                SSHInfoDao dao = new SSHInfoDao();
                return dao.addLan(lan);
            }
            return false;
        }
        if (lan.split("\\.").length == 3) {
            String regex = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){2}";
            Pattern pat = Pattern.compile(regex);
            Matcher mat = pat.matcher(lan);
            if (mat.matches()) {
                SSHInfoDao dao = new SSHInfoDao();
                return dao.addLan(lan);
            }
            return false;
        }
        return false;
    }

    public boolean delLan(String lan) {
        SSHInfoDao dao = new SSHInfoDao();
        return dao.delLan(lan);
    }
}

