/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.CapabilityTaurus;
import cn.com.voltronicpower.data.bean.MonitorData;
import cn.com.voltronicpower.data.bean.RatingInfo;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.protocol.P01;
import cn.com.voltronicpower.monitor.protocol.P010203;
import cn.com.voltronicpower.monitor.protocol.PMV;
import cn.com.voltronicpower.monitor.protocol.PMV_Simplify;
import cn.com.voltronicpower.monitorcommunicate.CommConnector;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.MonitorServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class MonitorService
extends ServiceSupport
implements MonitorServiceInterface {
    private static final long serialVersionUID = 4297697416782266161L;
    private static final Log logger = new Log();

    private MonitorData getNewMoniterData() {
        MonitorData data = new MonitorData();
        Object p = new P01();
        if (MyConstants.Customized.equals("ZTE")) {
            p = new PMV();
        }
        data.setStatuspowerflow(p.getStatusPowerFlow());
        data.setStatusupsinfo(p.getStatusUPSInfo());
        data.setEventFileName(p.getEventFileName());
        data.setHistoryColumns(p.getHistoryColumns());
        data.setWebMapping(p.getWebMapping());
        data.setWorkInfo(new WorkInfo());
        data.setMenuList(p.getMenuList());
        data.setCustomerLogo(Config.getString("customerLogo"));
        data.setServerName(Config.getString("servername"));
        data.setSelectDevice(Config.getString("DeviceSelect"));
        data.setCustomerViewpower(MyConstants.VIEWPOWER_NAME);
        data.setCustomer(MyConstants.SERVER_NAME);
        data.setVersion(Config.getString("version"));
        data.setCustomized(MyConstants.Customized);
        data.setSupportBatNum(true);
        data.setModules(null);
        return data;
    }

    public MonitorData getMonitorData(String portName) throws RemoteException {
        MonitorData data;
        block22: {
            data = this.getNewMoniterData();
            try {
                String strIP = PropertiesUtils.getProperty("upsTreeIpAddress");
                if (strIP == null) {
                    strIP = "";
                }
                if (!SystemEnv.oldIPAddress.equalsIgnoreCase(strIP)) {
                    SystemEnv.refreshTree = MyConstants.getRefreshTree();
                    SystemEnv.oldIPAddress = strIP;
                }
                data.setRefreshTree(SystemEnv.refreshTree);
                data.setRefreshSearchingUPS(SystemEnv.refreshSearchingUPS);
                data.setRefreshSearchUPSTree(SystemEnv.refreshSearchUPSTree);
                MonitorProcessor processer = null;
                if (portName == null || "".equals(portName)) {
                    if (CommConnector.getInstance().getProcesserMap().size() > 0) {
                        for (Map.Entry<String, MonitorProcessor> entry : CommConnector.getInstance().getProcesserMap().entrySet()) {
                            if (processer != null) continue;
                            processer = entry.getValue();
                            break;
                        }
                    }
                } else {
                    processer = this.getMoniotrProcesser(portName);
                }
                data.setVersion(Config.getString("version"));
                if (processer == null) break block22;
                IProtocol protocol = processer.getProtocol();
                String io = processer.getIdentity().getIoPhase();
                if (protocol instanceof P010203) {
                    P010203 prot = (P010203)protocol;
                    prot.setIophase(io);
                } else if (protocol instanceof PMV_Simplify) {
                    String PorT = processer.getIdentity().getManufacturer();
                    PMV_Simplify prot = (PMV_Simplify)protocol;
                    ((PMV)prot).setProtocolPMV(PorT);
                }
                data.setProtocolType(String.valueOf(protocol.getProtocolID()));
                data.setCustomerLogo(Config.getString("customerLogo"));
                data.setCustomerViewpower(MyConstants.VIEWPOWER_NAME);
                data.setCustomer(MyConstants.SERVER_NAME);
                data.setCustomized(MyConstants.Customized);
                data.setServerName(Config.getString("servername"));
                data.setSelectDevice(Config.getString("DeviceSelect"));
                data.setHostName(SystemEnv.getLocalHostName());
                data.setPortName(processer.getDeviceName());
                data.setShowLocalUPS(Config.getBoolean("showLocalUPS"));
                data.setShowNetSNMP(false);
                data.setSnmp(false);
                data.setStatusupsinfo(protocol.getStatusUPSInfo());
                data.setMenuList(protocol.getMenuList());
                data.setStatuspowerflow(protocol.getStatusPowerFlow());
                data.setModules(protocol.getModulesInfo());
                RatingInfo ratingInfo = processer.getRatingInfo();
                float outputRatingVoltage = 220.0f;
                try {
                    outputRatingVoltage = Float.parseFloat(ratingInfo.getOutputRatingVoltage());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String id = String.valueOf(protocol.getProtocolID());
                WorkInfo workInfo = processer.getWorkInfo();
                workInfo.setOutputRatingVoltage(outputRatingVoltage);
                if (id != null && !"".equals(id)) {
                    if ("MODBUS".equals(id)) {
                        MyConstants.doTemperatureTaurus(workInfo, id);
                    } else {
                        MyConstants.doTemperature(workInfo);
                    }
                }
                try {
                    data.setCapability(processer.getCapability());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                workInfo.setCurrentTime(new Date());
                data.setWorkInfo(workInfo);
                if ("MODBUS".equals(id)) {
                    try {
                        CapabilityTaurus capModbus = (CapabilityTaurus)processer.getCapability();
                        data.setCapability((Capability)capModbus);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                protocol.formatMonitorData((Object)data);
                data.setSupportBatNum(processer.isSupportBatNum());
                data.setSnmpInfo(processer.getSnmpInfo());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public ArrayList<String> getConnectedPorts() throws RemoteException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            result.addAll(CommConnector.getInstance().getProcesserMap().keySet());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String testRMI() throws RemoteException {
        return "RMI_OK";
    }
}

