/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.communicate.IProtocol;
import cn.com.voltronicpower.data.bean.EventInfo;
import cn.com.voltronicpower.data.bean.EventStatis;
import cn.com.voltronicpower.data.bean.HistoryDataColumns;
import cn.com.voltronicpower.data.bean.HistoryMonitorColumns;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.data.dao.EventDao;
import cn.com.voltronicpower.data.dao.WorkDataDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.rmiInterface.HistoryServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class HistoryService
extends ServiceSupport
implements HistoryServiceInterface {
    private static final long serialVersionUID = 4164415192656203910L;
    private static final Log logger = new Log();

    public ArrayList<String> getLogComs() throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<String> list = workDataDao.getLogPorts();
        return list;
    }

    public ArrayList<String> getLogPtidsByCom(String com) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<String> ptids = workDataDao.getLogPtidsByCom(com);
        for (String ptid : ptids) {
            logger.info("  ptid-- history service--" + ptid);
        }
        return ptids;
    }

    public HistoryMonitorColumns getMonitorColumns(String portName, String protocolID) throws RemoteException {
        HistoryMonitorColumns columns = null;
        try {
            String io = this.getIOphase(portName, protocolID);
            IProtocol protocol = this.getProtocol(portName, protocolID, io);
            columns = protocol.getHistoryMonitorColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public HistoryMonitorColumns getMonitorColumns(String portName, String protocolID, String iophase) throws RemoteException {
        HistoryMonitorColumns columns = null;
        try {
            columns = this.getProtocol(portName, protocolID, iophase).getHistoryMonitorColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public HistoryDataColumns getColumns(String portName, String protocolID) throws RemoteException {
        HistoryDataColumns columns = null;
        try {
            String io = this.getIOphase(portName, protocolID);
            IProtocol protocol = this.getProtocol(portName, protocolID, io);
            columns = protocol.getHistoryColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public String getIOphase(String portName, String protocolID) {
        WorkDataDao workDataDao = new WorkDataDao();
        String io = workDataDao.getIO(protocolID, portName);
        if (io == null || io.trim().equals("")) {
            io = "1/1";
        }
        return io;
    }

    public HistoryDataColumns getColumns(String portName, String protocolID, String iophase) throws RemoteException {
        HistoryDataColumns columns = null;
        try {
            IProtocol protocol = this.getProtocol(portName, protocolID, iophase);
            columns = protocol.getHistoryColumns();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columns;
    }

    public ArrayList<WorkInfo> queryCommLogs(Date startDate, Date endDate, String portName, String ptid) throws RemoteException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(6, 1);
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> list = workDataDao.getWorkDatasByPtid(startDate, ca.getTime(), portName, ptid);
        return list;
    }

    public ArrayList<WorkInfo> queryCommLogs_SN(Date startDate, Date endDate, String portName, String ptid, String sn) throws RemoteException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(6, 1);
        WorkDataDao workDao = new WorkDataDao();
        return workDao.getWorkDatasByPtid_SN(startDate, ca.getTime(), portName, ptid, sn);
    }

    public ArrayList<WorkInfo> queryWorkYearChart(int year, String portName, String ptid) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByYear(year, portName, ptid);
        Calendar ca = Calendar.getInstance();
        int month = -1;
        int i = 0;
        while (i < works.size()) {
            ca.setTime(works.get(i).getCurrentTime());
            if (ca.get(2) > month && i % 2 == 0) {
                works.get(i).setShowLabel(true);
                month = ca.get(2);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkYearChart_SN(int year, String portName, String ptid, String sn) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByYear_SN(year, portName, ptid, sn);
        Calendar ca = Calendar.getInstance();
        int month = -1;
        int i = 0;
        while (i < works.size()) {
            ca.setTime(works.get(i).getCurrentTime());
            if (ca.get(2) > month && i % 2 == 0) {
                works.get(i).setShowLabel(true);
                month = ca.get(2);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkMonthChart(int year, int month, String portName, String ptid) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByMonth(year, month, portName, ptid);
        int i = 0;
        while (i < works.size()) {
            if (i % 4 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkMonthChart_SN(int year, int month, String portName, String ptid, String sn) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByMonth_SN(year, month, portName, ptid, sn);
        int i = 0;
        while (i < works.size()) {
            if (i % 4 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkDayChart(Date queryDate, String portName, String ptid) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByDay(queryDate, portName, ptid);
        int i = 0;
        while (i < works.size()) {
            if (i % 4 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkDayChart_SN(Date queryDate, String portName, String ptid, String sn) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByDay_SN(queryDate, portName, ptid, sn);
        int i = 0;
        while (i < works.size()) {
            if (i % 4 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkHourChart(Date queryDate, int hour, String portName, String ptid) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByHour(queryDate, hour, portName, ptid);
        int i = 0;
        while (i < works.size()) {
            if (i % 2 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public ArrayList<WorkInfo> queryWorkHourChart_SN(Date queryDate, int hour, String portName, String ptid, String sn) throws RemoteException {
        WorkDataDao workDataDao = new WorkDataDao();
        ArrayList<WorkInfo> works = workDataDao.getWorkDatasByHour_SN(queryDate, hour, portName, ptid, sn);
        int i = 0;
        while (i < works.size()) {
            if (i % 2 == 0) {
                works.get(i).setShowLabel(true);
            }
            ++i;
        }
        return works;
    }

    public String removeWorkData(int workId) {
        WorkDataDao workDataDao = new WorkDataDao();
        workDataDao.removeWork(workId);
        return "success";
    }

    public String removeAllWorkDatas(List<WorkInfo> works) {
        WorkDataDao workDataDao = new WorkDataDao();
        if (works != null) {
            for (WorkInfo work : works) {
                workDataDao.removeWork(work.getWorkId());
            }
        }
        return "success";
    }

    public ArrayList<EventStatis> queryPortEventStatis(Date startADate, Date endADate, Date startBDate, Date endBDate, String port, String ptid) throws RemoteException {
        Calendar endACa = Calendar.getInstance();
        endACa.setTime(endADate);
        endACa.add(6, 1);
        Calendar endBCa = Calendar.getInstance();
        endBCa.setTime(endBDate);
        endBCa.add(6, 1);
        ArrayList<EventStatis> result = new ArrayList<EventStatis>();
        result.addAll(EventsHandler.getEventPeriodStatis(startADate, endACa.getTime(), startBDate, endBCa.getTime(), port, ptid, null));
        return result;
    }

    public ArrayList<EventInfo> queryPortEvents(Date startDate, Date endDate, String port, String ptid) throws RemoteException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(6, 1);
        ArrayList<EventInfo> events = EventsHandler.queryPortEvents(startDate, ca.getTime(), port, ptid, null);
        return events;
    }

    public ArrayList<EventStatis> queryPortEventStatis_SN(Date startADate, Date endADate, Date startBDate, Date endBDate, String port, String ptid, String sn) throws RemoteException {
        Calendar endACa = Calendar.getInstance();
        endACa.setTime(endADate);
        endACa.add(6, 1);
        Calendar endBCa = Calendar.getInstance();
        endBCa.setTime(endBDate);
        endBCa.add(6, 1);
        ArrayList<EventStatis> result = new ArrayList<EventStatis>();
        result.addAll(EventsHandler.getEventPeriodStatis(startADate, endACa.getTime(), startBDate, endBCa.getTime(), port, ptid, sn));
        return result;
    }

    public ArrayList<EventInfo> queryPortEvents_SN(Date startDate, Date endDate, String port, String ptid, String sn) throws RemoteException {
        Calendar ca = Calendar.getInstance();
        ca.setTime(endDate);
        ca.add(6, 1);
        ArrayList<EventInfo> events = EventsHandler.queryPortEvents(startDate, ca.getTime(), port, ptid, sn);
        return events;
    }

    public ArrayList<String> getEventPorts() throws RemoteException {
        EventDao eventDao = new EventDao();
        return eventDao.getEventPorts();
    }

    public ArrayList<String> getEventPtidsByCom(String com) throws RemoteException {
        EventDao eventDao = new EventDao();
        return eventDao.getEventPtidsByCom(com);
    }

    public String removeEvent(int recordId) throws RemoteException {
        EventDao eventDao = new EventDao();
        eventDao.removeEventRecord(recordId);
        return "success";
    }

    public String removeAllEvents(List<EventInfo> events) throws RemoteException {
        EventDao eventDao = new EventDao();
        if (events != null) {
            for (EventInfo event : events) {
                eventDao.removeEventRecord(event.getRecordId());
            }
        }
        return "success";
    }

    public ArrayList<String> getEventSNByPortPID(String port, String pid) throws RemoteException {
        EventDao eventDao = new EventDao();
        return eventDao.getEventSNByPortPID(port, pid);
    }

    public ArrayList<String> getLogSNByPtid(String com, String ptid) throws RemoteException {
        WorkDataDao workDao = new WorkDataDao();
        return workDao.getLogSNByPtid(com, ptid);
    }

    public String getDateFormat() throws RemoteException {
        String date = PropertiesUtils.getProperty("GlobalConfig.dateFormat");
        date = date.equals("YYYY-MM-DD") ? "yyyy-MM-dd HH:mm:ss" : (date.equals("YYYY/MM/DD") ? "yyyy/MM/dd HH:mm:ss" : (date.equals("YYYY:MM:DD") ? "yyyy:MM:dd HH:mm:ss" : (date.equals("MM-DD-YYYY") ? "MM-dd-yyyy HH:mm:ss" : (date.equals("MM/DD/YYYY") ? "MM/dd/yyyy HH:mm:ss" : (date.equals("MM:DD:YYYY") ? "MM:dd:yyyy HH:mm:ss" : (date.equals("DD-MM-YYYY") ? "dd-MM-yyyy HH:mm:ss" : (date.equals("DD/MM/YYYY") ? "dd/MM/yyyy HH:mm:ss" : (date.equals("DD:MM:YYYY") ? "dd:MM:yyyy HH:mm:ss" : "yyyy-MM-dd HH:mm:ss"))))))));
        return date;
    }

    public boolean removeCommLogs(Date startDate, Date endDate, String port, String ptid, String sn) throws RemoteException {
        System.out.println("----------delAlldata----1---:" + startDate + "," + endDate + "," + port + "," + ptid);
        try {
            WorkDataDao workDataDao = new WorkDataDao();
            workDataDao.removeWorkDataAll(startDate, endDate, port, ptid, sn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean removeEvents(Date startDate, Date endDate, String port, String ptid, String sn) throws RemoteException {
        try {
            EventDao dao = new EventDao();
            dao.removeAllEventRecord(startDate, endDate, port, ptid, sn);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

