/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronic.socket.SystemTrayUDPClient;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.GlobalConfig;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.GlobalServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.rmi.RemoteException;

public class GlobalService
extends ServiceSupport
implements GlobalServiceInterface {
    private static final long serialVersionUID = -1817071345263170461L;

    public GlobalConfig getGlobalConfig(String loginRandom) throws RemoteException {
        GlobalConfig config = null;
        try {
            config = PropertiesUtils.getGlobalConfig();
            config.setLocalAddr(SystemEnv.getLocalHostAddress());
            config.setServerPort(MyConstants.SERVER_PORT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public GlobalConfig refreshGlobalConfig() throws RemoteException {
        try {
            PropertiesUtils.wrapProperties(PropertiesUtils.getGlobalConfig());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return PropertiesUtils.getGlobalConfig();
    }

    public String setTemperature(String temperature) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setTemperature(temperature);
            PropertiesUtils.updateProperty("GlobalConfig.temperature", temperature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setLanguage(String language) throws RemoteException {
        GlobalConfig config = PropertiesUtils.getGlobalConfig();
        config.setLanguage(language);
        try {
            PropertiesUtils.updateProperty("GlobalConfig.language", language);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try (SystemTrayUDPClient client = null;){
            try {
                client = new SystemTrayUDPClient("localhost", 33654);
                String languageStr = "(language:" + language;
                client.send(languageStr.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                if (client != null) {
                    client.close();
                }
            }
        }
        return language;
    }

    public String setDateFormat(String dateFormat) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setDateFormat(dateFormat);
            PropertiesUtils.updateProperty("GlobalConfig.dateFormat", dateFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setTheme(String theme) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setTheme(theme);
            PropertiesUtils.updateProperty("GlobalConfig.theme", theme);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setDataAnalysisInterval(int interval) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setDataAnalysisInterval(interval);
            PropertiesUtils.updateProperty("GlobalConfig.dataAnalysisInterval", String.valueOf(interval));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setDataRecordInterval2(int interval) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setDataRecordInterval(interval);
            PropertiesUtils.updateProperty("GlobalConfig.dataRecordInterval", String.valueOf(interval));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setDataRecordInterval(int dataLimit) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setDataLimit(dataLimit);
            PropertiesUtils.updateProperty("GlobalConfig.dataLimit", String.valueOf(dataLimit));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public String setEventLimit(int eventLimit) throws RemoteException {
        try {
            GlobalConfig config = PropertiesUtils.getGlobalConfig();
            config.setEventLimit(eventLimit);
            PropertiesUtils.updateProperty("GlobalConfig.eventLimit", String.valueOf(eventLimit));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    public GlobalConfig getGlobalConfig() {
        GlobalConfig config = null;
        try {
            PropertiesUtils.wrapProperties(PropertiesUtils.getGlobalConfig());
            config = PropertiesUtils.getGlobalConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }
}

