/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.data.bean.CapabilityTaurus;
import cn.com.voltronicpower.data.bean.PowerPlan;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.bean.TestPlan;
import cn.com.voltronicpower.data.dao.BatteryTestPlanDao;
import cn.com.voltronicpower.data.dao.PowerPlanDao;
import cn.com.voltronicpower.exception.EventsHandler;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.processor.P71Processor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.ControlServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import cn.com.voltronicpower.work.BatteryTestEndHandler;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class ControlService
extends ServiceSupport
implements ControlServiceInterface {
    private static final long serialVersionUID = 7606803474099475675L;

    public String onSwitchCtrl(String portName) throws RemoteException {
        try {
            String returnData;
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && "(ACK".equalsIgnoreCase(returnData = processer.onSwitchCtrlOntime())) {
                EventsHandler.handleEvent(processer.getDeviceName(), "6004", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                return "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String offSwitchCtrl(String portName) throws RemoteException {
        try {
            String returnData;
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && "(ACK".equalsIgnoreCase(returnData = processer.offSwitchCtrlOntime())) {
                EventsHandler.handleEvent(processer.getDeviceName(), "6003", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                return "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String rectifierInverterCtrl(String portName, int unit) throws RemoteException {
        try {
            String returnData;
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && "success".equalsIgnoreCase(returnData = processer.rectifierInverterCtrl(unit))) {
                return String.valueOf(unit) + "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(unit) + "failure";
    }

    public String cancelSwitchCtrl(String portName) throws RemoteException {
        String returnData = "";
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                returnData = processer.cancelSwitchCtrl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String onBuzzerCtrl(String portName) throws RemoteException {
        String returnData = "";
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                returnData = this.getMoniotrProcesser(portName).onBuzzerCtrl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String offBuzzerCtrl(String portName) throws RemoteException {
        String returnData = "";
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                returnData = this.getMoniotrProcesser(portName).offBuzzerCtrl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String tenSencondsBatteryTestCtrl(String portName) throws RemoteException {
        block4: {
            MonitorProcessor processer;
            String returnData;
            block5: {
                returnData = "";
                processer = this.getMoniotrProcesser(portName);
                if (processer == null) break block4;
                if (!MyConstants.TAURUS_MODBUS.equalsIgnoreCase(processer.getProtocol().getProtocolID())) break block5;
                return "success";
            }
            try {
                returnData = processer.tenSencondsBatteryTestCtrl();
                if ("(ACK".equalsIgnoreCase(returnData)) {
                    EventsHandler.handleEvent(processer.getDeviceName(), "4009", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                    BatteryTestEndHandler.putBatteryTestEvent("4009");
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }

    public void checkBatteryTestResult(String portName) throws RemoteException {
        try {
            Thread.sleep(5000L);
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                CapabilityTaurus capability = (CapabilityTaurus)processer.getCapability();
                if (!capability.isCapable26b0()) {
                    EventsHandler.trayClient("Battery test", portName, "Success", "001");
                } else {
                    EventsHandler.trayClient("Battery test", portName, "Failure", "002");
                }
            } else {
                EventsHandler.trayClient("Battery test", portName, "Failure", "002");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String munitesBatteryTestCtrl(String portName, float minute) throws RemoteException {
        try {
            String returnData;
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && "(ACK".equalsIgnoreCase(returnData = processer.munitesBatteryTestCtrl(minute))) {
                EventsHandler.handleEvent(processer.getDeviceName(), "4009", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                BatteryTestEndHandler.putBatteryTestEvent("4009");
                return "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String deepBatteryTestCtrl(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                String returnData = processer.deepBatteryTestCtrl();
                if ("(ACK".equalsIgnoreCase(returnData)) {
                    if (processer instanceof P71Processor && ((P71Processor)processer).getCustomeName().equals("HUAWEI")) {
                        ((P71Processor)processer).setFirstTest(true);
                    }
                    EventsHandler.handleEvent(processer.getDeviceName(), "4009", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                    BatteryTestEndHandler.putBatteryTestEvent("4009");
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }

    public boolean getDual(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        boolean isDual = false;
        if (processer != null) {
            isDual = processer.queryWorkInfo().isDual();
        }
        return isDual;
    }

    public String cancelBatteryTestCtrl(String portName) throws RemoteException {
        block4: {
            MonitorProcessor processer;
            block5: {
                processer = this.getMoniotrProcesser(portName);
                if (processer == null) break block4;
                if (!MyConstants.TAURUS_MODBUS.equalsIgnoreCase(processer.getProtocol().getProtocolID())) break block5;
                processer.excuteCommand(93, (short)0);
                return "success";
            }
            try {
                String returnData = processer.cancelBatteryTest();
                if ("(ACK".equalsIgnoreCase(returnData)) {
                    EventsHandler.handleEvent(processer.getDeviceName(), "4010", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                    BatteryTestEndHandler.clearTest();
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }

    public String onOutletCtrl(String portName, final String group, int delayMinute) throws RemoteException {
        String returnData = "(ACK";
        final MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer == null) {
            return "failure";
        }
        if (delayMinute > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        processer.onOutletCtrl(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delayMinute * 60000);
        } else {
            try {
                returnData = processer.onOutletCtrl(group);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String offOutletCtrl(String portName, final String group, int delayMinute) throws RemoteException {
        String returnData = "(ACK";
        final MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer == null) {
            return "failure";
        }
        if (delayMinute > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        processer.offOutletCtrl(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delayMinute * 60000);
        } else {
            try {
                returnData = processer.offOutletCtrl(group);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public PowerPlan addPowerPlan(PowerPlan plan) throws RemoteException {
        block4: {
            try {
                Shutdownconfigure shutdown;
                Calendar timeCa = Calendar.getInstance();
                timeCa.setTime(plan.getOffTime());
                timeCa.set(13, 0);
                plan.setOffTime(timeCa.getTime());
                if (!plan.getCycle().equals("once") || !(shutdown = PropertiesUtils.getShutdownconfigure()).isPlanShutdown()) break block4;
                Calendar dayCa = Calendar.getInstance();
                dayCa.setTime(plan.getOffDate());
                timeCa.set(dayCa.get(1), dayCa.get(2), dayCa.get(5));
                long needtime = shutdown.getShutdownTimeMillis();
                if (shutdown.getExcuteProgram() != null && !shutdown.getExcuteProgram().equals("")) {
                    needtime += shutdown.getExcuteProgramTimeMillis();
                }
                if (timeCa.getTimeInMillis() - System.currentTimeMillis() >= needtime) break block4;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Calendar ca1 = Calendar.getInstance();
        ca1.setTime(plan.getOnTime());
        ca1.set(13, 0);
        plan.setOnTime(ca1.getTime());
        PowerPlanDao planDao = new PowerPlanDao();
        return planDao.addPowerPlan(plan);
    }

    public int removePowerPlan(int planId) throws RemoteException {
        PowerPlanDao planDao = new PowerPlanDao();
        planDao.removePowerPlan(planId);
        return planId;
    }

    public ArrayList<PowerPlan> getPowerPlans() throws RemoteException {
        PowerPlanDao planDao = new PowerPlanDao();
        ArrayList<PowerPlan> plans = planDao.getPowerPlans();
        return plans;
    }

    public TestPlan addTestPlan(TestPlan plan) throws RemoteException {
        try {
            Calendar ca = Calendar.getInstance();
            ca.setTime(plan.getPlanTime());
            ca.set(13, 0);
            plan.setPlanTime(ca.getTime());
            BatteryTestPlanDao planDao = new BatteryTestPlanDao();
            return planDao.addBatteryTestPlan(plan);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int removeTestPlan(int planId) throws RemoteException {
        try {
            BatteryTestPlanDao planDao = new BatteryTestPlanDao();
            planDao.removeBatteryTestPlan(planId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return planId;
    }

    public ArrayList<TestPlan> getTestPlans() throws RemoteException {
        BatteryTestPlanDao planDao = new BatteryTestPlanDao();
        return planDao.getBatteryTestPlans();
    }

    public String turnToBypass(String portName) throws RemoteException {
        try {
            String returnData;
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && "(ACK".equalsIgnoreCase(returnData = processer.turnToBypass())) {
                EventsHandler.handleEvent(processer.getDeviceName(), "2001", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                return "success";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String getQSKT(String portName, String group) throws RemoteException {
        String returnData = "(NAK";
        char[] arr = group.toCharArray();
        String ret = "";
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        try {
            int i = 0;
            while (i < arr.length) {
                returnData = processer.excuteCommand("QSKT" + arr[i], true);
                int s = "(NAK".equalsIgnoreCase(returnData) ? 1 : 0;
                ret = String.valueOf(ret) + s;
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String onOutletCtrl2(String portName, final String group, int delayMinute) throws RemoteException {
        String returnData = "(ACK";
        final MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer == null) {
            return "failure";
        }
        if (delayMinute > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        processer.onOutletCtrl(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delayMinute * 60000);
        } else {
            try {
                returnData = processer.onOutletCtrl(group);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String offOutletCtrl2(String portName, final String group, int delayMinute) throws RemoteException {
        String returnData = "(ACK";
        final MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer == null) {
            return "failure";
        }
        if (delayMinute > 0) {
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        processer.offOutletCtrl(group);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }, delayMinute * 60000);
        } else {
            try {
                returnData = processer.offOutletCtrl(group);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "(ACK".equalsIgnoreCase(returnData) ? "success" : "failure";
    }

    public String controlNew(String port, String cmd, String value) throws RemoteException {
        MonitorProcessor processer;
        if (cmd.equals("deepTestStart:record") && (processer = this.getMoniotrProcesser(port)) != null) {
            try {
                String returnData = processer.deepBatteryTestCtrl();
                if ("(ACK".equalsIgnoreCase(returnData)) {
                    if (processer.getStartTime().equals("")) {
                        processer.setStartTimeAndPort(String.valueOf(new Date().getTime()), port);
                    }
                    EventsHandler.handleEvent(processer.getDeviceName(), "4009", processer.getProtocol().getProtocolID(), processer.getDeviceId(), false);
                    BatteryTestEndHandler.putBatteryTestEvent("4009");
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

