/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.rmiclass;

import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.data.bean.BatLowVoltage;
import cn.com.voltronicpower.data.bean.BatteryNumber;
import cn.com.voltronicpower.data.bean.BuyInfo;
import cn.com.voltronicpower.data.bean.Bypass;
import cn.com.voltronicpower.data.bean.Capability;
import cn.com.voltronicpower.data.bean.CapabilityTaurus;
import cn.com.voltronicpower.data.bean.HighEfficiencyVoltage;
import cn.com.voltronicpower.data.bean.LineVoltage;
import cn.com.voltronicpower.data.bean.ParameterSettings;
import cn.com.voltronicpower.data.bean.PhaseAngle;
import cn.com.voltronicpower.data.bean.RemoteShutdown;
import cn.com.voltronicpower.data.bean.SSHInfo;
import cn.com.voltronicpower.data.bean.Shutdownconfigure;
import cn.com.voltronicpower.data.dao.BatteryWarnDao;
import cn.com.voltronicpower.data.dao.ConfigDao;
import cn.com.voltronicpower.data.dao.SSHInfoDao;
import cn.com.voltronicpower.monitor.MonitorProcessor;
import cn.com.voltronicpower.monitor.processor.PMV_JProcessor;
import cn.com.voltronicpower.monitor.processor.TaurusProcessor;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.rmiInterface.ConfigServiceInterface;
import cn.com.voltronicpower.rmiclass.ServiceSupport;
import cn.com.voltronicpower.utilities.AES128CBC;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ConfigService
extends ServiceSupport
implements ConfigServiceInterface {
    private static final long serialVersionUID = -9033525471527756814L;
    private static final Log log = new Log();

    public String setCapability(String portName, String x, boolean isEnable) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setCapability(x, isEnable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure," + x;
    }

    public static void main(String[] args) {
        log.info("hello");
    }

    public String setCapabilityTaurus(String portName, int address) throws RemoteException {
        String result = "failure," + address;
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            String returnData = processor.excuteCommand(address, (short)0);
            if ("success".equalsIgnoreCase(returnData)) {
                result = "success," + address;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String setBypassLowVoltage(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBypassLowVoltage(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBypassHighVoltage(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBypassHighVoltage(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBypassLowFrequency(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBypassLowFrequency(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBypassHighFrequency(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBypassHighFrequency(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatn(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatn(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatgn(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatgn(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setHeh(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setHeh(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setHel(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setHel(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPPD(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPPD(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setFreh(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setFreh(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setFrel(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setFrel(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setOutputSocketDelayTime(String portName, String outlet, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setOutputSocketDelayTime(outlet, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public BuyInfo getBuyInfo(String portName) throws RemoteException {
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                return processer.getBuyInfo();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean getBuzzerCtrl(String portName) throws RemoteException {
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                return processer.getWorkInfo().isBuzzerCtrl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public Capability getCapability(String portName) throws RemoteException {
        Capability capability = null;
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null) {
                capability = processer.getCapability();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capability;
    }

    public CapabilityTaurus getCapabilityTaurus(String portName) throws RemoteException {
        CapabilityTaurus capabilityTaurus = null;
        try {
            MonitorProcessor processer = this.getMoniotrProcesser(portName);
            if (processer != null && processer instanceof TaurusProcessor) {
                capabilityTaurus = (CapabilityTaurus)processer.getCapability();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capabilityTaurus;
    }

    public int getOutputSocketDelayTime(String portName, String socketNum) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null && !processer.getProtocol().getProtocolID().equals("P33") && !processer.getProtocol().getProtocolID().equals("P44")) {
            try {
                return processer.getOutputSocketDelayTime(socketNum);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public BatteryNumber getBatteryNumber(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getBatteryNumber();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Bypass getBypass(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getBypass();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public HighEfficiencyVoltage getHighEfficiencyVoltage(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getHighEfficiencyVoltage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public PhaseAngle getPPD(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getPPD();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Shutdownconfigure getShutdown() throws RemoteException {
        try {
            return PropertiesUtils.getShutdownconfigure();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Shutdownconfigure defaultShutdown() throws RemoteException {
        Shutdownconfigure defaultShutdown = new Shutdownconfigure();
        try {
            Shutdownconfigure shutdown = PropertiesUtils.getShutdownconfigure();
            defaultShutdown.setRemoteAddrs(shutdown.getRemoteAddrs());
            defaultShutdown.setBatModeShutdown(true);
            if ("NetGuard".equals(MyConstants.Customized)) {
                defaultShutdown.setLowBatShutdown(true);
                defaultShutdown.setLowBatShutdownUPS(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultShutdown;
    }

    public RemoteShutdown getRemoteShutdown() throws RemoteException {
        RemoteShutdown shutdown = new RemoteShutdown();
        try {
            PropertiesUtils.wrapProperties(shutdown);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shutdown;
    }

    public List<SSHInfo> getSSHInfos() throws RemoteException {
        SSHInfoDao dao = new SSHInfoDao();
        return dao.showSSHInfos();
    }

    public Shutdownconfigure setShutdown(Shutdownconfigure shutdown) throws RemoteException {
        try {
            PropertiesUtils.updateProperties(shutdown);
            PropertiesUtils.setShutdownconfigure(shutdown);
            if (shutdown.isBatCapacityShutdown()) {
                PropertiesUtils.updateProperty("RemoteShutdown.batteryMode", "false");
            } else {
                PropertiesUtils.updateProperty("RemoteShutdown.batteryLowLevel", "false");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shutdown;
    }

    public RemoteShutdown setRemoteShutdown(RemoteShutdown shutdown) throws RemoteException {
        try {
            String remoteIps = "";
            String[] ips = shutdown.getRemoteIps().split(",");
            SSHInfoDao dao = new SSHInfoDao();
            int i = 0;
            while (i < ips.length) {
                SSHInfo info = dao.getSSHInfos(ips[i]);
                if (info == null) {
                    remoteIps = String.valueOf(remoteIps) + ips[i];
                    if (i != ips.length - 1) {
                        remoteIps = String.valueOf(remoteIps) + ",";
                    }
                }
                ++i;
            }
            if (remoteIps.trim().length() > 0) {
                shutdown.setRemoteIps(remoteIps);
            }
            PropertiesUtils.updateProperties(shutdown);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return shutdown;
    }

    public boolean setSSHInfos(SSHInfo info) {
        boolean result = false;
        try {
            SSHInfoDao dao = new SSHInfoDao();
            result = dao.addInfo(info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean setBuyInfo(String portName, BuyInfo buyInfo) throws RemoteException {
        boolean result = false;
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                if (processor instanceof PMV_JProcessor) {
                    String sn = buyInfo.getUpspn();
                    ((PMV_JProcessor)processor).setSN2UPS(sn);
                }
                buyInfo.setDeviceId(processor.getDeviceId());
                buyInfo.setPortName(processor.getDeviceName());
                buyInfo.setPtid(processor.getProtocol().getProtocolID());
                BatteryWarnDao dao = new BatteryWarnDao();
                result = dao.updateBuyInfo(buyInfo);
                if (result) {
                    processor.setBuyInfo(buyInfo);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String setDefault(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.setDefault();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }

    public RemoteShutdown defaultRemoteShutdown() throws RemoteException {
        RemoteShutdown shutdown = new RemoteShutdown();
        return shutdown;
    }

    public void updateIpAddress(String ip) throws RemoteException {
        try {
            String upsTreeIpAddress = PropertiesUtils.getProperty("upsTreeIpAddress");
            ArrayList<String> list = this.getIpAddress();
            String result = "";
            result = list.contains(ip) ? upsTreeIpAddress : (upsTreeIpAddress != null && !"".equals(upsTreeIpAddress) ? String.valueOf(upsTreeIpAddress) + ";" + ip : String.valueOf(upsTreeIpAddress) + ip);
            SystemEnv.refreshTree = MyConstants.getRefreshTree();
            PropertiesUtils.updateProperty("upsTreeIpAddress", result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ArrayList<String> getIpAddress() throws RemoteException {
        ArrayList<String> ipList = new ArrayList<String>();
        try {
            String upsTreeIpAddress = PropertiesUtils.getProperty("upsTreeIpAddress");
            if (upsTreeIpAddress != null && !"".equals(upsTreeIpAddress)) {
                String[] s = upsTreeIpAddress.split(";");
                int i = 0;
                while (i < s.length) {
                    ipList.add(s[i]);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ipList;
    }

    public void deleteIpAddress(String ip) throws RemoteException {
        block11: {
            try {
                ArrayList<String> oldIps = this.getIpAddress();
                String newIps = "";
                if (oldIps.contains(ip)) {
                    int i = 0;
                    while (i < oldIps.size()) {
                        if (((String)oldIps.get(i)).equals(ip)) {
                            oldIps.remove(i);
                            int j = 0;
                            while (j < oldIps.size()) {
                                if (j < oldIps.size() - 1) {
                                    newIps = String.valueOf(newIps) + (String)oldIps.get(j) + ";";
                                } else if (j == oldIps.size() - 1) {
                                    newIps = String.valueOf(newIps) + (String)oldIps.get(j);
                                }
                                ++j;
                            }
                            try {
                                PropertiesUtils.updateProperty("upsTreeIpAddress", newIps);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            break block11;
                        }
                        ++i;
                    }
                    break block11;
                }
                System.out.println("IP\u5730\u5740\u4e0d\u5b58\u5728\uff01");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addTrapIpAddress(String ip1, String ip2) {
        System.out.println("ip1:" + ip1 + "   ip2:" + ip2);
    }

    public BatLowVoltage getBatLow(String portName) throws RemoteException {
        BatLowVoltage batlow = null;
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                batlow = processor.getBatLow();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (batlow == null) {
            batlow = new BatLowVoltage();
        }
        return batlow;
    }

    public boolean setBatLow(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatLow(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setPBT(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPBT(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean setPGR(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPGR(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String queryQBT(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.queryQBT();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String queryQGR(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.queryQGR();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String setBatMaxBakTime(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatMaxBakTime(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public int getBatMaxBakTime(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getBatMaxBakTime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public String setBatLowCapacity(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatLowCapacity(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatLowVoltage(String portName, double value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatLowVoltage(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatMinCutOffVol(String portName, double value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatMinCutOffVol(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatShutdownCapacity(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatShutdownCapacity(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatShutdownDelay(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatShutdownDelay(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatTestStopCapacity(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatTestStopCapacity(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatTestStopTime(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatTestStopTime(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBatTestStopVol(String portName, double value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBatTestStopVol(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setChargingCurrent(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setChargingCurrent(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setConverterModeOutFre(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setConverterModeOutFre(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setEpoFunction(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setEpoFunction(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPeriodSelfTest(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPeriodSelfTest(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setTotalCapacity(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setTotalCapacity(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public ParameterSettings getParameterSettings(String portName) {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.getParameterSettings();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String setBID(String portName, String id, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBID(id, selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBMD(String portName, String id, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBMD(id, selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSCB(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSCB(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSID(String portName, String id, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSID(id, selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSMD(String portName, String id, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSMD(id, selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public Date queryBID(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.queryBID(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public Date queryBMD(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.queryBMD(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public Date querySID(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.querySID(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public Date querySMD(String portName, String value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.querySMD(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Date();
    }

    public String querySCB(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.querySCB();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String querySPR(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.querySPR();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String setBATAH(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBATAH(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setBaud(String portName, int value) throws Exception {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setBaud(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setCFTD(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.setCFTD();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }

    public String setCHMC(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setCHMC(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setCHTC(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setCHTC(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setCLDL(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setCLDL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setMADD(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setMADD(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPFTD(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPFTD();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPLFH(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPLFH(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPLFL(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPLFL(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPLVH(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPLVH(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setPLVL(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setPLVL(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setREEP(String portName) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setREEP();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBDT(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBDT(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBHV(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBHV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBNV(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBNV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBSV(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBSV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBTT(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBTT(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBTV(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBTV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSIPT(String portName, int value1, int value2) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSIPT(value1, value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSIPV(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSIPV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSOPF(String portName, float value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSOPF(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSOPT(String portName, int value1, int value2) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSOPT(value1, value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSSTN(String portName, int value1, int value2) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSSTN(value1, value2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSTIME(String portName, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSTIME(selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSVOL(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSVOL(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSOPV(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSOPV(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSPWIT(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSPWIT(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSPWID(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSPWID(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSBLF(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSBLF(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSMOD(String portName, int value) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSMOD(value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSDATE(String portName, String id, Date selectDate) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSDATE(id, selectDate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public String setSABTP(String portName, int type, int weekday, int hour, int minute, int month, int day) throws RemoteException {
        try {
            MonitorProcessor processor = this.getMoniotrProcesser(portName);
            if (processor != null) {
                return processor.setSABTP(type, weekday, hour, minute, month, day);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "failure";
    }

    public LineVoltage getLine(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.getLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Date queryTIME(String portName) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(portName);
        if (processer != null) {
            try {
                return processer.queryTIME();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int getOutputSocketDelayTime2(String portName, String socketNum) throws RemoteException {
        return this.getOutputSocketDelayTime(portName, socketNum);
    }

    public String removeRemoteIP(String ip) throws RemoteException {
        SSHInfoDao dao = new SSHInfoDao();
        dao.removeRemoteIP(ip);
        return "success";
    }

    public String setBATT(String arg0, int arg1) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(arg0);
        if (processer != null) {
            try {
                return processer.setBATT(arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String setBULKV(String arg0, float arg1) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(arg0);
        if (processer != null) {
            try {
                return processer.setBULKV(arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String setCTFT(String arg0, int arg1) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(arg0);
        if (processer != null) {
            try {
                return processer.setCTFT(arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String setFLATV(String arg0, float arg1) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(arg0);
        if (processer != null) {
            try {
                return processer.setFLATV(arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String setUSID(String arg0, String arg1) throws RemoteException {
        MonitorProcessor processer = this.getMoniotrProcesser(arg0);
        if (processer != null) {
            try {
                return processer.setUSID(arg1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String setNewParameter(String portName, String type, String value) throws RemoteException {
        MonitorProcessor processer;
        if (portName.equals("Config")) {
            if (type.equals("systempwd")) {
                if (ConfigDao.updateValue(type, value = AES128CBC.encryptWithoutPrivateKey(value))) {
                    return "success";
                }
                return "failure";
            }
            if (type.equals("linuxCMD")) {
                try {
                    PropertiesUtils.updateProperty("Shutdownconfigure.linuxCMD", value);
                    PropertiesUtils.getShutdownconfigure().setLinuxCMD(value);
                    return "SUCCESS";
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return "failure";
                }
            }
        }
        if ((processer = this.getMoniotrProcesser(portName)) != null) {
            try {
                String res = processer.setNewParameter(type, value);
                if (res.toUpperCase().contentEquals("(ACK") || res.toUpperCase().contentEquals("SUCCESS")) {
                    return "success";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "failure";
    }
}

