/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorconstants;

import cn.com.voltronic.util.MathUtils;
import cn.com.voltronicpower.configure.Config;
import cn.com.voltronicpower.constants.SimConstants;
import cn.com.voltronicpower.data.bean.AutoMenuItem;
import cn.com.voltronicpower.data.bean.WorkInfo;
import cn.com.voltronicpower.utilities.PropertiesUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MyConstants
extends SimConstants {
    public static final String HTTP = "HTTP/1.1";
    public static final String AJP = "AJP/1.3";
    public static final String SHUTDOWN = "SHUTDOWN";
    public static final String LOCAL = "Local";
    public static final String IPALL = "0.0.0.0";
    public static final String nextVision = "NEXTVision";
    public static final String EVI = "EVI";
    public static final String forza = "Forza";
    public static final String INFOPOWER = "InfoPower";
    public static final String NETGUARD = "NetGuard";
    public static final String WATTBOX = "WattBox";
    public static final String UPSMON = "UPSMon";
    public static final String ATMUSE = "ATMUSE";
    public static final String Ladis = "Ladis";
    public static final String TecnoManager = "TecnoManager";
    public static String Customized = Config.getString("Customized");
    public static final String VIEWPOWER_NAME = Config.getString("viewpowername", "ViewPower");
    public static final String SELECT_DEVICE = Config.getString("DeviceSelect", "1");
    public static String BACKUPSTR = String.valueOf(System.getProperty("user.dir")) + File.separator + "BackupFiles";
    public static final boolean SHOW_NET_SNMP = Config.getBoolean("showNetSNMP");
    public static final boolean USE_SNMP = Config.getBoolean("useSNMP");
    public static final String SERVER_NAME = Config.getString("servername", "ViewPower");
    public static final String TOMCAT_SERVICE_NAME = "upsTomcat";
    public static final String UPSMONITOR_SERVICE_NAME = "upsMonitor";
    public static final String UPDATE_UPS_PROPERTIES = "updateUPS";
    public static final String UPDATE_VIEWPOWER_PROPERTIES = "updateVIEWPOWER";
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String managerCode = "administrator";
    public static final boolean enableHTTPS = Config.getBoolean("enableHTTPS");
    public static final int SERVER_PORT = Config.getInteger("port");

    public static String getPicPath(String filename) {
        String path = String.valueOf(System.getProperty("user.dir")) + FILE_SEPARATOR + "console" + FILE_SEPARATOR + "images" + FILE_SEPARATOR + filename;
        return path;
    }

    public static String getOnLineHelpPath(String filename) {
        String path = String.valueOf(System.getProperty("user.dir")) + FILE_SEPARATOR + "tomcat" + FILE_SEPARATOR + "webapps" + FILE_SEPARATOR + SERVER_NAME + FILE_SEPARATOR + filename;
        return path;
    }

    public static String getAppMonitor() {
        return MyConstants.getPicPath("appMonitor.gif");
    }

    public static String getAppNone() {
        return MyConstants.getPicPath("appNone.gif");
    }

    public static String getMonitorDown() {
        return MyConstants.getPicPath("monitorDown.gif");
    }

    public static String getServerMonitor() {
        return MyConstants.getPicPath("serverMonitor.gif");
    }

    public static String getServerNone() {
        return MyConstants.getPicPath("serverNone.gif");
    }

    public static String getTempUnit() {
        String unitText = " \u2103";
        if (!"celsius".equals(PropertiesUtils.getGlobalConfig().getTemperature())) {
            unitText = " \u2109";
        }
        return unitText;
    }

    public static void doTemperature(WorkInfo workInfo) {
        if (workInfo.getWorkMode() != null && workInfo.getWorkMode().length() > 0 && !"celsius".equals(PropertiesUtils.getGlobalConfig().getTemperature())) {
            try {
                float v = Float.parseFloat(workInfo.getTemperature());
                float temp = (float)((double)v * 1.8 + 32.0);
                workInfo.setTemperatureView(String.valueOf(MathUtils.round((double)temp, (int)1)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getTempForSnmpEnv(String temperature) {
        if (!"celsius".equals(PropertiesUtils.getGlobalConfig().getTemperature())) {
            float temp = 0.0f;
            try {
                float v = Float.parseFloat(temperature);
                temp = (float)((double)v * 1.8 + 32.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return String.valueOf(MathUtils.round((double)temp, (int)1));
        }
        return temperature;
    }

    public static void doTemperatureTaurus(WorkInfo workInfo, String proID) {
        if (workInfo.getWorkMode() != null && workInfo.getWorkMode().length() > 0 && !"celsius".equals(PropertiesUtils.getGlobalConfig().getTemperature())) {
            try {
                float battery = Float.parseFloat(workInfo.getTemperature());
                float temp = (float)((double)battery * 1.8 + 32.0);
                workInfo.setTemperatureView(String.valueOf(MathUtils.round((double)temp, (int)1)));
                if ("MODBUS".equals(proID)) {
                    float rectifier = Float.parseFloat(workInfo.getRectifierHt());
                    temp = (float)((double)rectifier * 1.8 + 32.0);
                    workInfo.setRectifierHtView(String.valueOf(MathUtils.round((double)temp, (int)1)));
                    float inverter = Float.parseFloat(workInfo.getInverterHT());
                    temp = (float)((double)inverter * 1.8 + 32.0);
                    workInfo.setInverterHTView(String.valueOf(MathUtils.round((double)temp, (int)1)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getCustomerViewpower() {
        String localLanguage = PropertiesUtils.getGlobalConfig().getLanguage();
        String config = "[label.config]";
        String viewpower = VIEWPOWER_NAME;
        if (localLanguage.equalsIgnoreCase("en_US") || localLanguage.equalsIgnoreCase("de_DE") || localLanguage.equalsIgnoreCase("TUR") || localLanguage.equalsIgnoreCase("zh_CN")) {
            if (WATTBOX.equals(viewpower)) {
                viewpower = "Monitor";
            }
            return String.valueOf(viewpower) + " " + config;
        }
        return String.valueOf(config) + " " + viewpower;
    }

    public static List<AutoMenuItem> getOnlineHelp() {
        ArrayList<AutoMenuItem> systemhelp = new ArrayList<AutoMenuItem>();
        if (Config.getBoolean("showEnglish")) {
            systemhelp.add(new AutoMenuItem("English", "systemHelp_en", "", "help"));
        }
        if (Config.getBoolean("showChinese")) {
            systemhelp.add(new AutoMenuItem("Chinese", "systemHelp_zh", "", "help"));
        }
        if (Config.getBoolean("showTurkish")) {
            systemhelp.add(new AutoMenuItem("Turkish", "systemHelp_tu", "", "help"));
        }
        if (Config.getBoolean("showRussian")) {
            systemhelp.add(new AutoMenuItem("Russian", "systemHelp_ru", "", "help"));
        }
        if (Config.getBoolean("showTraditional")) {
            systemhelp.add(new AutoMenuItem("Chinese(Traditional)", "systemHelp_tw", "", "help"));
        }
        return systemhelp;
    }

    public static String getRefreshTree() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String time = df.format(new Date());
        return time;
    }

    public static String getProtocolID(String str) {
        if ("0".equals(str)) {
            return "SNMPP00";
        }
        if ("1".equals(str)) {
            return "SNMPP01";
        }
        if ("2".equals(str)) {
            return "SNMPP02";
        }
        if ("3".equals(str)) {
            return "SNMPP03";
        }
        if ("8".equals(str)) {
            return "SNMPP08";
        }
        if ("99".equals(str)) {
            return "SNMPPMV";
        }
        if ("80".equals(str)) {
            return "SEC";
        }
        return "";
    }
}

