/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UdpClient {
    private String ip = "";
    private String port = "51220";
    private DatagramSocket ds = null;
    private InetAddress inetAddress;

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return Integer.parseInt(this.port);
    }

    public UdpClient(String ip) throws SocketException, UnknownHostException {
        this.ip = ip;
        this.ds = new DatagramSocket();
        this.ds.setSoTimeout(1000);
        this.inetAddress = InetAddress.getByName(this.getIp());
    }

    public byte[] receive() throws IOException {
        byte[] buffer = new byte[64];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        return buffer;
    }

    public void disconnect() {
        this.ds.disconnect();
        this.ds.close();
    }

    public void send(String cmd) throws IOException {
        cmd = String.valueOf(cmd) + '\r';
        byte[] cmdb = cmd.getBytes();
        DatagramPacket dp = new DatagramPacket(cmdb, cmdb.length, this.inetAddress, this.getPort());
        this.ds.send(dp);
    }

    public static void main(String[] args) {
        try {
            UdpClient udp = new UdpClient("192.168.104.132");
            udp.setPort("31234");
            udp.send("shutdown##true");
            while (true) {
                try {
                    while (true) {
                        System.out.println(new String(udp.receive()));
                    }
                }
                catch (Exception e) {
                    System.out.println(new String(udp.receive()));
                    continue;
                }
                break;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

