/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorcommunicate.SECFormat;
import cn.com.voltronicpower.utilities.CRCUtil;
import cn.com.voltronicpower.utilities.CheckSumUtil;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.SaveEvent;
import cn.com.voltronicpower.utilities.VolUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import usb.IUSBComm;
import usb.USBCommEx;

public class USBHandler
implements CommunicateHandlerInterface {
    private static final Log logger = new Log();
    private boolean test = false;
    private boolean useCRC = false;
    private boolean useCheckSum = false;
    private String usbId;
    public Map<String, String> maps = new HashMap<String, String>();
    private IUSBComm usbComm;

    public String getUsbId() {
        return this.usbId;
    }

    public void initMap() {
        this.maps.put("M", "J");
        this.maps.put("QS", "(208.4 140.0 208.4 034 59.9 52.8 35.0 00110000");
        this.maps.put("F", "(220.0 220.0 72.00 50.0");
        this.maps.put("QI", "(99 7000 50.0 34 220 222 v1.00 0000100000000000");
        this.maps.put("BL?", "99");
        this.maps.put("FW?", "Ver00.01");
        this.maps.put("FW2?", "Ver00.01");
        this.maps.put("FW3?", "Ver99.10");
        this.maps.put("I", "#MMMMMMMMMMMMMMM 1500VA");
        this.maps.put("QLED", "(1 1 3 5 3 000255078255000001000255000");
        this.maps.put("QF", "(1500 100 05 0 1 0");
        this.maps.put("G", "(#1234567890987654321");
    }

    public String getRet(String key) {
        return this.maps.get(key);
    }

    public void setUsbId(String usbId) {
        this.usbId = usbId;
    }

    public USBHandler(IUSBComm usbComm, String usbId) {
        this.usbComm = usbComm;
        this.usbId = usbId;
        if (this.test) {
            this.initMap();
        }
    }

    public synchronized String excuteSimpleCommand(String command) throws IOException {
        if (this.test) {
            System.err.println("\u8fd9\u662fUSB\u6570\u636e\u6d4b\u8bd5\u6a21\u5f0f\uff0c\u8bf7\u6ce8\u610f\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01" + command);
            return this.getRet(command);
        }
        String returnValue = "";
        if (command.contains("SEC_")) {
            command = SECFormat.addPollHeader(command.substring(4));
        }
        if (this.useCRC) {
            String crc = CRCUtil.getCRC(command);
            command = String.valueOf(command) + crc;
        }
        int time = 0;
        while (returnValue.length() == 0 && time < 3) {
            returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
            ++time;
        }
        if (returnValue.length() == 0) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException();
        }
        if (command.startsWith("QMD")) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("usbId" + this.usbId + ",Command:" + command + "-----Return value:" + returnValue);
        }
        if (command.contains("^P") || command.contains("^S")) {
            returnValue = SECFormat.getNodeData(returnValue);
        }
        if (this.useCRC) {
            returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
        }
        if (this.useCheckSum) {
            returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
        }
        return returnValue;
    }

    public synchronized String excuteCommand(String command, boolean isResponse) throws IOException {
        String res = "";
        if (this.test) {
            res = this.getRet(command);
            if (res != null && !res.trim().equals("")) {
                return res;
            }
            if (command.equals("Q")) {
                String status = this.maps.get("QS");
                if (status.equals("(208.4 140.0 208.4 034 59.9 52.8 35.0 00110000")) {
                    this.maps.put("QS", "(208.4 140.0 208.4 034 59.9 52.8 35.0 00110001");
                } else if (status.equals("(208.4 140.0 208.4 034 59.9 52.8 35.0 00110001")) {
                    this.maps.put("QS", "(208.4 140.0 208.4 034 59.9 52.8 35.0 00110000");
                }
            }
            if (command.substring(0, command.length() - 1).equals("PLEDS")) {
                if (command.substring(command.length() - 1, command.length()).equals("0")) {
                    this.maps.put("QLED", "(1 0 3 5 3 000255078255000001000255000");
                    res = this.getRet("QLED");
                    if (res != null && !res.trim().equals("")) {
                        return res;
                    }
                } else {
                    if (command.substring(command.length() - 1, command.length()).equals("1")) {
                        return this.maps.put("QLED", "(1 1 3 5 3 000255078255000001000255000");
                    }
                    if (command.substring(command.length() - 1, command.length()).equals("2")) {
                        return this.maps.put("QLED", "(1 2 3 5 3 000255078255000001000255000");
                    }
                }
            }
            return null;
        }
        if (command.contains("SEC_")) {
            command = SECFormat.addPollHeader(command.substring(4));
        }
        if (this.useCRC) {
            String crc = CRCUtil.getCRC(command);
            command = String.valueOf(command) + crc;
        }
        String returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
        if (isResponse) {
            int time = 0;
            if (command.startsWith("QWS") && !VolUtil.isCorrectQWS(returnValue)) {
                returnValue = "";
            }
            while ((returnValue.length() == 0 || returnValue == null || returnValue.trim().equals("(NAK")) && time < 2) {
                returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r");
                if (command.startsWith("QWS") && !VolUtil.isCorrectQWS(returnValue)) {
                    returnValue = "";
                }
                ++time;
            }
            if (returnValue.length() == 0) {
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                }
                throw new IOException("\u901a\u8baf\u5f02\u5e38");
            }
        }
        if (command.startsWith("QMD") || command.startsWith("QMOD")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
        }
        if (command.contains("^P") || command.contains("^S")) {
            returnValue = SECFormat.getNodeData(returnValue);
        }
        if (this.useCRC) {
            returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
        }
        if (this.useCheckSum) {
            returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
        }
        return returnValue;
    }

    public synchronized void close() {
        if (this.usbComm != null) {
            try {
                this.usbComm.closeUSBPort(this.usbId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDeviceName() {
        return "USB" + this.usbId;
    }

    public static void main(String[] args) {
        USBCommEx usb = new USBCommEx();
        String dd = usb.findUSBDevices();
        String[] usbs = dd.split("#");
        USBHandler handler = new USBHandler(usb, usbs[0]);
        String qs = "QS";
        while (true) {
            try {
                while (true) {
                    String re = handler.excuteCommand(qs, true);
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void setCrcCheck(boolean arg0) {
        this.useCRC = arg0;
    }

    public void setCheckSum(boolean arg0) {
        this.useCheckSum = arg0;
    }

    public synchronized String excuteSetCommand(String command, boolean isResponse) throws IOException {
        String returnValue = "";
        if (isResponse) {
            int time = 0;
            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 2) {
                returnValue = SECFormat.getNodeData(this.usbComm.sendCommand(this.usbId, String.valueOf(SECFormat.addSetHeader(command)) + "\r"));
                ++time;
            }
            if (StringUtils.isEmpty((String)returnValue) || returnValue.length() == 0) {
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                }
                throw new IOException("\u901a\u8baf\u5f02\u5e38");
            }
        }
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
        }
        return returnValue;
    }

    public String excuteCommandP40(String command, boolean isResponse) throws IOException {
        if (command.contains("SEC_")) {
            command = String.valueOf(command) + "  ";
            command = SECFormat.addPollHeader(command.substring(4));
        }
        command = command.trim();
        String returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r", true);
        if (isResponse) {
            int time = 0;
            while (returnValue.length() == 0 && time < 2) {
                returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r", true);
                ++time;
            }
            if (returnValue.length() == 0) {
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                }
                throw new IOException("\u901a\u8baf\u5f02\u5e38");
            }
        }
        if (command.startsWith("QMD")) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
        }
        if (this.useCRC) {
            returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
        }
        if (this.useCheckSum) {
            returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
        }
        if (command.contains("^P") || command.contains("^S")) {
            returnValue = SECFormat.getNodeDataP40(returnValue);
        }
        return returnValue;
    }

    public String excuteSetCommandP40(String command, boolean isResponse) throws IOException {
        String returnValue = "";
        String senddata = SECFormat.addSetHeader(command);
        if (command.contains("SET_")) {
            command = String.valueOf(command) + "  ";
            senddata = SECFormat.addSetHeader(command.substring(4));
            senddata = senddata.trim();
        } else if (command.contains("SEC_")) {
            command = String.valueOf(command) + "  ";
            senddata = SECFormat.addSetHeader(command.substring(4));
            senddata = senddata.trim();
        }
        System.out.println("------------senddata:" + senddata);
        if (isResponse) {
            int time = 0;
            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 2) {
                returnValue = SECFormat.getNodeData(this.usbComm.sendCommand(this.usbId, String.valueOf(senddata) + "\r", true));
                ++time;
            }
            if (StringUtils.isEmpty((String)returnValue) || returnValue.length() == 0) {
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                }
                throw new IOException("\u901a\u8baf\u5f02\u5e38");
            }
        }
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
        }
        return returnValue;
    }

    public String excuteSimpleCommandP40(String command) throws IOException {
        String returnValue = "";
        try {
            if (command.contains("SEC_")) {
                command = String.valueOf(command) + "  ";
                command = SECFormat.addPollHeader(command.substring(4));
            }
            command = command.trim();
            int time = 0;
            while (returnValue.length() == 0 && time < 3) {
                returnValue = this.usbComm.sendCommand(this.usbId, String.valueOf(command) + "\r", true);
                ++time;
            }
            if (returnValue.length() == 0) {
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                }
                throw new IOException();
            }
            if (command.startsWith("QMD")) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
            }
            if (this.useCRC) {
                returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
            }
            if (this.useCheckSum) {
                returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
            }
            if (command.contains("^P") || command.contains("^S")) {
                returnValue = SECFormat.getNodeDataP40(returnValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return returnValue;
    }
}

