/*
 * Decompiled with CFR 0.152.
 */
package cn.com.voltronicpower.monitorcommunicate;

import cn.com.voltronicpower.communicate.CommunicateHandlerInterface;
import cn.com.voltronicpower.configure.SystemEnv;
import cn.com.voltronicpower.monitorcommunicate.SECFormat;
import cn.com.voltronicpower.monitorconstants.MyConstants;
import cn.com.voltronicpower.utilities.CRCUtil;
import cn.com.voltronicpower.utilities.CheckSumUtil;
import cn.com.voltronicpower.utilities.Log;
import cn.com.voltronicpower.utilities.SaveEvent;
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;

public class SerialPortHandler
implements CommunicateHandlerInterface {
    private static final Log logger = new Log();
    private boolean useCRC = false;
    private boolean useCheckSum = false;
    private InputStream input = null;
    private OutputStream output = null;
    private SerialPort serialPort;

    public SerialPortHandler(SerialPort serialPort) throws IOException {
        this.serialPort = serialPort;
        this.serialPort.setComPortParameters(2400, 8, 1, 0);
        this.serialPort.setComPortTimeouts(1, 1200, 0);
        this.input = serialPort.getInputStream();
        this.output = serialPort.getOutputStream();
    }

    private void clearbuffer2() {
        try {
            int buflen = this.input.available();
            while (buflen == 0) {
                int ch = this.input.read();
                if (ch == 13 || ch < 0) break;
            }
            Thread.sleep(5L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void clearbuffer() {
        try {
            int buflen = this.input.available();
            while (buflen > 0) {
                this.input.read();
                --buflen;
            }
            Thread.sleep(5L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void macWait() {
        if (MyConstants.IS_OS_MAC || MyConstants.IS_OS_MAC_OSX) {
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized String excuteSimpleCommand(String command) throws IOException {
        this.clearbuffer();
        if (command.contains("SEC_")) {
            command = SECFormat.addPollHeader(command.substring(4));
        }
        command = command.trim();
        if (this.useCRC) {
            byte[] crc = CRCUtil.getCRCByte(command);
            byte[] bytes = command.getBytes();
            this.output.write(bytes);
            this.output.write(crc);
            this.output.write(13);
        } else {
            byte[] bytes = command.getBytes();
            this.output.write(bytes);
            this.output.write(13);
        }
        this.macWait();
        this.output.flush();
        long end = System.currentTimeMillis() + 1000L;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() < end) {
            int ch = this.input.read();
            if (ch < 0) continue;
            if (ch != 13) {
                sb.append((char)ch);
                continue;
            }
            flag = true;
            break;
        }
        if (!flag) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException();
        }
        String returnValue = sb.toString();
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("SerialPort:" + this.serialPort.getSystemPortName() + ",Command:" + command + "-----Return value:" + returnValue);
        }
        if (this.useCRC) {
            returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
        }
        if (this.useCheckSum) {
            returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
        }
        if (command.contains("^P") || command.contains("^S")) {
            returnValue = SECFormat.getNodeData(returnValue);
        }
        logger.debug("\u8fd4\u56de\u7b80\u5355\u67e5\u8be2\u6570\u636e\uff1a" + returnValue);
        return returnValue;
    }

    public synchronized String excuteSimpleCommandP40(String command) throws IOException {
        this.clearbuffer();
        if (command.contains("SEC_")) {
            command = String.valueOf(command) + "  ";
            command = SECFormat.addPollHeader(command.substring(4));
        }
        command = command.trim();
        System.out.println("command40:" + command);
        if (this.useCRC) {
            byte[] crc = CRCUtil.getCRCByte(command);
            byte[] bytes = command.getBytes();
            this.output.write(bytes);
            this.output.write(crc);
            this.output.write(13);
        } else {
            byte[] bytes = command.getBytes();
            this.output.write(bytes);
            this.output.write(13);
        }
        this.macWait();
        this.output.flush();
        long end = System.currentTimeMillis() + 1000L;
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        while (System.currentTimeMillis() < end) {
            int ch = this.input.read();
            if (ch < 0) continue;
            if (ch != 13) {
                sb.append((char)ch);
                continue;
            }
            flag = true;
            break;
        }
        if (!flag) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException();
        }
        String returnValue = sb.toString();
        if (SystemEnv.IS_TEST_MODE) {
            SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
        }
        if ("(NAK".equals(returnValue)) {
            return "";
        }
        if (this.useCRC) {
            returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
        }
        if (this.useCheckSum) {
            returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
        }
        if (command.contains("^P") || command.contains("^S")) {
            returnValue = SECFormat.getNodeDataP40(returnValue);
        }
        logger.debug("\u8fd4\u56de\u7b80\u5355\u67e5\u8be2\u6570\u636e\uff1a" + returnValue);
        return returnValue;
    }

    public synchronized String excuteCommand(String command, boolean isResponse) throws IOException {
        try {
            this.clearbuffer();
            if (command.contains("SEC_")) {
                command = SECFormat.addPollHeader(command.substring(4));
            }
            command = command.trim();
            if (this.useCRC) {
                byte[] crc = CRCUtil.getCRCByte(command);
                byte[] bytes = command.getBytes();
                this.output.write(bytes);
                this.output.write(crc);
                this.output.write(13);
            } else {
                byte[] bytes = command.getBytes();
                this.output.write(bytes);
                this.output.write(13);
            }
            this.macWait();
            this.output.flush();
            logger.debug("\u53d1\u9001\u547d\u4ee4\uff1a" + command);
            if (isResponse) {
                long end = System.currentTimeMillis() + 3000L;
                StringBuilder sb = new StringBuilder();
                boolean flag = false;
                while (System.currentTimeMillis() < end) {
                    int ch = this.input.read();
                    if (ch < 0) continue;
                    if (ch != 13) {
                        sb.append((char)ch);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                    }
                    System.out.println(" \u8d85\u65f6 " + sb.toString());
                    throw new IOException("\u63a5\u6536\u8d85\u65f6");
                }
                String returnValue = sb.toString();
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
                }
                if (this.useCRC) {
                    returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
                }
                if (this.useCheckSum) {
                    returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
                }
                if (command.contains("^P") || command.contains("^S")) {
                    returnValue = SECFormat.getNodeData(returnValue);
                }
                return returnValue;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException("\u63a5\u6536\u8d85\u65f6");
        }
    }

    public synchronized String excuteCommandP40(String command, boolean isResponse) throws IOException {
        try {
            this.clearbuffer();
            if (command.contains("SEC_")) {
                command = String.valueOf(command) + "  ";
                command = SECFormat.addPollHeader(command.substring(4));
            }
            command = command.trim();
            if (this.useCRC) {
                byte[] crc = CRCUtil.getCRCByte(command);
                byte[] bytes = command.getBytes();
                this.output.write(bytes);
                this.output.write(crc);
                this.output.write(13);
            } else {
                byte[] bytes = command.getBytes();
                this.output.write(bytes);
                this.output.write(13);
            }
            this.macWait();
            this.output.flush();
            logger.debug("\u53d1\u9001\u547d\u4ee4\uff1a" + command);
            if (isResponse) {
                long end = System.currentTimeMillis() + 3000L;
                StringBuilder sb = new StringBuilder();
                boolean flag = false;
                while (System.currentTimeMillis() < end) {
                    int ch = this.input.read();
                    if (ch < 0) continue;
                    if (ch != 13) {
                        sb.append((char)ch);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                    }
                    System.out.println(" \u8d85\u65f6 " + sb.toString());
                    throw new IOException("\u63a5\u6536\u8d85\u65f6");
                }
                String returnValue = sb.toString();
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
                }
                if (this.useCRC) {
                    returnValue = CRCUtil.checkCRC(returnValue) ? returnValue.substring(0, returnValue.length() - 2) : "";
                }
                if (this.useCheckSum) {
                    returnValue = CheckSumUtil.doValidate(returnValue) ? returnValue.substring(0, returnValue.length() - 1) : "";
                }
                if (command.contains("^P") || command.contains("^S")) {
                    returnValue = SECFormat.getNodeDataP40(returnValue);
                }
                return returnValue;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException("\u63a5\u6536\u8d85\u65f6");
        }
    }

    public void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.output != null) {
            try {
                this.output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.serialPort != null && this.serialPort.isOpen()) {
            try {
                this.serialPort.closePort();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDeviceName() {
        String portName = this.serialPort.getSystemPortName();
        int index = portName.lastIndexOf("/");
        if (index > 0) {
            portName = portName.substring(index + 1, portName.length());
        }
        return portName;
    }

    public static void main(String[] args) {
        SerialPort[] comPorts = SerialPort.getCommPorts();
        SerialPort comPort = comPorts[0];
        String portname = comPort.getSystemPortName();
        if (comPort.openPort()) {
            try {
                SerialPortHandler serialPortHandler = new SerialPortHandler(comPort);
                boolean i = false;
                while (true) {
                    String QPI = serialPortHandler.excuteCommand("QPI", true);
                    System.out.println("-----------QPI-----:" + QPI);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setCrcCheck(boolean arg0) {
        this.useCRC = arg0;
    }

    public void setCheckSum(boolean arg0) {
        this.useCheckSum = arg0;
    }

    public synchronized String excuteSetCommand(String command, boolean isResponse) throws IOException {
        this.clearbuffer();
        String returnValue = "";
        String senddata = SECFormat.addSetHeader(command);
        if (command.contains("SEC_")) {
            senddata = SECFormat.addSetHeader(command.substring(4));
            senddata = senddata.trim();
        }
        int time = 0;
        try {
            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                if (this.useCRC) {
                    byte[] crc = CRCUtil.getCRCByte(senddata);
                    byte[] bytes = senddata.getBytes();
                    this.output.write(bytes);
                    this.output.write(crc);
                    this.output.write(13);
                } else {
                    byte[] bytes = senddata.getBytes();
                    this.output.write(bytes);
                    this.output.write(13);
                }
                this.macWait();
                this.output.flush();
                if (!isResponse) {
                    returnValue = null;
                    break;
                }
                long end = System.currentTimeMillis() + 3000L;
                StringBuilder sb = new StringBuilder();
                boolean flag = false;
                while (System.currentTimeMillis() < end) {
                    int ch = this.input.read();
                    if (ch < 0) continue;
                    if (ch != 13) {
                        sb.append((char)ch);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                    }
                    System.out.println(" \u8d85\u65f6 " + sb.toString());
                    throw new IOException("\u63a5\u6536\u8d85\u65f6");
                }
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
                }
                returnValue = sb.toString();
                returnValue = SECFormat.getNodeData(returnValue);
                ++time;
            }
        }
        catch (Exception ex) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException("\u63a5\u6536\u8d85\u65f6");
        }
        return returnValue;
    }

    public synchronized String excuteCommand(String command) throws IOException {
        String result = "";
        byte[] bytes = command.getBytes();
        try {
            String returnValue;
            this.clearbuffer();
            this.output.write(bytes);
            this.output.write(13);
            this.output.write(10);
            System.out.println("1");
            this.macWait();
            System.out.println(2);
            this.output.flush();
            logger.info("\u53d1\u9001\u547d\u4ee4\uff1a" + command);
            long end = System.currentTimeMillis() + 3000L;
            StringBuilder sb = new StringBuilder();
            while (System.currentTimeMillis() < end) {
                int ch = this.input.read();
                if (ch <= 0) continue;
                if (ch == 13) break;
                sb.append((char)ch);
            }
            result = returnValue = sb.toString();
            Thread.sleep(500L);
        }
        catch (Exception e) {
            logger.error(e.toString());
            throw new IOException("\u63a5\u6536\u8d85\u65f6");
        }
        return result;
    }

    public String excuteSetCommandP40(String command, boolean isResponse) throws IOException {
        this.clearbuffer();
        String returnValue = "";
        String senddata = SECFormat.addSetHeader(command);
        if (command.contains("SET_")) {
            command = String.valueOf(command) + "  ";
            senddata = SECFormat.addSetHeader(command.substring(4));
            senddata = senddata.trim();
        } else if (command.contains("SEC_")) {
            command = String.valueOf(command) + "  ";
            senddata = SECFormat.addSetHeader(command.substring(4));
            senddata = senddata.trim();
        }
        int time = 0;
        try {
            while ((StringUtils.isEmpty((String)returnValue) || returnValue.startsWith("(NAK")) && time < 3) {
                if (this.useCRC) {
                    byte[] crc = CRCUtil.getCRCByte(senddata);
                    byte[] bytes = senddata.getBytes();
                    this.output.write(bytes);
                    this.output.write(crc);
                    this.output.write(13);
                } else {
                    byte[] bytes = senddata.getBytes();
                    this.output.write(bytes);
                    this.output.write(13);
                }
                this.macWait();
                this.output.flush();
                if (!isResponse) {
                    returnValue = null;
                    break;
                }
                long end = System.currentTimeMillis() + 3000L;
                StringBuilder sb = new StringBuilder();
                boolean flag = false;
                while (System.currentTimeMillis() < end) {
                    int ch = this.input.read();
                    if (ch < 0) continue;
                    if (ch != 13) {
                        sb.append((char)ch);
                        continue;
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    if (SystemEnv.IS_TEST_MODE) {
                        SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
                    }
                    System.out.println(" \u8d85\u65f6 " + sb.toString());
                    throw new IOException("\u63a5\u6536\u8d85\u65f6");
                }
                if (SystemEnv.IS_TEST_MODE) {
                    SaveEvent.saveData("Command:" + command + "-----Return value:" + returnValue);
                }
                returnValue = sb.toString();
                System.out.println("---2---returnValue:" + returnValue);
                returnValue = SECFormat.getNodeData(returnValue);
                ++time;
            }
        }
        catch (Exception ex) {
            if (SystemEnv.IS_TEST_MODE) {
                SaveEvent.saveData("Command:" + command + "-----Exception: Receive time out!");
            }
            throw new IOException("\u63a5\u6536\u8d85\u65f6");
        }
        System.out.println("---3---returnValue:" + returnValue);
        return returnValue;
    }
}

